BEGIN TRANSACTION ;

ALTER TABLE blockchains RENAME TO TempOldBlockchains;

-- BLOCKCHAIN TABLE
CREATE TABLE IF NOT EXISTS blockchains (
  c                             FLOAT(1, 6),
  dt                            INT,
  ud0                           INT,
  sig_period                    INT,
  sig_stock                     INT,
  sig_window                    INT,
  idty_window                   INT,
  ms_window                     INT,
  sig_validity                  INT,
  sig_qty                       INT,
  xpercent                      FLOAT(1, 6),
  ms_validity                   INT,
  step_max                      INT,
  median_time_blocks            INT,
  avg_gen_time                  INT,
  dt_diff_eval                  INT,
  percent_rot                   FLOAT(1, 6),
  ud_time_0                     INT,
  ud_reeval_time_0              INT,
  dt_reeval                     INT,
  current_buid            INT,
  current_members_count   INT,
  current_mass            INT,
  median_time             INT,
  last_members_count      INT,
  last_ud                 INT,
  last_ud_base            INT,
  last_ud_time            INT,
  previous_mass           INT,
  previous_members_count  INT,
  previous_ud             INT,
  previous_ud_base        INT,
  previous_ud_time        INT,
  currency                VARCHAR(30),
  PRIMARY KEY (currency)
);

INSERT INTO blockchains (c,
                         dt,
                         ud0,
                         sig_period,
                         sig_stock,
                         sig_window,
                         idty_window,
                         ms_window,
                         sig_validity,
                         sig_qty,
                         xpercent,
                         ms_validity,
                         step_max,
                         median_time_blocks,
                         avg_gen_time,
                         dt_diff_eval,
                         percent_rot,
                         ud_time_0,
                         ud_reeval_time_0,
                         dt_reeval,
                         current_buid,
                         current_members_count,
                         current_mass,
                         median_time,
                         last_members_count,
                         last_ud,
                         last_ud_base,
                         last_ud_time,
                         previous_mass,
                         previous_members_count,
                         previous_ud,
                         previous_ud_base,
                         previous_ud_time,
                         currency)
SELECT c,
       dt,
       ud0,
       sig_period,
       sig_stock,
       sig_window,
       idty_window,
       ms_window,
       sig_validity,
       sig_qty,
       xpercent,
       ms_validity,
       step_max,
       median_time_blocks,
       avg_gen_time,
       dt_diff_eval,
       percent_rot,
       0,
       0,
       0,
       current_buid,
       current_members_count,
       current_mass,
       median_time,
       last_members_count,
       last_ud,
       last_ud_base,
       last_ud_time,
       previous_mass,
       previous_members_count,
       previous_ud,
       previous_ud_base,
       previous_ud_time,
       currency FROM TempOldBlockchains;

DROP TABLE TempOldBlockchains;

COMMIT;