import sys
from importlib import import_module


def cached_import(module_path, class_name):
    modules = sys.modules
    if module_path not in modules or (
        # Module is not fully initialized.
        getattr(
            modules[module_path], '__spec__',
            None
        ) is not None and
        getattr(
            modules[module_path].__spec__, '_initializing',
            False
        ) is True
    ):
        import_module(module_path)
    return getattr(modules[module_path], class_name)


def import_string(dotted_path):
    """
    Import a dotted module path and return the attribute/class designated
    by the last name in the path. Raise ImportError if the import failed.
    """
    try:
        module_path, class_name = dotted_path.rsplit('.', 1)
    except ValueError as err:
        raise ImportError("%s doesn't look like a module path" %
                          dotted_path) from err

    try:
        return cached_import(module_path, class_name)
    except AttributeError as err:
        raise ImportError(
            'Module "%s" does not define a "%s" attribute/class' %
            (module_path, class_name)) from err
