# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 account_key_pem: pulumi.Input[str],
                 cert_timeout: Optional[pulumi.Input[int]] = None,
                 certificate_p12_password: Optional[pulumi.Input[str]] = None,
                 certificate_request_pem: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 disable_complete_propagation: Optional[pulumi.Input[bool]] = None,
                 dns_challenges: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateDnsChallengeArgs']]]] = None,
                 http_challenge: Optional[pulumi.Input['CertificateHttpChallengeArgs']] = None,
                 http_memcached_challenge: Optional[pulumi.Input['CertificateHttpMemcachedChallengeArgs']] = None,
                 http_s3_challenge: Optional[pulumi.Input['CertificateHttpS3ChallengeArgs']] = None,
                 http_webroot_challenge: Optional[pulumi.Input['CertificateHttpWebrootChallengeArgs']] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 min_days_remaining: Optional[pulumi.Input[int]] = None,
                 must_staple: Optional[pulumi.Input[bool]] = None,
                 pre_check_delay: Optional[pulumi.Input[int]] = None,
                 preferred_chain: Optional[pulumi.Input[str]] = None,
                 recursive_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revoke_certificate_on_destroy: Optional[pulumi.Input[bool]] = None,
                 revoke_certificate_reason: Optional[pulumi.Input[str]] = None,
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_challenge: Optional[pulumi.Input['CertificateTlsChallengeArgs']] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[str] account_key_pem: The private key of the account that is
               requesting the certificate. Forces a new resource when changed.
        :param pulumi.Input[int] cert_timeout: Controls the timeout in seconds for certificate requests
               that are made after challenges are complete. Defaults to 30 seconds.
               
               > As mentioned, `cert_timeout` does nothing until all challenges are complete.
               If you are looking to control timeouts related to a particular challenge (such
               as a DNS challenge), see that challenge provider's specific options.
        :param pulumi.Input[str] certificate_p12_password: Password to be used when generating
               the PFX file stored in `certificate_p12`. Defaults to an
               empty string.
        :param pulumi.Input[str] certificate_request_pem: A pre-created certificate request, such as one
               from [`tls_cert_request`][tls-cert-request], or one from an external source,
               in PEM format.  Either this, or the in-resource request options
               (`common_name`, `key_type`, and optionally `subject_alternative_names`) need
               to be specified. Forces a new resource when changed.
        :param pulumi.Input[str] common_name: The certificate's common name, the primary domain that the
               certificate will be recognized for. Required when not specifying a CSR. Forces
               a new resource when changed.
        :param pulumi.Input[bool] disable_complete_propagation: Disable the requirement for full
               propagation of the TXT challenge records before proceeding with validation.
               Defaults to `false`.
               
               > See About DNS propagation checks for details
               on the `recursive_nameservers` and `disable_complete_propagation` settings.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateDnsChallengeArgs']]] dns_challenges: The DNS challenges to
               use in fulfilling the request.
        :param pulumi.Input['CertificateHttpChallengeArgs'] http_challenge: Defines an HTTP challenge to use in fulfilling
               the request.
        :param pulumi.Input['CertificateHttpMemcachedChallengeArgs'] http_memcached_challenge: Defines an alternate type of HTTP
               challenge that can be used to serve up challenges to a
               [Memcached](https://memcached.org/) cluster.
        :param pulumi.Input['CertificateHttpS3ChallengeArgs'] http_s3_challenge: Defines an alternate type of HTTP
               challenge that can be used to serve up challenges to a
               [S3](https://aws.amazon.com/s3/) bucket.
        :param pulumi.Input['CertificateHttpWebrootChallengeArgs'] http_webroot_challenge: Defines an alternate type of HTTP
               challenge that can be used to place a file at a location that can be served by
               an out-of-band webserver.
        :param pulumi.Input[str] key_type: The key type for the certificate's private key. Can be one of:
               `P256` and `P384` (for ECDSA keys of respective length) or `2048`, `4096`, and
               `8192` (for RSA keys of respective length). Required when not specifying a
               CSR. The default is `2048` (RSA key of 2048 bits). Forces a new resource when
               changed.
        :param pulumi.Input[int] min_days_remaining: The minimum amount of days remaining on the
               expiration of a certificate before a renewal is attempted. The default is
               `30`. A value of less than `0` means that the certificate will never be
               renewed.
        :param pulumi.Input[bool] must_staple: Enables the [OCSP Stapling Required][ocsp-stapling]
               TLS Security Policy extension. Certificates with this extension must include a
               valid OCSP Staple in the TLS handshake for the connection to succeed.
               Defaults to `false`. Note that this option has no effect when using an
               external CSR - it must be enabled in the CSR itself. Forces a new resource
               when changed.
               
               [ocsp-stapling]: https://letsencrypt.org/docs/integration-guide/#implement-ocsp-stapling
               
               > OCSP stapling requires specific webserver configuration to support the
               downloading of the staple from the CA's OCSP endpoints, and should be configured
               to tolerate prolonged outages of the OCSP service. Consider this when using
               `must_staple`, and only enable it if you are sure your webserver or service
               provider can be configured correctly.
        :param pulumi.Input[int] pre_check_delay: Insert a delay after _every_ DNS challenge
               record to allow for extra time for DNS propagation before the certificate is
               requested. Use this option if you observe issues with requesting certificates
               even when DNS challenge records get added successfully. Units are in seconds.
               Defaults to 0 (no delay).
               
               > Be careful with `pre_check_delay` since the delay is executed _per-domain_.
               Take your expected delay and divide it by the number of domains you have
               configured (`common_name` + `subject_alternative_names`).
        :param pulumi.Input[str] preferred_chain: The common name of the root of a preferred
               alternate certificate chain offered by the CA. The certificates in
               `issuer_pem` will reflect the chain requested, if available, otherwise the
               default chain will be provided. Forces a new resource when changed.
               
               > `preferred_chain` can be used to request alternate chains on Let's Encrypt
               during the transition away from their old cross-signed intermediates. See [this
               article for more
               details](https://letsencrypt.org/2020/12/21/extending-android-compatibility.html).
               In their example titled **"What about the alternate chain?"**, the root you
               would put in to the `preferred_chain` field would be `ISRG Root X1`. The
               equivalent in the [staging
               environment](https://letsencrypt.org/docs/staging-environment/) is `(STAGING)
               Pretend Pear X1`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] recursive_nameservers: The recursive nameservers that will be
               used to check for propagation of DNS challenge records, in addition to some
               in-provider checks such as zone detection. Defaults to your system-configured
               DNS resolvers.
        :param pulumi.Input[bool] revoke_certificate_on_destroy: Enables revocation of a certificate upon destroy,
               which includes when a resource is re-created. Default is `true`.
        :param pulumi.Input[str] revoke_certificate_reason: Some CA's require a reason for revocation to be provided.
               Use this reason (from [RFC 5280, section 5.3.1](https://www.rfc-editor.org/rfc/rfc5280#section-5.3.1).
               By default, no reason provided in revocation requests. The reason is a string, when provided should be one of:
               * unspecified
               * key-compromise
               * ca-compromise
               * affiliation-changed
               * superseded
               * cessation-of-operation
               * certificate-hold
               * remove-from-crl
               * privilege-withdrawn
               * aa-compromise
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alternative_names: The certificate's subject alternative names,
               domains that this certificate will also be recognized for. Only valid when not
               specifying a CSR. Forces a new resource when changed.
        :param pulumi.Input['CertificateTlsChallengeArgs'] tls_challenge: Defines a TLS challenge to use in fulfilling the
               request.
               
               > Only one of `http_challenge`, `http_webroot_challenge`, `http_s3_challenge`
               and `http_memcached_challenge` can be defined at once. See the section on
               Using HTTP and TLS challenges for more
               details on using these and `tls_challenge`.
        """
        pulumi.set(__self__, "account_key_pem", account_key_pem)
        if cert_timeout is not None:
            pulumi.set(__self__, "cert_timeout", cert_timeout)
        if certificate_p12_password is not None:
            pulumi.set(__self__, "certificate_p12_password", certificate_p12_password)
        if certificate_request_pem is not None:
            pulumi.set(__self__, "certificate_request_pem", certificate_request_pem)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if disable_complete_propagation is not None:
            pulumi.set(__self__, "disable_complete_propagation", disable_complete_propagation)
        if dns_challenges is not None:
            pulumi.set(__self__, "dns_challenges", dns_challenges)
        if http_challenge is not None:
            pulumi.set(__self__, "http_challenge", http_challenge)
        if http_memcached_challenge is not None:
            pulumi.set(__self__, "http_memcached_challenge", http_memcached_challenge)
        if http_s3_challenge is not None:
            pulumi.set(__self__, "http_s3_challenge", http_s3_challenge)
        if http_webroot_challenge is not None:
            pulumi.set(__self__, "http_webroot_challenge", http_webroot_challenge)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if min_days_remaining is not None:
            pulumi.set(__self__, "min_days_remaining", min_days_remaining)
        if must_staple is not None:
            pulumi.set(__self__, "must_staple", must_staple)
        if pre_check_delay is not None:
            pulumi.set(__self__, "pre_check_delay", pre_check_delay)
        if preferred_chain is not None:
            pulumi.set(__self__, "preferred_chain", preferred_chain)
        if recursive_nameservers is not None:
            pulumi.set(__self__, "recursive_nameservers", recursive_nameservers)
        if revoke_certificate_on_destroy is not None:
            pulumi.set(__self__, "revoke_certificate_on_destroy", revoke_certificate_on_destroy)
        if revoke_certificate_reason is not None:
            pulumi.set(__self__, "revoke_certificate_reason", revoke_certificate_reason)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if tls_challenge is not None:
            pulumi.set(__self__, "tls_challenge", tls_challenge)

    @property
    @pulumi.getter(name="accountKeyPem")
    def account_key_pem(self) -> pulumi.Input[str]:
        """
        The private key of the account that is
        requesting the certificate. Forces a new resource when changed.
        """
        return pulumi.get(self, "account_key_pem")

    @account_key_pem.setter
    def account_key_pem(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_key_pem", value)

    @property
    @pulumi.getter(name="certTimeout")
    def cert_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Controls the timeout in seconds for certificate requests
        that are made after challenges are complete. Defaults to 30 seconds.

        > As mentioned, `cert_timeout` does nothing until all challenges are complete.
        If you are looking to control timeouts related to a particular challenge (such
        as a DNS challenge), see that challenge provider's specific options.
        """
        return pulumi.get(self, "cert_timeout")

    @cert_timeout.setter
    def cert_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cert_timeout", value)

    @property
    @pulumi.getter(name="certificateP12Password")
    def certificate_p12_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to be used when generating
        the PFX file stored in `certificate_p12`. Defaults to an
        empty string.
        """
        return pulumi.get(self, "certificate_p12_password")

    @certificate_p12_password.setter
    def certificate_p12_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_p12_password", value)

    @property
    @pulumi.getter(name="certificateRequestPem")
    def certificate_request_pem(self) -> Optional[pulumi.Input[str]]:
        """
        A pre-created certificate request, such as one
        from [`tls_cert_request`][tls-cert-request], or one from an external source,
        in PEM format.  Either this, or the in-resource request options
        (`common_name`, `key_type`, and optionally `subject_alternative_names`) need
        to be specified. Forces a new resource when changed.
        """
        return pulumi.get(self, "certificate_request_pem")

    @certificate_request_pem.setter
    def certificate_request_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_request_pem", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate's common name, the primary domain that the
        certificate will be recognized for. Required when not specifying a CSR. Forces
        a new resource when changed.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="disableCompletePropagation")
    def disable_complete_propagation(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable the requirement for full
        propagation of the TXT challenge records before proceeding with validation.
        Defaults to `false`.

        > See About DNS propagation checks for details
        on the `recursive_nameservers` and `disable_complete_propagation` settings.
        """
        return pulumi.get(self, "disable_complete_propagation")

    @disable_complete_propagation.setter
    def disable_complete_propagation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_complete_propagation", value)

    @property
    @pulumi.getter(name="dnsChallenges")
    def dns_challenges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateDnsChallengeArgs']]]]:
        """
        The DNS challenges to
        use in fulfilling the request.
        """
        return pulumi.get(self, "dns_challenges")

    @dns_challenges.setter
    def dns_challenges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateDnsChallengeArgs']]]]):
        pulumi.set(self, "dns_challenges", value)

    @property
    @pulumi.getter(name="httpChallenge")
    def http_challenge(self) -> Optional[pulumi.Input['CertificateHttpChallengeArgs']]:
        """
        Defines an HTTP challenge to use in fulfilling
        the request.
        """
        return pulumi.get(self, "http_challenge")

    @http_challenge.setter
    def http_challenge(self, value: Optional[pulumi.Input['CertificateHttpChallengeArgs']]):
        pulumi.set(self, "http_challenge", value)

    @property
    @pulumi.getter(name="httpMemcachedChallenge")
    def http_memcached_challenge(self) -> Optional[pulumi.Input['CertificateHttpMemcachedChallengeArgs']]:
        """
        Defines an alternate type of HTTP
        challenge that can be used to serve up challenges to a
        [Memcached](https://memcached.org/) cluster.
        """
        return pulumi.get(self, "http_memcached_challenge")

    @http_memcached_challenge.setter
    def http_memcached_challenge(self, value: Optional[pulumi.Input['CertificateHttpMemcachedChallengeArgs']]):
        pulumi.set(self, "http_memcached_challenge", value)

    @property
    @pulumi.getter(name="httpS3Challenge")
    def http_s3_challenge(self) -> Optional[pulumi.Input['CertificateHttpS3ChallengeArgs']]:
        """
        Defines an alternate type of HTTP
        challenge that can be used to serve up challenges to a
        [S3](https://aws.amazon.com/s3/) bucket.
        """
        return pulumi.get(self, "http_s3_challenge")

    @http_s3_challenge.setter
    def http_s3_challenge(self, value: Optional[pulumi.Input['CertificateHttpS3ChallengeArgs']]):
        pulumi.set(self, "http_s3_challenge", value)

    @property
    @pulumi.getter(name="httpWebrootChallenge")
    def http_webroot_challenge(self) -> Optional[pulumi.Input['CertificateHttpWebrootChallengeArgs']]:
        """
        Defines an alternate type of HTTP
        challenge that can be used to place a file at a location that can be served by
        an out-of-band webserver.
        """
        return pulumi.get(self, "http_webroot_challenge")

    @http_webroot_challenge.setter
    def http_webroot_challenge(self, value: Optional[pulumi.Input['CertificateHttpWebrootChallengeArgs']]):
        pulumi.set(self, "http_webroot_challenge", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The key type for the certificate's private key. Can be one of:
        `P256` and `P384` (for ECDSA keys of respective length) or `2048`, `4096`, and
        `8192` (for RSA keys of respective length). Required when not specifying a
        CSR. The default is `2048` (RSA key of 2048 bits). Forces a new resource when
        changed.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="minDaysRemaining")
    def min_days_remaining(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of days remaining on the
        expiration of a certificate before a renewal is attempted. The default is
        `30`. A value of less than `0` means that the certificate will never be
        renewed.
        """
        return pulumi.get(self, "min_days_remaining")

    @min_days_remaining.setter
    def min_days_remaining(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_days_remaining", value)

    @property
    @pulumi.getter(name="mustStaple")
    def must_staple(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables the [OCSP Stapling Required][ocsp-stapling]
        TLS Security Policy extension. Certificates with this extension must include a
        valid OCSP Staple in the TLS handshake for the connection to succeed.
        Defaults to `false`. Note that this option has no effect when using an
        external CSR - it must be enabled in the CSR itself. Forces a new resource
        when changed.

        [ocsp-stapling]: https://letsencrypt.org/docs/integration-guide/#implement-ocsp-stapling

        > OCSP stapling requires specific webserver configuration to support the
        downloading of the staple from the CA's OCSP endpoints, and should be configured
        to tolerate prolonged outages of the OCSP service. Consider this when using
        `must_staple`, and only enable it if you are sure your webserver or service
        provider can be configured correctly.
        """
        return pulumi.get(self, "must_staple")

    @must_staple.setter
    def must_staple(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_staple", value)

    @property
    @pulumi.getter(name="preCheckDelay")
    def pre_check_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Insert a delay after _every_ DNS challenge
        record to allow for extra time for DNS propagation before the certificate is
        requested. Use this option if you observe issues with requesting certificates
        even when DNS challenge records get added successfully. Units are in seconds.
        Defaults to 0 (no delay).

        > Be careful with `pre_check_delay` since the delay is executed _per-domain_.
        Take your expected delay and divide it by the number of domains you have
        configured (`common_name` + `subject_alternative_names`).
        """
        return pulumi.get(self, "pre_check_delay")

    @pre_check_delay.setter
    def pre_check_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pre_check_delay", value)

    @property
    @pulumi.getter(name="preferredChain")
    def preferred_chain(self) -> Optional[pulumi.Input[str]]:
        """
        The common name of the root of a preferred
        alternate certificate chain offered by the CA. The certificates in
        `issuer_pem` will reflect the chain requested, if available, otherwise the
        default chain will be provided. Forces a new resource when changed.

        > `preferred_chain` can be used to request alternate chains on Let's Encrypt
        during the transition away from their old cross-signed intermediates. See [this
        article for more
        details](https://letsencrypt.org/2020/12/21/extending-android-compatibility.html).
        In their example titled **"What about the alternate chain?"**, the root you
        would put in to the `preferred_chain` field would be `ISRG Root X1`. The
        equivalent in the [staging
        environment](https://letsencrypt.org/docs/staging-environment/) is `(STAGING)
        Pretend Pear X1`.
        """
        return pulumi.get(self, "preferred_chain")

    @preferred_chain.setter
    def preferred_chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_chain", value)

    @property
    @pulumi.getter(name="recursiveNameservers")
    def recursive_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The recursive nameservers that will be
        used to check for propagation of DNS challenge records, in addition to some
        in-provider checks such as zone detection. Defaults to your system-configured
        DNS resolvers.
        """
        return pulumi.get(self, "recursive_nameservers")

    @recursive_nameservers.setter
    def recursive_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "recursive_nameservers", value)

    @property
    @pulumi.getter(name="revokeCertificateOnDestroy")
    def revoke_certificate_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables revocation of a certificate upon destroy,
        which includes when a resource is re-created. Default is `true`.
        """
        return pulumi.get(self, "revoke_certificate_on_destroy")

    @revoke_certificate_on_destroy.setter
    def revoke_certificate_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "revoke_certificate_on_destroy", value)

    @property
    @pulumi.getter(name="revokeCertificateReason")
    def revoke_certificate_reason(self) -> Optional[pulumi.Input[str]]:
        """
        Some CA's require a reason for revocation to be provided.
        Use this reason (from [RFC 5280, section 5.3.1](https://www.rfc-editor.org/rfc/rfc5280#section-5.3.1).
        By default, no reason provided in revocation requests. The reason is a string, when provided should be one of:
        * unspecified
        * key-compromise
        * ca-compromise
        * affiliation-changed
        * superseded
        * cessation-of-operation
        * certificate-hold
        * remove-from-crl
        * privilege-withdrawn
        * aa-compromise
        """
        return pulumi.get(self, "revoke_certificate_reason")

    @revoke_certificate_reason.setter
    def revoke_certificate_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revoke_certificate_reason", value)

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The certificate's subject alternative names,
        domains that this certificate will also be recognized for. Only valid when not
        specifying a CSR. Forces a new resource when changed.
        """
        return pulumi.get(self, "subject_alternative_names")

    @subject_alternative_names.setter
    def subject_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subject_alternative_names", value)

    @property
    @pulumi.getter(name="tlsChallenge")
    def tls_challenge(self) -> Optional[pulumi.Input['CertificateTlsChallengeArgs']]:
        """
        Defines a TLS challenge to use in fulfilling the
        request.

        > Only one of `http_challenge`, `http_webroot_challenge`, `http_s3_challenge`
        and `http_memcached_challenge` can be defined at once. See the section on
        Using HTTP and TLS challenges for more
        details on using these and `tls_challenge`.
        """
        return pulumi.get(self, "tls_challenge")

    @tls_challenge.setter
    def tls_challenge(self, value: Optional[pulumi.Input['CertificateTlsChallengeArgs']]):
        pulumi.set(self, "tls_challenge", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 account_key_pem: Optional[pulumi.Input[str]] = None,
                 cert_timeout: Optional[pulumi.Input[int]] = None,
                 certificate_domain: Optional[pulumi.Input[str]] = None,
                 certificate_not_after: Optional[pulumi.Input[str]] = None,
                 certificate_p12: Optional[pulumi.Input[str]] = None,
                 certificate_p12_password: Optional[pulumi.Input[str]] = None,
                 certificate_pem: Optional[pulumi.Input[str]] = None,
                 certificate_request_pem: Optional[pulumi.Input[str]] = None,
                 certificate_serial: Optional[pulumi.Input[str]] = None,
                 certificate_url: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 disable_complete_propagation: Optional[pulumi.Input[bool]] = None,
                 dns_challenges: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateDnsChallengeArgs']]]] = None,
                 http_challenge: Optional[pulumi.Input['CertificateHttpChallengeArgs']] = None,
                 http_memcached_challenge: Optional[pulumi.Input['CertificateHttpMemcachedChallengeArgs']] = None,
                 http_s3_challenge: Optional[pulumi.Input['CertificateHttpS3ChallengeArgs']] = None,
                 http_webroot_challenge: Optional[pulumi.Input['CertificateHttpWebrootChallengeArgs']] = None,
                 issuer_pem: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 min_days_remaining: Optional[pulumi.Input[int]] = None,
                 must_staple: Optional[pulumi.Input[bool]] = None,
                 pre_check_delay: Optional[pulumi.Input[int]] = None,
                 preferred_chain: Optional[pulumi.Input[str]] = None,
                 private_key_pem: Optional[pulumi.Input[str]] = None,
                 recursive_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revoke_certificate_on_destroy: Optional[pulumi.Input[bool]] = None,
                 revoke_certificate_reason: Optional[pulumi.Input[str]] = None,
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_challenge: Optional[pulumi.Input['CertificateTlsChallengeArgs']] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[str] account_key_pem: The private key of the account that is
               requesting the certificate. Forces a new resource when changed.
        :param pulumi.Input[int] cert_timeout: Controls the timeout in seconds for certificate requests
               that are made after challenges are complete. Defaults to 30 seconds.
               
               > As mentioned, `cert_timeout` does nothing until all challenges are complete.
               If you are looking to control timeouts related to a particular challenge (such
               as a DNS challenge), see that challenge provider's specific options.
        :param pulumi.Input[str] certificate_domain: The common name of the certificate.
        :param pulumi.Input[str] certificate_not_after: The expiry date of the certificate, laid out in
               RFC3339 format (`2006-01-02T15:04:05Z07:00`).
        :param pulumi.Input[str] certificate_p12: The certificate, any intermediates, and the private key
               archived as a PFX file (PKCS12 format, generally used by Microsoft products).
               The data is base64 encoded (including padding), and its password is
               configurable via the `certificate_p12_password`
               argument. This field is empty if creating a certificate from a CSR.
        :param pulumi.Input[str] certificate_p12_password: Password to be used when generating
               the PFX file stored in `certificate_p12`. Defaults to an
               empty string.
        :param pulumi.Input[str] certificate_pem: The certificate in PEM format. This does not include the
               `issuer_pem`. This certificate can be concatenated with `issuer_pem` to form
               a full chain, e.g. `"${acme_certificate.certificate.certificate_pem}${acme_certificate.certificate.issuer_pem}"`
        :param pulumi.Input[str] certificate_request_pem: A pre-created certificate request, such as one
               from [`tls_cert_request`][tls-cert-request], or one from an external source,
               in PEM format.  Either this, or the in-resource request options
               (`common_name`, `key_type`, and optionally `subject_alternative_names`) need
               to be specified. Forces a new resource when changed.
        :param pulumi.Input[str] certificate_serial: The serial number, in string format, as reported by
               the CA.
        :param pulumi.Input[str] certificate_url: The full URL of the certificate within the ACME CA.
        :param pulumi.Input[str] common_name: The certificate's common name, the primary domain that the
               certificate will be recognized for. Required when not specifying a CSR. Forces
               a new resource when changed.
        :param pulumi.Input[bool] disable_complete_propagation: Disable the requirement for full
               propagation of the TXT challenge records before proceeding with validation.
               Defaults to `false`.
               
               > See About DNS propagation checks for details
               on the `recursive_nameservers` and `disable_complete_propagation` settings.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateDnsChallengeArgs']]] dns_challenges: The DNS challenges to
               use in fulfilling the request.
        :param pulumi.Input['CertificateHttpChallengeArgs'] http_challenge: Defines an HTTP challenge to use in fulfilling
               the request.
        :param pulumi.Input['CertificateHttpMemcachedChallengeArgs'] http_memcached_challenge: Defines an alternate type of HTTP
               challenge that can be used to serve up challenges to a
               [Memcached](https://memcached.org/) cluster.
        :param pulumi.Input['CertificateHttpS3ChallengeArgs'] http_s3_challenge: Defines an alternate type of HTTP
               challenge that can be used to serve up challenges to a
               [S3](https://aws.amazon.com/s3/) bucket.
        :param pulumi.Input['CertificateHttpWebrootChallengeArgs'] http_webroot_challenge: Defines an alternate type of HTTP
               challenge that can be used to place a file at a location that can be served by
               an out-of-band webserver.
        :param pulumi.Input[str] issuer_pem: The intermediate certificates of the issuer. Multiple
               certificates are concatenated in this field when there is more than one
               intermediate certificate in the chain.
        :param pulumi.Input[str] key_type: The key type for the certificate's private key. Can be one of:
               `P256` and `P384` (for ECDSA keys of respective length) or `2048`, `4096`, and
               `8192` (for RSA keys of respective length). Required when not specifying a
               CSR. The default is `2048` (RSA key of 2048 bits). Forces a new resource when
               changed.
        :param pulumi.Input[int] min_days_remaining: The minimum amount of days remaining on the
               expiration of a certificate before a renewal is attempted. The default is
               `30`. A value of less than `0` means that the certificate will never be
               renewed.
        :param pulumi.Input[bool] must_staple: Enables the [OCSP Stapling Required][ocsp-stapling]
               TLS Security Policy extension. Certificates with this extension must include a
               valid OCSP Staple in the TLS handshake for the connection to succeed.
               Defaults to `false`. Note that this option has no effect when using an
               external CSR - it must be enabled in the CSR itself. Forces a new resource
               when changed.
               
               [ocsp-stapling]: https://letsencrypt.org/docs/integration-guide/#implement-ocsp-stapling
               
               > OCSP stapling requires specific webserver configuration to support the
               downloading of the staple from the CA's OCSP endpoints, and should be configured
               to tolerate prolonged outages of the OCSP service. Consider this when using
               `must_staple`, and only enable it if you are sure your webserver or service
               provider can be configured correctly.
        :param pulumi.Input[int] pre_check_delay: Insert a delay after _every_ DNS challenge
               record to allow for extra time for DNS propagation before the certificate is
               requested. Use this option if you observe issues with requesting certificates
               even when DNS challenge records get added successfully. Units are in seconds.
               Defaults to 0 (no delay).
               
               > Be careful with `pre_check_delay` since the delay is executed _per-domain_.
               Take your expected delay and divide it by the number of domains you have
               configured (`common_name` + `subject_alternative_names`).
        :param pulumi.Input[str] preferred_chain: The common name of the root of a preferred
               alternate certificate chain offered by the CA. The certificates in
               `issuer_pem` will reflect the chain requested, if available, otherwise the
               default chain will be provided. Forces a new resource when changed.
               
               > `preferred_chain` can be used to request alternate chains on Let's Encrypt
               during the transition away from their old cross-signed intermediates. See [this
               article for more
               details](https://letsencrypt.org/2020/12/21/extending-android-compatibility.html).
               In their example titled **"What about the alternate chain?"**, the root you
               would put in to the `preferred_chain` field would be `ISRG Root X1`. The
               equivalent in the [staging
               environment](https://letsencrypt.org/docs/staging-environment/) is `(STAGING)
               Pretend Pear X1`.
        :param pulumi.Input[str] private_key_pem: The certificate's private key, in PEM format, if the
               certificate was generated from scratch and not with
               `certificate_request_pem`.  If
               `certificate_request_pem` was used, this will be blank.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] recursive_nameservers: The recursive nameservers that will be
               used to check for propagation of DNS challenge records, in addition to some
               in-provider checks such as zone detection. Defaults to your system-configured
               DNS resolvers.
        :param pulumi.Input[bool] revoke_certificate_on_destroy: Enables revocation of a certificate upon destroy,
               which includes when a resource is re-created. Default is `true`.
        :param pulumi.Input[str] revoke_certificate_reason: Some CA's require a reason for revocation to be provided.
               Use this reason (from [RFC 5280, section 5.3.1](https://www.rfc-editor.org/rfc/rfc5280#section-5.3.1).
               By default, no reason provided in revocation requests. The reason is a string, when provided should be one of:
               * unspecified
               * key-compromise
               * ca-compromise
               * affiliation-changed
               * superseded
               * cessation-of-operation
               * certificate-hold
               * remove-from-crl
               * privilege-withdrawn
               * aa-compromise
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alternative_names: The certificate's subject alternative names,
               domains that this certificate will also be recognized for. Only valid when not
               specifying a CSR. Forces a new resource when changed.
        :param pulumi.Input['CertificateTlsChallengeArgs'] tls_challenge: Defines a TLS challenge to use in fulfilling the
               request.
               
               > Only one of `http_challenge`, `http_webroot_challenge`, `http_s3_challenge`
               and `http_memcached_challenge` can be defined at once. See the section on
               Using HTTP and TLS challenges for more
               details on using these and `tls_challenge`.
        """
        if account_key_pem is not None:
            pulumi.set(__self__, "account_key_pem", account_key_pem)
        if cert_timeout is not None:
            pulumi.set(__self__, "cert_timeout", cert_timeout)
        if certificate_domain is not None:
            pulumi.set(__self__, "certificate_domain", certificate_domain)
        if certificate_not_after is not None:
            pulumi.set(__self__, "certificate_not_after", certificate_not_after)
        if certificate_p12 is not None:
            pulumi.set(__self__, "certificate_p12", certificate_p12)
        if certificate_p12_password is not None:
            pulumi.set(__self__, "certificate_p12_password", certificate_p12_password)
        if certificate_pem is not None:
            pulumi.set(__self__, "certificate_pem", certificate_pem)
        if certificate_request_pem is not None:
            pulumi.set(__self__, "certificate_request_pem", certificate_request_pem)
        if certificate_serial is not None:
            pulumi.set(__self__, "certificate_serial", certificate_serial)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if disable_complete_propagation is not None:
            pulumi.set(__self__, "disable_complete_propagation", disable_complete_propagation)
        if dns_challenges is not None:
            pulumi.set(__self__, "dns_challenges", dns_challenges)
        if http_challenge is not None:
            pulumi.set(__self__, "http_challenge", http_challenge)
        if http_memcached_challenge is not None:
            pulumi.set(__self__, "http_memcached_challenge", http_memcached_challenge)
        if http_s3_challenge is not None:
            pulumi.set(__self__, "http_s3_challenge", http_s3_challenge)
        if http_webroot_challenge is not None:
            pulumi.set(__self__, "http_webroot_challenge", http_webroot_challenge)
        if issuer_pem is not None:
            pulumi.set(__self__, "issuer_pem", issuer_pem)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if min_days_remaining is not None:
            pulumi.set(__self__, "min_days_remaining", min_days_remaining)
        if must_staple is not None:
            pulumi.set(__self__, "must_staple", must_staple)
        if pre_check_delay is not None:
            pulumi.set(__self__, "pre_check_delay", pre_check_delay)
        if preferred_chain is not None:
            pulumi.set(__self__, "preferred_chain", preferred_chain)
        if private_key_pem is not None:
            pulumi.set(__self__, "private_key_pem", private_key_pem)
        if recursive_nameservers is not None:
            pulumi.set(__self__, "recursive_nameservers", recursive_nameservers)
        if revoke_certificate_on_destroy is not None:
            pulumi.set(__self__, "revoke_certificate_on_destroy", revoke_certificate_on_destroy)
        if revoke_certificate_reason is not None:
            pulumi.set(__self__, "revoke_certificate_reason", revoke_certificate_reason)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if tls_challenge is not None:
            pulumi.set(__self__, "tls_challenge", tls_challenge)

    @property
    @pulumi.getter(name="accountKeyPem")
    def account_key_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The private key of the account that is
        requesting the certificate. Forces a new resource when changed.
        """
        return pulumi.get(self, "account_key_pem")

    @account_key_pem.setter
    def account_key_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key_pem", value)

    @property
    @pulumi.getter(name="certTimeout")
    def cert_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Controls the timeout in seconds for certificate requests
        that are made after challenges are complete. Defaults to 30 seconds.

        > As mentioned, `cert_timeout` does nothing until all challenges are complete.
        If you are looking to control timeouts related to a particular challenge (such
        as a DNS challenge), see that challenge provider's specific options.
        """
        return pulumi.get(self, "cert_timeout")

    @cert_timeout.setter
    def cert_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cert_timeout", value)

    @property
    @pulumi.getter(name="certificateDomain")
    def certificate_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The common name of the certificate.
        """
        return pulumi.get(self, "certificate_domain")

    @certificate_domain.setter
    def certificate_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_domain", value)

    @property
    @pulumi.getter(name="certificateNotAfter")
    def certificate_not_after(self) -> Optional[pulumi.Input[str]]:
        """
        The expiry date of the certificate, laid out in
        RFC3339 format (`2006-01-02T15:04:05Z07:00`).
        """
        return pulumi.get(self, "certificate_not_after")

    @certificate_not_after.setter
    def certificate_not_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_not_after", value)

    @property
    @pulumi.getter(name="certificateP12")
    def certificate_p12(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate, any intermediates, and the private key
        archived as a PFX file (PKCS12 format, generally used by Microsoft products).
        The data is base64 encoded (including padding), and its password is
        configurable via the `certificate_p12_password`
        argument. This field is empty if creating a certificate from a CSR.
        """
        return pulumi.get(self, "certificate_p12")

    @certificate_p12.setter
    def certificate_p12(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_p12", value)

    @property
    @pulumi.getter(name="certificateP12Password")
    def certificate_p12_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to be used when generating
        the PFX file stored in `certificate_p12`. Defaults to an
        empty string.
        """
        return pulumi.get(self, "certificate_p12_password")

    @certificate_p12_password.setter
    def certificate_p12_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_p12_password", value)

    @property
    @pulumi.getter(name="certificatePem")
    def certificate_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate in PEM format. This does not include the
        `issuer_pem`. This certificate can be concatenated with `issuer_pem` to form
        a full chain, e.g. `"${acme_certificate.certificate.certificate_pem}${acme_certificate.certificate.issuer_pem}"`
        """
        return pulumi.get(self, "certificate_pem")

    @certificate_pem.setter
    def certificate_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_pem", value)

    @property
    @pulumi.getter(name="certificateRequestPem")
    def certificate_request_pem(self) -> Optional[pulumi.Input[str]]:
        """
        A pre-created certificate request, such as one
        from [`tls_cert_request`][tls-cert-request], or one from an external source,
        in PEM format.  Either this, or the in-resource request options
        (`common_name`, `key_type`, and optionally `subject_alternative_names`) need
        to be specified. Forces a new resource when changed.
        """
        return pulumi.get(self, "certificate_request_pem")

    @certificate_request_pem.setter
    def certificate_request_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_request_pem", value)

    @property
    @pulumi.getter(name="certificateSerial")
    def certificate_serial(self) -> Optional[pulumi.Input[str]]:
        """
        The serial number, in string format, as reported by
        the CA.
        """
        return pulumi.get(self, "certificate_serial")

    @certificate_serial.setter
    def certificate_serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_serial", value)

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[pulumi.Input[str]]:
        """
        The full URL of the certificate within the ACME CA.
        """
        return pulumi.get(self, "certificate_url")

    @certificate_url.setter
    def certificate_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_url", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate's common name, the primary domain that the
        certificate will be recognized for. Required when not specifying a CSR. Forces
        a new resource when changed.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="disableCompletePropagation")
    def disable_complete_propagation(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable the requirement for full
        propagation of the TXT challenge records before proceeding with validation.
        Defaults to `false`.

        > See About DNS propagation checks for details
        on the `recursive_nameservers` and `disable_complete_propagation` settings.
        """
        return pulumi.get(self, "disable_complete_propagation")

    @disable_complete_propagation.setter
    def disable_complete_propagation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_complete_propagation", value)

    @property
    @pulumi.getter(name="dnsChallenges")
    def dns_challenges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateDnsChallengeArgs']]]]:
        """
        The DNS challenges to
        use in fulfilling the request.
        """
        return pulumi.get(self, "dns_challenges")

    @dns_challenges.setter
    def dns_challenges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateDnsChallengeArgs']]]]):
        pulumi.set(self, "dns_challenges", value)

    @property
    @pulumi.getter(name="httpChallenge")
    def http_challenge(self) -> Optional[pulumi.Input['CertificateHttpChallengeArgs']]:
        """
        Defines an HTTP challenge to use in fulfilling
        the request.
        """
        return pulumi.get(self, "http_challenge")

    @http_challenge.setter
    def http_challenge(self, value: Optional[pulumi.Input['CertificateHttpChallengeArgs']]):
        pulumi.set(self, "http_challenge", value)

    @property
    @pulumi.getter(name="httpMemcachedChallenge")
    def http_memcached_challenge(self) -> Optional[pulumi.Input['CertificateHttpMemcachedChallengeArgs']]:
        """
        Defines an alternate type of HTTP
        challenge that can be used to serve up challenges to a
        [Memcached](https://memcached.org/) cluster.
        """
        return pulumi.get(self, "http_memcached_challenge")

    @http_memcached_challenge.setter
    def http_memcached_challenge(self, value: Optional[pulumi.Input['CertificateHttpMemcachedChallengeArgs']]):
        pulumi.set(self, "http_memcached_challenge", value)

    @property
    @pulumi.getter(name="httpS3Challenge")
    def http_s3_challenge(self) -> Optional[pulumi.Input['CertificateHttpS3ChallengeArgs']]:
        """
        Defines an alternate type of HTTP
        challenge that can be used to serve up challenges to a
        [S3](https://aws.amazon.com/s3/) bucket.
        """
        return pulumi.get(self, "http_s3_challenge")

    @http_s3_challenge.setter
    def http_s3_challenge(self, value: Optional[pulumi.Input['CertificateHttpS3ChallengeArgs']]):
        pulumi.set(self, "http_s3_challenge", value)

    @property
    @pulumi.getter(name="httpWebrootChallenge")
    def http_webroot_challenge(self) -> Optional[pulumi.Input['CertificateHttpWebrootChallengeArgs']]:
        """
        Defines an alternate type of HTTP
        challenge that can be used to place a file at a location that can be served by
        an out-of-band webserver.
        """
        return pulumi.get(self, "http_webroot_challenge")

    @http_webroot_challenge.setter
    def http_webroot_challenge(self, value: Optional[pulumi.Input['CertificateHttpWebrootChallengeArgs']]):
        pulumi.set(self, "http_webroot_challenge", value)

    @property
    @pulumi.getter(name="issuerPem")
    def issuer_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The intermediate certificates of the issuer. Multiple
        certificates are concatenated in this field when there is more than one
        intermediate certificate in the chain.
        """
        return pulumi.get(self, "issuer_pem")

    @issuer_pem.setter
    def issuer_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_pem", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The key type for the certificate's private key. Can be one of:
        `P256` and `P384` (for ECDSA keys of respective length) or `2048`, `4096`, and
        `8192` (for RSA keys of respective length). Required when not specifying a
        CSR. The default is `2048` (RSA key of 2048 bits). Forces a new resource when
        changed.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="minDaysRemaining")
    def min_days_remaining(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of days remaining on the
        expiration of a certificate before a renewal is attempted. The default is
        `30`. A value of less than `0` means that the certificate will never be
        renewed.
        """
        return pulumi.get(self, "min_days_remaining")

    @min_days_remaining.setter
    def min_days_remaining(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_days_remaining", value)

    @property
    @pulumi.getter(name="mustStaple")
    def must_staple(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables the [OCSP Stapling Required][ocsp-stapling]
        TLS Security Policy extension. Certificates with this extension must include a
        valid OCSP Staple in the TLS handshake for the connection to succeed.
        Defaults to `false`. Note that this option has no effect when using an
        external CSR - it must be enabled in the CSR itself. Forces a new resource
        when changed.

        [ocsp-stapling]: https://letsencrypt.org/docs/integration-guide/#implement-ocsp-stapling

        > OCSP stapling requires specific webserver configuration to support the
        downloading of the staple from the CA's OCSP endpoints, and should be configured
        to tolerate prolonged outages of the OCSP service. Consider this when using
        `must_staple`, and only enable it if you are sure your webserver or service
        provider can be configured correctly.
        """
        return pulumi.get(self, "must_staple")

    @must_staple.setter
    def must_staple(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_staple", value)

    @property
    @pulumi.getter(name="preCheckDelay")
    def pre_check_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Insert a delay after _every_ DNS challenge
        record to allow for extra time for DNS propagation before the certificate is
        requested. Use this option if you observe issues with requesting certificates
        even when DNS challenge records get added successfully. Units are in seconds.
        Defaults to 0 (no delay).

        > Be careful with `pre_check_delay` since the delay is executed _per-domain_.
        Take your expected delay and divide it by the number of domains you have
        configured (`common_name` + `subject_alternative_names`).
        """
        return pulumi.get(self, "pre_check_delay")

    @pre_check_delay.setter
    def pre_check_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pre_check_delay", value)

    @property
    @pulumi.getter(name="preferredChain")
    def preferred_chain(self) -> Optional[pulumi.Input[str]]:
        """
        The common name of the root of a preferred
        alternate certificate chain offered by the CA. The certificates in
        `issuer_pem` will reflect the chain requested, if available, otherwise the
        default chain will be provided. Forces a new resource when changed.

        > `preferred_chain` can be used to request alternate chains on Let's Encrypt
        during the transition away from their old cross-signed intermediates. See [this
        article for more
        details](https://letsencrypt.org/2020/12/21/extending-android-compatibility.html).
        In their example titled **"What about the alternate chain?"**, the root you
        would put in to the `preferred_chain` field would be `ISRG Root X1`. The
        equivalent in the [staging
        environment](https://letsencrypt.org/docs/staging-environment/) is `(STAGING)
        Pretend Pear X1`.
        """
        return pulumi.get(self, "preferred_chain")

    @preferred_chain.setter
    def preferred_chain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_chain", value)

    @property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate's private key, in PEM format, if the
        certificate was generated from scratch and not with
        `certificate_request_pem`.  If
        `certificate_request_pem` was used, this will be blank.
        """
        return pulumi.get(self, "private_key_pem")

    @private_key_pem.setter
    def private_key_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_pem", value)

    @property
    @pulumi.getter(name="recursiveNameservers")
    def recursive_nameservers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The recursive nameservers that will be
        used to check for propagation of DNS challenge records, in addition to some
        in-provider checks such as zone detection. Defaults to your system-configured
        DNS resolvers.
        """
        return pulumi.get(self, "recursive_nameservers")

    @recursive_nameservers.setter
    def recursive_nameservers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "recursive_nameservers", value)

    @property
    @pulumi.getter(name="revokeCertificateOnDestroy")
    def revoke_certificate_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables revocation of a certificate upon destroy,
        which includes when a resource is re-created. Default is `true`.
        """
        return pulumi.get(self, "revoke_certificate_on_destroy")

    @revoke_certificate_on_destroy.setter
    def revoke_certificate_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "revoke_certificate_on_destroy", value)

    @property
    @pulumi.getter(name="revokeCertificateReason")
    def revoke_certificate_reason(self) -> Optional[pulumi.Input[str]]:
        """
        Some CA's require a reason for revocation to be provided.
        Use this reason (from [RFC 5280, section 5.3.1](https://www.rfc-editor.org/rfc/rfc5280#section-5.3.1).
        By default, no reason provided in revocation requests. The reason is a string, when provided should be one of:
        * unspecified
        * key-compromise
        * ca-compromise
        * affiliation-changed
        * superseded
        * cessation-of-operation
        * certificate-hold
        * remove-from-crl
        * privilege-withdrawn
        * aa-compromise
        """
        return pulumi.get(self, "revoke_certificate_reason")

    @revoke_certificate_reason.setter
    def revoke_certificate_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revoke_certificate_reason", value)

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The certificate's subject alternative names,
        domains that this certificate will also be recognized for. Only valid when not
        specifying a CSR. Forces a new resource when changed.
        """
        return pulumi.get(self, "subject_alternative_names")

    @subject_alternative_names.setter
    def subject_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subject_alternative_names", value)

    @property
    @pulumi.getter(name="tlsChallenge")
    def tls_challenge(self) -> Optional[pulumi.Input['CertificateTlsChallengeArgs']]:
        """
        Defines a TLS challenge to use in fulfilling the
        request.

        > Only one of `http_challenge`, `http_webroot_challenge`, `http_s3_challenge`
        and `http_memcached_challenge` can be defined at once. See the section on
        Using HTTP and TLS challenges for more
        details on using these and `tls_challenge`.
        """
        return pulumi.get(self, "tls_challenge")

    @tls_challenge.setter
    def tls_challenge(self, value: Optional[pulumi.Input['CertificateTlsChallengeArgs']]):
        pulumi.set(self, "tls_challenge", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_key_pem: Optional[pulumi.Input[str]] = None,
                 cert_timeout: Optional[pulumi.Input[int]] = None,
                 certificate_p12_password: Optional[pulumi.Input[str]] = None,
                 certificate_request_pem: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 disable_complete_propagation: Optional[pulumi.Input[bool]] = None,
                 dns_challenges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateDnsChallengeArgs', 'CertificateDnsChallengeArgsDict']]]]] = None,
                 http_challenge: Optional[pulumi.Input[Union['CertificateHttpChallengeArgs', 'CertificateHttpChallengeArgsDict']]] = None,
                 http_memcached_challenge: Optional[pulumi.Input[Union['CertificateHttpMemcachedChallengeArgs', 'CertificateHttpMemcachedChallengeArgsDict']]] = None,
                 http_s3_challenge: Optional[pulumi.Input[Union['CertificateHttpS3ChallengeArgs', 'CertificateHttpS3ChallengeArgsDict']]] = None,
                 http_webroot_challenge: Optional[pulumi.Input[Union['CertificateHttpWebrootChallengeArgs', 'CertificateHttpWebrootChallengeArgsDict']]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 min_days_remaining: Optional[pulumi.Input[int]] = None,
                 must_staple: Optional[pulumi.Input[bool]] = None,
                 pre_check_delay: Optional[pulumi.Input[int]] = None,
                 preferred_chain: Optional[pulumi.Input[str]] = None,
                 recursive_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revoke_certificate_on_destroy: Optional[pulumi.Input[bool]] = None,
                 revoke_certificate_reason: Optional[pulumi.Input[str]] = None,
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_challenge: Optional[pulumi.Input[Union['CertificateTlsChallengeArgs', 'CertificateTlsChallengeArgsDict']]] = None,
                 __props__=None):
        """
        Create a Certificate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_key_pem: The private key of the account that is
               requesting the certificate. Forces a new resource when changed.
        :param pulumi.Input[int] cert_timeout: Controls the timeout in seconds for certificate requests
               that are made after challenges are complete. Defaults to 30 seconds.
               
               > As mentioned, `cert_timeout` does nothing until all challenges are complete.
               If you are looking to control timeouts related to a particular challenge (such
               as a DNS challenge), see that challenge provider's specific options.
        :param pulumi.Input[str] certificate_p12_password: Password to be used when generating
               the PFX file stored in `certificate_p12`. Defaults to an
               empty string.
        :param pulumi.Input[str] certificate_request_pem: A pre-created certificate request, such as one
               from [`tls_cert_request`][tls-cert-request], or one from an external source,
               in PEM format.  Either this, or the in-resource request options
               (`common_name`, `key_type`, and optionally `subject_alternative_names`) need
               to be specified. Forces a new resource when changed.
        :param pulumi.Input[str] common_name: The certificate's common name, the primary domain that the
               certificate will be recognized for. Required when not specifying a CSR. Forces
               a new resource when changed.
        :param pulumi.Input[bool] disable_complete_propagation: Disable the requirement for full
               propagation of the TXT challenge records before proceeding with validation.
               Defaults to `false`.
               
               > See About DNS propagation checks for details
               on the `recursive_nameservers` and `disable_complete_propagation` settings.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateDnsChallengeArgs', 'CertificateDnsChallengeArgsDict']]]] dns_challenges: The DNS challenges to
               use in fulfilling the request.
        :param pulumi.Input[Union['CertificateHttpChallengeArgs', 'CertificateHttpChallengeArgsDict']] http_challenge: Defines an HTTP challenge to use in fulfilling
               the request.
        :param pulumi.Input[Union['CertificateHttpMemcachedChallengeArgs', 'CertificateHttpMemcachedChallengeArgsDict']] http_memcached_challenge: Defines an alternate type of HTTP
               challenge that can be used to serve up challenges to a
               [Memcached](https://memcached.org/) cluster.
        :param pulumi.Input[Union['CertificateHttpS3ChallengeArgs', 'CertificateHttpS3ChallengeArgsDict']] http_s3_challenge: Defines an alternate type of HTTP
               challenge that can be used to serve up challenges to a
               [S3](https://aws.amazon.com/s3/) bucket.
        :param pulumi.Input[Union['CertificateHttpWebrootChallengeArgs', 'CertificateHttpWebrootChallengeArgsDict']] http_webroot_challenge: Defines an alternate type of HTTP
               challenge that can be used to place a file at a location that can be served by
               an out-of-band webserver.
        :param pulumi.Input[str] key_type: The key type for the certificate's private key. Can be one of:
               `P256` and `P384` (for ECDSA keys of respective length) or `2048`, `4096`, and
               `8192` (for RSA keys of respective length). Required when not specifying a
               CSR. The default is `2048` (RSA key of 2048 bits). Forces a new resource when
               changed.
        :param pulumi.Input[int] min_days_remaining: The minimum amount of days remaining on the
               expiration of a certificate before a renewal is attempted. The default is
               `30`. A value of less than `0` means that the certificate will never be
               renewed.
        :param pulumi.Input[bool] must_staple: Enables the [OCSP Stapling Required][ocsp-stapling]
               TLS Security Policy extension. Certificates with this extension must include a
               valid OCSP Staple in the TLS handshake for the connection to succeed.
               Defaults to `false`. Note that this option has no effect when using an
               external CSR - it must be enabled in the CSR itself. Forces a new resource
               when changed.
               
               [ocsp-stapling]: https://letsencrypt.org/docs/integration-guide/#implement-ocsp-stapling
               
               > OCSP stapling requires specific webserver configuration to support the
               downloading of the staple from the CA's OCSP endpoints, and should be configured
               to tolerate prolonged outages of the OCSP service. Consider this when using
               `must_staple`, and only enable it if you are sure your webserver or service
               provider can be configured correctly.
        :param pulumi.Input[int] pre_check_delay: Insert a delay after _every_ DNS challenge
               record to allow for extra time for DNS propagation before the certificate is
               requested. Use this option if you observe issues with requesting certificates
               even when DNS challenge records get added successfully. Units are in seconds.
               Defaults to 0 (no delay).
               
               > Be careful with `pre_check_delay` since the delay is executed _per-domain_.
               Take your expected delay and divide it by the number of domains you have
               configured (`common_name` + `subject_alternative_names`).
        :param pulumi.Input[str] preferred_chain: The common name of the root of a preferred
               alternate certificate chain offered by the CA. The certificates in
               `issuer_pem` will reflect the chain requested, if available, otherwise the
               default chain will be provided. Forces a new resource when changed.
               
               > `preferred_chain` can be used to request alternate chains on Let's Encrypt
               during the transition away from their old cross-signed intermediates. See [this
               article for more
               details](https://letsencrypt.org/2020/12/21/extending-android-compatibility.html).
               In their example titled **"What about the alternate chain?"**, the root you
               would put in to the `preferred_chain` field would be `ISRG Root X1`. The
               equivalent in the [staging
               environment](https://letsencrypt.org/docs/staging-environment/) is `(STAGING)
               Pretend Pear X1`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] recursive_nameservers: The recursive nameservers that will be
               used to check for propagation of DNS challenge records, in addition to some
               in-provider checks such as zone detection. Defaults to your system-configured
               DNS resolvers.
        :param pulumi.Input[bool] revoke_certificate_on_destroy: Enables revocation of a certificate upon destroy,
               which includes when a resource is re-created. Default is `true`.
        :param pulumi.Input[str] revoke_certificate_reason: Some CA's require a reason for revocation to be provided.
               Use this reason (from [RFC 5280, section 5.3.1](https://www.rfc-editor.org/rfc/rfc5280#section-5.3.1).
               By default, no reason provided in revocation requests. The reason is a string, when provided should be one of:
               * unspecified
               * key-compromise
               * ca-compromise
               * affiliation-changed
               * superseded
               * cessation-of-operation
               * certificate-hold
               * remove-from-crl
               * privilege-withdrawn
               * aa-compromise
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alternative_names: The certificate's subject alternative names,
               domains that this certificate will also be recognized for. Only valid when not
               specifying a CSR. Forces a new resource when changed.
        :param pulumi.Input[Union['CertificateTlsChallengeArgs', 'CertificateTlsChallengeArgsDict']] tls_challenge: Defines a TLS challenge to use in fulfilling the
               request.
               
               > Only one of `http_challenge`, `http_webroot_challenge`, `http_s3_challenge`
               and `http_memcached_challenge` can be defined at once. See the section on
               Using HTTP and TLS challenges for more
               details on using these and `tls_challenge`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Certificate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_key_pem: Optional[pulumi.Input[str]] = None,
                 cert_timeout: Optional[pulumi.Input[int]] = None,
                 certificate_p12_password: Optional[pulumi.Input[str]] = None,
                 certificate_request_pem: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 disable_complete_propagation: Optional[pulumi.Input[bool]] = None,
                 dns_challenges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateDnsChallengeArgs', 'CertificateDnsChallengeArgsDict']]]]] = None,
                 http_challenge: Optional[pulumi.Input[Union['CertificateHttpChallengeArgs', 'CertificateHttpChallengeArgsDict']]] = None,
                 http_memcached_challenge: Optional[pulumi.Input[Union['CertificateHttpMemcachedChallengeArgs', 'CertificateHttpMemcachedChallengeArgsDict']]] = None,
                 http_s3_challenge: Optional[pulumi.Input[Union['CertificateHttpS3ChallengeArgs', 'CertificateHttpS3ChallengeArgsDict']]] = None,
                 http_webroot_challenge: Optional[pulumi.Input[Union['CertificateHttpWebrootChallengeArgs', 'CertificateHttpWebrootChallengeArgsDict']]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 min_days_remaining: Optional[pulumi.Input[int]] = None,
                 must_staple: Optional[pulumi.Input[bool]] = None,
                 pre_check_delay: Optional[pulumi.Input[int]] = None,
                 preferred_chain: Optional[pulumi.Input[str]] = None,
                 recursive_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revoke_certificate_on_destroy: Optional[pulumi.Input[bool]] = None,
                 revoke_certificate_reason: Optional[pulumi.Input[str]] = None,
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_challenge: Optional[pulumi.Input[Union['CertificateTlsChallengeArgs', 'CertificateTlsChallengeArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if account_key_pem is None and not opts.urn:
                raise TypeError("Missing required property 'account_key_pem'")
            __props__.__dict__["account_key_pem"] = None if account_key_pem is None else pulumi.Output.secret(account_key_pem)
            __props__.__dict__["cert_timeout"] = cert_timeout
            __props__.__dict__["certificate_p12_password"] = None if certificate_p12_password is None else pulumi.Output.secret(certificate_p12_password)
            __props__.__dict__["certificate_request_pem"] = certificate_request_pem
            __props__.__dict__["common_name"] = common_name
            __props__.__dict__["disable_complete_propagation"] = disable_complete_propagation
            __props__.__dict__["dns_challenges"] = dns_challenges
            __props__.__dict__["http_challenge"] = http_challenge
            __props__.__dict__["http_memcached_challenge"] = http_memcached_challenge
            __props__.__dict__["http_s3_challenge"] = http_s3_challenge
            __props__.__dict__["http_webroot_challenge"] = http_webroot_challenge
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["min_days_remaining"] = min_days_remaining
            __props__.__dict__["must_staple"] = must_staple
            __props__.__dict__["pre_check_delay"] = pre_check_delay
            __props__.__dict__["preferred_chain"] = preferred_chain
            __props__.__dict__["recursive_nameservers"] = recursive_nameservers
            __props__.__dict__["revoke_certificate_on_destroy"] = revoke_certificate_on_destroy
            __props__.__dict__["revoke_certificate_reason"] = revoke_certificate_reason
            __props__.__dict__["subject_alternative_names"] = subject_alternative_names
            __props__.__dict__["tls_challenge"] = tls_challenge
            __props__.__dict__["certificate_domain"] = None
            __props__.__dict__["certificate_not_after"] = None
            __props__.__dict__["certificate_p12"] = None
            __props__.__dict__["certificate_pem"] = None
            __props__.__dict__["certificate_serial"] = None
            __props__.__dict__["certificate_url"] = None
            __props__.__dict__["issuer_pem"] = None
            __props__.__dict__["private_key_pem"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountKeyPem", "certificateP12", "certificateP12Password", "privateKeyPem"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'acme:index/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_key_pem: Optional[pulumi.Input[str]] = None,
            cert_timeout: Optional[pulumi.Input[int]] = None,
            certificate_domain: Optional[pulumi.Input[str]] = None,
            certificate_not_after: Optional[pulumi.Input[str]] = None,
            certificate_p12: Optional[pulumi.Input[str]] = None,
            certificate_p12_password: Optional[pulumi.Input[str]] = None,
            certificate_pem: Optional[pulumi.Input[str]] = None,
            certificate_request_pem: Optional[pulumi.Input[str]] = None,
            certificate_serial: Optional[pulumi.Input[str]] = None,
            certificate_url: Optional[pulumi.Input[str]] = None,
            common_name: Optional[pulumi.Input[str]] = None,
            disable_complete_propagation: Optional[pulumi.Input[bool]] = None,
            dns_challenges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateDnsChallengeArgs', 'CertificateDnsChallengeArgsDict']]]]] = None,
            http_challenge: Optional[pulumi.Input[Union['CertificateHttpChallengeArgs', 'CertificateHttpChallengeArgsDict']]] = None,
            http_memcached_challenge: Optional[pulumi.Input[Union['CertificateHttpMemcachedChallengeArgs', 'CertificateHttpMemcachedChallengeArgsDict']]] = None,
            http_s3_challenge: Optional[pulumi.Input[Union['CertificateHttpS3ChallengeArgs', 'CertificateHttpS3ChallengeArgsDict']]] = None,
            http_webroot_challenge: Optional[pulumi.Input[Union['CertificateHttpWebrootChallengeArgs', 'CertificateHttpWebrootChallengeArgsDict']]] = None,
            issuer_pem: Optional[pulumi.Input[str]] = None,
            key_type: Optional[pulumi.Input[str]] = None,
            min_days_remaining: Optional[pulumi.Input[int]] = None,
            must_staple: Optional[pulumi.Input[bool]] = None,
            pre_check_delay: Optional[pulumi.Input[int]] = None,
            preferred_chain: Optional[pulumi.Input[str]] = None,
            private_key_pem: Optional[pulumi.Input[str]] = None,
            recursive_nameservers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            revoke_certificate_on_destroy: Optional[pulumi.Input[bool]] = None,
            revoke_certificate_reason: Optional[pulumi.Input[str]] = None,
            subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tls_challenge: Optional[pulumi.Input[Union['CertificateTlsChallengeArgs', 'CertificateTlsChallengeArgsDict']]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_key_pem: The private key of the account that is
               requesting the certificate. Forces a new resource when changed.
        :param pulumi.Input[int] cert_timeout: Controls the timeout in seconds for certificate requests
               that are made after challenges are complete. Defaults to 30 seconds.
               
               > As mentioned, `cert_timeout` does nothing until all challenges are complete.
               If you are looking to control timeouts related to a particular challenge (such
               as a DNS challenge), see that challenge provider's specific options.
        :param pulumi.Input[str] certificate_domain: The common name of the certificate.
        :param pulumi.Input[str] certificate_not_after: The expiry date of the certificate, laid out in
               RFC3339 format (`2006-01-02T15:04:05Z07:00`).
        :param pulumi.Input[str] certificate_p12: The certificate, any intermediates, and the private key
               archived as a PFX file (PKCS12 format, generally used by Microsoft products).
               The data is base64 encoded (including padding), and its password is
               configurable via the `certificate_p12_password`
               argument. This field is empty if creating a certificate from a CSR.
        :param pulumi.Input[str] certificate_p12_password: Password to be used when generating
               the PFX file stored in `certificate_p12`. Defaults to an
               empty string.
        :param pulumi.Input[str] certificate_pem: The certificate in PEM format. This does not include the
               `issuer_pem`. This certificate can be concatenated with `issuer_pem` to form
               a full chain, e.g. `"${acme_certificate.certificate.certificate_pem}${acme_certificate.certificate.issuer_pem}"`
        :param pulumi.Input[str] certificate_request_pem: A pre-created certificate request, such as one
               from [`tls_cert_request`][tls-cert-request], or one from an external source,
               in PEM format.  Either this, or the in-resource request options
               (`common_name`, `key_type`, and optionally `subject_alternative_names`) need
               to be specified. Forces a new resource when changed.
        :param pulumi.Input[str] certificate_serial: The serial number, in string format, as reported by
               the CA.
        :param pulumi.Input[str] certificate_url: The full URL of the certificate within the ACME CA.
        :param pulumi.Input[str] common_name: The certificate's common name, the primary domain that the
               certificate will be recognized for. Required when not specifying a CSR. Forces
               a new resource when changed.
        :param pulumi.Input[bool] disable_complete_propagation: Disable the requirement for full
               propagation of the TXT challenge records before proceeding with validation.
               Defaults to `false`.
               
               > See About DNS propagation checks for details
               on the `recursive_nameservers` and `disable_complete_propagation` settings.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateDnsChallengeArgs', 'CertificateDnsChallengeArgsDict']]]] dns_challenges: The DNS challenges to
               use in fulfilling the request.
        :param pulumi.Input[Union['CertificateHttpChallengeArgs', 'CertificateHttpChallengeArgsDict']] http_challenge: Defines an HTTP challenge to use in fulfilling
               the request.
        :param pulumi.Input[Union['CertificateHttpMemcachedChallengeArgs', 'CertificateHttpMemcachedChallengeArgsDict']] http_memcached_challenge: Defines an alternate type of HTTP
               challenge that can be used to serve up challenges to a
               [Memcached](https://memcached.org/) cluster.
        :param pulumi.Input[Union['CertificateHttpS3ChallengeArgs', 'CertificateHttpS3ChallengeArgsDict']] http_s3_challenge: Defines an alternate type of HTTP
               challenge that can be used to serve up challenges to a
               [S3](https://aws.amazon.com/s3/) bucket.
        :param pulumi.Input[Union['CertificateHttpWebrootChallengeArgs', 'CertificateHttpWebrootChallengeArgsDict']] http_webroot_challenge: Defines an alternate type of HTTP
               challenge that can be used to place a file at a location that can be served by
               an out-of-band webserver.
        :param pulumi.Input[str] issuer_pem: The intermediate certificates of the issuer. Multiple
               certificates are concatenated in this field when there is more than one
               intermediate certificate in the chain.
        :param pulumi.Input[str] key_type: The key type for the certificate's private key. Can be one of:
               `P256` and `P384` (for ECDSA keys of respective length) or `2048`, `4096`, and
               `8192` (for RSA keys of respective length). Required when not specifying a
               CSR. The default is `2048` (RSA key of 2048 bits). Forces a new resource when
               changed.
        :param pulumi.Input[int] min_days_remaining: The minimum amount of days remaining on the
               expiration of a certificate before a renewal is attempted. The default is
               `30`. A value of less than `0` means that the certificate will never be
               renewed.
        :param pulumi.Input[bool] must_staple: Enables the [OCSP Stapling Required][ocsp-stapling]
               TLS Security Policy extension. Certificates with this extension must include a
               valid OCSP Staple in the TLS handshake for the connection to succeed.
               Defaults to `false`. Note that this option has no effect when using an
               external CSR - it must be enabled in the CSR itself. Forces a new resource
               when changed.
               
               [ocsp-stapling]: https://letsencrypt.org/docs/integration-guide/#implement-ocsp-stapling
               
               > OCSP stapling requires specific webserver configuration to support the
               downloading of the staple from the CA's OCSP endpoints, and should be configured
               to tolerate prolonged outages of the OCSP service. Consider this when using
               `must_staple`, and only enable it if you are sure your webserver or service
               provider can be configured correctly.
        :param pulumi.Input[int] pre_check_delay: Insert a delay after _every_ DNS challenge
               record to allow for extra time for DNS propagation before the certificate is
               requested. Use this option if you observe issues with requesting certificates
               even when DNS challenge records get added successfully. Units are in seconds.
               Defaults to 0 (no delay).
               
               > Be careful with `pre_check_delay` since the delay is executed _per-domain_.
               Take your expected delay and divide it by the number of domains you have
               configured (`common_name` + `subject_alternative_names`).
        :param pulumi.Input[str] preferred_chain: The common name of the root of a preferred
               alternate certificate chain offered by the CA. The certificates in
               `issuer_pem` will reflect the chain requested, if available, otherwise the
               default chain will be provided. Forces a new resource when changed.
               
               > `preferred_chain` can be used to request alternate chains on Let's Encrypt
               during the transition away from their old cross-signed intermediates. See [this
               article for more
               details](https://letsencrypt.org/2020/12/21/extending-android-compatibility.html).
               In their example titled **"What about the alternate chain?"**, the root you
               would put in to the `preferred_chain` field would be `ISRG Root X1`. The
               equivalent in the [staging
               environment](https://letsencrypt.org/docs/staging-environment/) is `(STAGING)
               Pretend Pear X1`.
        :param pulumi.Input[str] private_key_pem: The certificate's private key, in PEM format, if the
               certificate was generated from scratch and not with
               `certificate_request_pem`.  If
               `certificate_request_pem` was used, this will be blank.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] recursive_nameservers: The recursive nameservers that will be
               used to check for propagation of DNS challenge records, in addition to some
               in-provider checks such as zone detection. Defaults to your system-configured
               DNS resolvers.
        :param pulumi.Input[bool] revoke_certificate_on_destroy: Enables revocation of a certificate upon destroy,
               which includes when a resource is re-created. Default is `true`.
        :param pulumi.Input[str] revoke_certificate_reason: Some CA's require a reason for revocation to be provided.
               Use this reason (from [RFC 5280, section 5.3.1](https://www.rfc-editor.org/rfc/rfc5280#section-5.3.1).
               By default, no reason provided in revocation requests. The reason is a string, when provided should be one of:
               * unspecified
               * key-compromise
               * ca-compromise
               * affiliation-changed
               * superseded
               * cessation-of-operation
               * certificate-hold
               * remove-from-crl
               * privilege-withdrawn
               * aa-compromise
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subject_alternative_names: The certificate's subject alternative names,
               domains that this certificate will also be recognized for. Only valid when not
               specifying a CSR. Forces a new resource when changed.
        :param pulumi.Input[Union['CertificateTlsChallengeArgs', 'CertificateTlsChallengeArgsDict']] tls_challenge: Defines a TLS challenge to use in fulfilling the
               request.
               
               > Only one of `http_challenge`, `http_webroot_challenge`, `http_s3_challenge`
               and `http_memcached_challenge` can be defined at once. See the section on
               Using HTTP and TLS challenges for more
               details on using these and `tls_challenge`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["account_key_pem"] = account_key_pem
        __props__.__dict__["cert_timeout"] = cert_timeout
        __props__.__dict__["certificate_domain"] = certificate_domain
        __props__.__dict__["certificate_not_after"] = certificate_not_after
        __props__.__dict__["certificate_p12"] = certificate_p12
        __props__.__dict__["certificate_p12_password"] = certificate_p12_password
        __props__.__dict__["certificate_pem"] = certificate_pem
        __props__.__dict__["certificate_request_pem"] = certificate_request_pem
        __props__.__dict__["certificate_serial"] = certificate_serial
        __props__.__dict__["certificate_url"] = certificate_url
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["disable_complete_propagation"] = disable_complete_propagation
        __props__.__dict__["dns_challenges"] = dns_challenges
        __props__.__dict__["http_challenge"] = http_challenge
        __props__.__dict__["http_memcached_challenge"] = http_memcached_challenge
        __props__.__dict__["http_s3_challenge"] = http_s3_challenge
        __props__.__dict__["http_webroot_challenge"] = http_webroot_challenge
        __props__.__dict__["issuer_pem"] = issuer_pem
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["min_days_remaining"] = min_days_remaining
        __props__.__dict__["must_staple"] = must_staple
        __props__.__dict__["pre_check_delay"] = pre_check_delay
        __props__.__dict__["preferred_chain"] = preferred_chain
        __props__.__dict__["private_key_pem"] = private_key_pem
        __props__.__dict__["recursive_nameservers"] = recursive_nameservers
        __props__.__dict__["revoke_certificate_on_destroy"] = revoke_certificate_on_destroy
        __props__.__dict__["revoke_certificate_reason"] = revoke_certificate_reason
        __props__.__dict__["subject_alternative_names"] = subject_alternative_names
        __props__.__dict__["tls_challenge"] = tls_challenge
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountKeyPem")
    def account_key_pem(self) -> pulumi.Output[str]:
        """
        The private key of the account that is
        requesting the certificate. Forces a new resource when changed.
        """
        return pulumi.get(self, "account_key_pem")

    @property
    @pulumi.getter(name="certTimeout")
    def cert_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Controls the timeout in seconds for certificate requests
        that are made after challenges are complete. Defaults to 30 seconds.

        > As mentioned, `cert_timeout` does nothing until all challenges are complete.
        If you are looking to control timeouts related to a particular challenge (such
        as a DNS challenge), see that challenge provider's specific options.
        """
        return pulumi.get(self, "cert_timeout")

    @property
    @pulumi.getter(name="certificateDomain")
    def certificate_domain(self) -> pulumi.Output[str]:
        """
        The common name of the certificate.
        """
        return pulumi.get(self, "certificate_domain")

    @property
    @pulumi.getter(name="certificateNotAfter")
    def certificate_not_after(self) -> pulumi.Output[str]:
        """
        The expiry date of the certificate, laid out in
        RFC3339 format (`2006-01-02T15:04:05Z07:00`).
        """
        return pulumi.get(self, "certificate_not_after")

    @property
    @pulumi.getter(name="certificateP12")
    def certificate_p12(self) -> pulumi.Output[str]:
        """
        The certificate, any intermediates, and the private key
        archived as a PFX file (PKCS12 format, generally used by Microsoft products).
        The data is base64 encoded (including padding), and its password is
        configurable via the `certificate_p12_password`
        argument. This field is empty if creating a certificate from a CSR.
        """
        return pulumi.get(self, "certificate_p12")

    @property
    @pulumi.getter(name="certificateP12Password")
    def certificate_p12_password(self) -> pulumi.Output[Optional[str]]:
        """
        Password to be used when generating
        the PFX file stored in `certificate_p12`. Defaults to an
        empty string.
        """
        return pulumi.get(self, "certificate_p12_password")

    @property
    @pulumi.getter(name="certificatePem")
    def certificate_pem(self) -> pulumi.Output[str]:
        """
        The certificate in PEM format. This does not include the
        `issuer_pem`. This certificate can be concatenated with `issuer_pem` to form
        a full chain, e.g. `"${acme_certificate.certificate.certificate_pem}${acme_certificate.certificate.issuer_pem}"`
        """
        return pulumi.get(self, "certificate_pem")

    @property
    @pulumi.getter(name="certificateRequestPem")
    def certificate_request_pem(self) -> pulumi.Output[Optional[str]]:
        """
        A pre-created certificate request, such as one
        from [`tls_cert_request`][tls-cert-request], or one from an external source,
        in PEM format.  Either this, or the in-resource request options
        (`common_name`, `key_type`, and optionally `subject_alternative_names`) need
        to be specified. Forces a new resource when changed.
        """
        return pulumi.get(self, "certificate_request_pem")

    @property
    @pulumi.getter(name="certificateSerial")
    def certificate_serial(self) -> pulumi.Output[str]:
        """
        The serial number, in string format, as reported by
        the CA.
        """
        return pulumi.get(self, "certificate_serial")

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> pulumi.Output[str]:
        """
        The full URL of the certificate within the ACME CA.
        """
        return pulumi.get(self, "certificate_url")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[Optional[str]]:
        """
        The certificate's common name, the primary domain that the
        certificate will be recognized for. Required when not specifying a CSR. Forces
        a new resource when changed.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="disableCompletePropagation")
    def disable_complete_propagation(self) -> pulumi.Output[Optional[bool]]:
        """
        Disable the requirement for full
        propagation of the TXT challenge records before proceeding with validation.
        Defaults to `false`.

        > See About DNS propagation checks for details
        on the `recursive_nameservers` and `disable_complete_propagation` settings.
        """
        return pulumi.get(self, "disable_complete_propagation")

    @property
    @pulumi.getter(name="dnsChallenges")
    def dns_challenges(self) -> pulumi.Output[Optional[Sequence['outputs.CertificateDnsChallenge']]]:
        """
        The DNS challenges to
        use in fulfilling the request.
        """
        return pulumi.get(self, "dns_challenges")

    @property
    @pulumi.getter(name="httpChallenge")
    def http_challenge(self) -> pulumi.Output[Optional['outputs.CertificateHttpChallenge']]:
        """
        Defines an HTTP challenge to use in fulfilling
        the request.
        """
        return pulumi.get(self, "http_challenge")

    @property
    @pulumi.getter(name="httpMemcachedChallenge")
    def http_memcached_challenge(self) -> pulumi.Output[Optional['outputs.CertificateHttpMemcachedChallenge']]:
        """
        Defines an alternate type of HTTP
        challenge that can be used to serve up challenges to a
        [Memcached](https://memcached.org/) cluster.
        """
        return pulumi.get(self, "http_memcached_challenge")

    @property
    @pulumi.getter(name="httpS3Challenge")
    def http_s3_challenge(self) -> pulumi.Output[Optional['outputs.CertificateHttpS3Challenge']]:
        """
        Defines an alternate type of HTTP
        challenge that can be used to serve up challenges to a
        [S3](https://aws.amazon.com/s3/) bucket.
        """
        return pulumi.get(self, "http_s3_challenge")

    @property
    @pulumi.getter(name="httpWebrootChallenge")
    def http_webroot_challenge(self) -> pulumi.Output[Optional['outputs.CertificateHttpWebrootChallenge']]:
        """
        Defines an alternate type of HTTP
        challenge that can be used to place a file at a location that can be served by
        an out-of-band webserver.
        """
        return pulumi.get(self, "http_webroot_challenge")

    @property
    @pulumi.getter(name="issuerPem")
    def issuer_pem(self) -> pulumi.Output[str]:
        """
        The intermediate certificates of the issuer. Multiple
        certificates are concatenated in this field when there is more than one
        intermediate certificate in the chain.
        """
        return pulumi.get(self, "issuer_pem")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[Optional[str]]:
        """
        The key type for the certificate's private key. Can be one of:
        `P256` and `P384` (for ECDSA keys of respective length) or `2048`, `4096`, and
        `8192` (for RSA keys of respective length). Required when not specifying a
        CSR. The default is `2048` (RSA key of 2048 bits). Forces a new resource when
        changed.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="minDaysRemaining")
    def min_days_remaining(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum amount of days remaining on the
        expiration of a certificate before a renewal is attempted. The default is
        `30`. A value of less than `0` means that the certificate will never be
        renewed.
        """
        return pulumi.get(self, "min_days_remaining")

    @property
    @pulumi.getter(name="mustStaple")
    def must_staple(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables the [OCSP Stapling Required][ocsp-stapling]
        TLS Security Policy extension. Certificates with this extension must include a
        valid OCSP Staple in the TLS handshake for the connection to succeed.
        Defaults to `false`. Note that this option has no effect when using an
        external CSR - it must be enabled in the CSR itself. Forces a new resource
        when changed.

        [ocsp-stapling]: https://letsencrypt.org/docs/integration-guide/#implement-ocsp-stapling

        > OCSP stapling requires specific webserver configuration to support the
        downloading of the staple from the CA's OCSP endpoints, and should be configured
        to tolerate prolonged outages of the OCSP service. Consider this when using
        `must_staple`, and only enable it if you are sure your webserver or service
        provider can be configured correctly.
        """
        return pulumi.get(self, "must_staple")

    @property
    @pulumi.getter(name="preCheckDelay")
    def pre_check_delay(self) -> pulumi.Output[Optional[int]]:
        """
        Insert a delay after _every_ DNS challenge
        record to allow for extra time for DNS propagation before the certificate is
        requested. Use this option if you observe issues with requesting certificates
        even when DNS challenge records get added successfully. Units are in seconds.
        Defaults to 0 (no delay).

        > Be careful with `pre_check_delay` since the delay is executed _per-domain_.
        Take your expected delay and divide it by the number of domains you have
        configured (`common_name` + `subject_alternative_names`).
        """
        return pulumi.get(self, "pre_check_delay")

    @property
    @pulumi.getter(name="preferredChain")
    def preferred_chain(self) -> pulumi.Output[Optional[str]]:
        """
        The common name of the root of a preferred
        alternate certificate chain offered by the CA. The certificates in
        `issuer_pem` will reflect the chain requested, if available, otherwise the
        default chain will be provided. Forces a new resource when changed.

        > `preferred_chain` can be used to request alternate chains on Let's Encrypt
        during the transition away from their old cross-signed intermediates. See [this
        article for more
        details](https://letsencrypt.org/2020/12/21/extending-android-compatibility.html).
        In their example titled **"What about the alternate chain?"**, the root you
        would put in to the `preferred_chain` field would be `ISRG Root X1`. The
        equivalent in the [staging
        environment](https://letsencrypt.org/docs/staging-environment/) is `(STAGING)
        Pretend Pear X1`.
        """
        return pulumi.get(self, "preferred_chain")

    @property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> pulumi.Output[str]:
        """
        The certificate's private key, in PEM format, if the
        certificate was generated from scratch and not with
        `certificate_request_pem`.  If
        `certificate_request_pem` was used, this will be blank.
        """
        return pulumi.get(self, "private_key_pem")

    @property
    @pulumi.getter(name="recursiveNameservers")
    def recursive_nameservers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The recursive nameservers that will be
        used to check for propagation of DNS challenge records, in addition to some
        in-provider checks such as zone detection. Defaults to your system-configured
        DNS resolvers.
        """
        return pulumi.get(self, "recursive_nameservers")

    @property
    @pulumi.getter(name="revokeCertificateOnDestroy")
    def revoke_certificate_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables revocation of a certificate upon destroy,
        which includes when a resource is re-created. Default is `true`.
        """
        return pulumi.get(self, "revoke_certificate_on_destroy")

    @property
    @pulumi.getter(name="revokeCertificateReason")
    def revoke_certificate_reason(self) -> pulumi.Output[Optional[str]]:
        """
        Some CA's require a reason for revocation to be provided.
        Use this reason (from [RFC 5280, section 5.3.1](https://www.rfc-editor.org/rfc/rfc5280#section-5.3.1).
        By default, no reason provided in revocation requests. The reason is a string, when provided should be one of:
        * unspecified
        * key-compromise
        * ca-compromise
        * affiliation-changed
        * superseded
        * cessation-of-operation
        * certificate-hold
        * remove-from-crl
        * privilege-withdrawn
        * aa-compromise
        """
        return pulumi.get(self, "revoke_certificate_reason")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The certificate's subject alternative names,
        domains that this certificate will also be recognized for. Only valid when not
        specifying a CSR. Forces a new resource when changed.
        """
        return pulumi.get(self, "subject_alternative_names")

    @property
    @pulumi.getter(name="tlsChallenge")
    def tls_challenge(self) -> pulumi.Output[Optional['outputs.CertificateTlsChallenge']]:
        """
        Defines a TLS challenge to use in fulfilling the
        request.

        > Only one of `http_challenge`, `http_webroot_challenge`, `http_s3_challenge`
        and `http_memcached_challenge` can be defined at once. See the section on
        Using HTTP and TLS challenges for more
        details on using these and `tls_challenge`.
        """
        return pulumi.get(self, "tls_challenge")

