import typing


class VstInfo(object):
    def __init__(
        self,
        filename: str,
        binary: typing.Sequence[str],
        parameters: typing.Mapping[str, str],
    ):
        self.filename = filename
        self.binary = binary
        self.parameters = parameters


GRAILLON2 = VstInfo(
    "Auburn Sounds Graillon 2.vst3",
    [
        "qnXPfe5e7f4CAAAAAQAAAAAAAAACAAAAAAAAAAIAAAABAAAAAAAAAAIAAAAAAAAAwgAAAAEAAAAAABAA",
        "sgAAAAEAAAAAAAsgupIAAAAAAAAAAAAFAgAAAAAAJgAAAO87NT8AAAAAAAAAAAAAAAAAAAAAAACAPwAAAAAAAAAA7zs1PwAAAAAAAAAAAAAAAAAAgD8AAAA/AAAAAAAA",
        "AD8AAAAAAAAAAAAAAAAAAIA/0zIBPwAAAAAAAIA/AACAPwAAgD8AAIA/AACAPwAAgD8AAIA/AACAPwAAgD8AAIA/AACAPwAAgD8AAAAAAAAAAAAAAAAAAAAAAAAAAAAA",
        "AAA=",
        "AEZhY3RvcnkgUHJlc2V0czogRGVmYXVsdAAQAAAA",
    ],
    {
        "bitdepth": "12:10",
        "quantize": "13:11",
        "pitch shift": "17:15",
        "preserve formants": "18:16",
        "correction": "19:17",
        "pitch smoothing": "20:18",
        # "allow c": "24:22",
    },
)

COLOURCOPY = VstInfo(
    "ColourCopy.vst3",
    [
        "nn/9SO5e7f4CAAAAAQAAAAAAAAACAAAAAAAAAAIAAAABAAAAAAAAAAIAAAAAAAAAyAkAAAEAAAAAABAA",
        "3AQAAAEAAADYBAAAI3BnbT1pbml0aWFsaXplLmgycAojQU09Q29sb3VyQ29weQojVmVycz0xMDAwMAojRW5kaWFuPWxpdHRsZQojbm09OAojbXM9bm9uZQojbXM9TW9k",
        "V2hsCiNtcz1QaXRjaFcKI21zPUN0cmxBCiNtcz1DdHJsQgojbXM9RW52CiNtcz1MRk8gTAojbXM9TEZPIFIKI252PTAKI2NtPVBDb3JlClNCYXNlPTQKU3dpbmc9MC4w",
        "MApTVHJpZz0xClBQcm9qPTAKUEZvbGQ9MApQRmlsZT0xCkdGaWxlPTIKR1NjYWxlPTAKQ2hMYXk9MApTdXJyTz0xClJldj05Nzc1CkxFRD0wLjAwClBBR0U9MApQYWdl",
        "c09uPTAKQ29yZU49MwpTbGljZT00ClVJX29wPTUKTWlkaUE9NQpNaWRpUD02CkRGb2xkPTcKQ3RybEE9MgpDdHJsQj0xMQojY209TEZPClJhdGU9NTAuMDAKU3RlcmVv",
        "PTkwLjAwCkZNb2Q9MC4wMApXYXZlPTAKI2NtPURlbGF5ClRpbWVCPTgKRGx5UmF0ZT0wLjAwCk5vdGVDdHI9MApUYXBMPTEwMC4wMApUYXBSPTEwMC4wMApMRk9Ucmc9",
        "MApMRk9EcHQ9MC4wMApMRk9EeW49MC4wMApSZWdlbj01MC4wMApJbnZlcnQ9MApCcmlnaHQ9MC4wMApTYXQ9NTAuMDAKQ29sb3VyPTMuMDAKRmxvb3I9MQpEdWNrPTAK",
        "RHVja1RyZz0wCkR1Y2tUaHI9MC4wMApSb3V0SU49MApSb3V0RkI9MApXaWR0aD0xMDAuMDAKTWl4PTUwLjAwCkluRz0wLjAwCk91dEc9MC4wMApQYW5pYz0wCkZyZWV6",
        "ZT0wCkJ5cGFzcz0wCkhRPTAKI2NtPUxNZW0KTGF5TWVtMT0wCiNjbT1TdGlja2VyCnN0a3JUeHQ9OApiZ2lkeD05CnBvc3g9LTEuMDAKcG9zeT0tMS4wMAoKCgoKLy8g",
        "U2VjdGlvbiBmb3IgdWdseSBjb21wcmVzc2VkIGJpbmFyeSBEYXRhCi8vIERPTidUIFRPVUNIIFRISVMKCiQkJCQxMzMzCj9nZGdjZW5lYjphYWFiYWFhYTplYWFhYWFh",
        "YTpnamdvZ2poZTpnamdiZ21najpoa2dmY29naTpkY2hhYWFhYToKb2JjanBjZGw6YW9oZGlvZmE6Y2xsamluZ2I6YWE6bW06YWU6Y2o6ZGg6aWk6aXA6a2Q6YWQ6YWg6",
        "YWk6YW46YgpiOmJnOmRiOmRrOmVhOmViOmVqOmVuOmZpOmZqOmZvOmdhOmdjOmdkIVpZVFJBYWJBMjY1WllUUlFBMTBnamdvCmdqaGVnamdiZ21namhrZ2Zjb2dpZGNo",
        "YUE0OVpZVFJRQTc0WllUUlFBMTBvYkRwY2RsYW9oZGlvZmFjbGxqaW4KZ2JYRmtla25tY0lsYXBtVVZva1dobGhibG9ESExCb2Jua2trU21hZ2tPR2hmbWhvcERCbWZH",
        "bHBpZGxoQ2xuQgpLbmhIaWZrYWhlTnBvRVBsY0ZaWVRSQ0ExMG1iRUpBWllUUkFhYkEyNjVaWVRSaWFBMTM4WllUUkFhYkEyNjVaCllUUk1BMjdaWVRSUUE3ND0zNTk1",
        "MwoAANwEAAAAAAAA2AQAACNwZ209aW5pdGlhbGl6ZS5oMnAKI0FNPUNvbG91ckNvcHkKI1ZlcnM9MTAwMDAKI0VuZGlhbj1saXR0bGUKI25tPTgKI21zPW5vbmUKI21z",
        "PU1vZFdobAojbXM9UGl0Y2hXCiNtcz1DdHJsQQojbXM9Q3RybEIKI21zPUVudgojbXM9TEZPIEwKI21zPUxGTyBSCiNudj0wCiNjbT1QQ29yZQpTQmFzZT00ClN3aW5n",
        "PTAuMDAKU1RyaWc9MQpQUHJvaj0wClBGb2xkPTAKUEZpbGU9MQpHRmlsZT0yCkdTY2FsZT0wCkNoTGF5PTAKU3Vyck89MQpSZXY9OTc3NQpMRUQ9MC4wMApQQUdFPTAK",
        "UGFnZXNPbj0wCkNvcmVOPTMKU2xpY2U9NApVSV9vcD01Ck1pZGlBPTUKTWlkaVA9NgpERm9sZD03CkN0cmxBPTIKQ3RybEI9MTEKI2NtPUxGTwpSYXRlPTUwLjAwClN0",
        "ZXJlbz05MC4wMApGTW9kPTAuMDAKV2F2ZT0wCiNjbT1EZWxheQpUaW1lQj04CkRseVJhdGU9MC4wMApOb3RlQ3RyPTAKVGFwTD0xMDAuMDAKVGFwUj0xMDAuMDAKTEZP",
        "VHJnPTAKTEZPRHB0PTAuMDAKTEZPRHluPTAuMDAKUmVnZW49NTAuMDAKSW52ZXJ0PTAKQnJpZ2h0PTAuMDAKU2F0PTUwLjAwCkNvbG91cj0zLjAwCkZsb29yPTEKRHVj",
        "az0wCkR1Y2tUcmc9MApEdWNrVGhyPTAuMDAKUm91dElOPTAKUm91dEZCPTAKV2lkdGg9MTAwLjAwCk1peD01MC4wMApJbkc9MC4wMApPdXRHPTAuMDAKUGFuaWM9MApG",
        "cmVlemU9MApCeXBhc3M9MApIUT0wCiNjbT1MTWVtCkxheU1lbTE9MAojY209U3RpY2tlcgpzdGtyVHh0PTgKYmdpZHg9OQpwb3N4PS0xLjAwCnBvc3k9LTEuMDAKCgoK",
        "Ci8vIFNlY3Rpb24gZm9yIHVnbHkgY29tcHJlc3NlZCBiaW5hcnkgRGF0YQovLyBET04nVCBUT1VDSCBUSElTCgokJCQkMTMzMwo/Z2RnY2VuZWI6YWFhYmFhYWE6ZWFh",
        "YWFhYWE6Z2pnb2dqaGU6Z2pnYmdtZ2o6aGtnZmNvZ2k6ZGNoYWFhYWE6Cm9iY2pwY2RsOmFvaGRpb2ZhOmNsbGppbmdiOmFhOm1tOmFlOmNqOmRoOmlpOmlwOmtkOmFk",
        "OmFoOmFpOmFuOmIKYjpiZzpkYjpkazplYTplYjplajplbjpmaTpmajpmbzpnYTpnYzpnZCFaWVRSQWFiQTI2NVpZVFJRQTEwZ2pnbwpnamhlZ2pnYmdtZ2poa2dmY29n",
        "aWRjaGFBNDlaWVRSUUE3NFpZVFJRQTEwb2JEcGNkbGFvaGRpb2ZhY2xsamluCmdiWEZrZWtubWNJbGFwbVVWb2tXaGxoYmxvREhMQm9ibmtra1NtYWdrT0doZm1ob3BE",
        "Qm1mR2xwaWRsaENsbkIKS25oSGlma2FoZU5wb0VQbGNGWllUUkNBMTBtYkVKQVpZVFJBYWJBMjY1WllUUmlhQTEzOFpZVFJBYWJBMjY1WgpZVFJNQTI3WllUUlFBNzQ9",
        "MzU5NTMKAAA=",
        "AHByb2dyYW06IFByb2dyYW0gMAAQAAAA",
    ],
    {
        "delay rate": "5:5",
        "tap left": "7:7",
        "tap right": "8:8",
        "regeneration": "12:12",
    },
)

TWANGSTROEM = VstInfo(
    "Twangstrom.vst3",
    [
        "dOz1BO5e7f4EAAAAAQAAAAAAAAACAAAAAAAAAAQAAAAAAAAACAAAAAAAAAACAAAAAQAAAAAAAAACAAAAAAAAAMoMAAABAAAAAAAQAA==",
        "XQYAAAEAAABZBgAAI3BnbT1pbml0aWFsaXplLmgycAojQU09VHdhbmdzdHJvbQojVmVycz0xMDAwMAojRW5kaWFuPWxpdHRsZQojbm09NwojbXM9bm9uZQojbXM9TW9k",
        "V2hsCiNtcz1QaXRjaFcKI21zPUN0cmxBCiNtcz1DdHJsQgojbXM9TEZPCiNtcz1FbnZlbG9wZQojbnY9MAojY209bWFpbgpDcmNSPTEKQ3JjUjI9MQojY209UENvcmUK",
        "U1RyaWc9MQpQUHJvaj0wClBGb2xkPTAKUEZpbGU9MQpHRmlsZT0yCkdTY2FsZT0wCkNoTGF5PTAKU3Vyck89MQpSZXY9OTc3NQpMRUQ9MC4wMApQQUdFPTAKUGFnZXNP",
        "bj0wCkNvcmVOPTMKU2xpY2U9NApVSV9vcD0zCk1pZGlBPTUKTWlkaVA9NgpERm9sZD03CkN0cmxBPTIKQ3RybEI9MTEKI2NtPU1NMQpBY3RpdmU9MQpTb3VyY2U9MApE",
        "ZXN0MT1ub25lOmFzc2lnbmVkCkRlcHRoMT0wLjAwCkN1cnZlMT0yClFudHplMT0wClJlY3QxPTAKU0gxPTAKU2xldzE9MAojY209TU0yCkFjdGl2ZT0xClNvdXJjZT0w",
        "CkRlc3QxPW5vbmU6YXNzaWduZWQKRGVwdGgxPTAuMDAKQ3VydmUxPTIKUW50emUxPTAKUmVjdDE9MApTSDE9MApTbGV3MT0wCiNjbT1NTTMKQWN0aXZlPTEKU291cmNl",
        "PTAKRGVzdDE9bm9uZTphc3NpZ25lZApEZXB0aDE9MC4wMApDdXJ2ZTE9MgpRbnR6ZTE9MApSZWN0MT0wClNIMT0wClNsZXcxPTAKI2NtPUxGTwpTeW5jPTYKV2F2ZT0x",
        "ClJhdGU9MC4wMAojY209RW52ClNvdXJjZT0wCk1vZGU9MApUaHJlcz0tMzAuMDAKQXR0YWNrPTI1LjAwCkRlY2F5PTUwLjAwCiNjbT1JbnAKSW5wdXQ9MC4wMApEcml2",
        "ZT0wLjAwClRvbmU9NTAuMDAKI2NtPVJldgpUZW5zaW9uPTAuMDAKRGVjYXk9NTAuMDAKU2hha2VNPTAuMDAKRGVuc2l0eT0wLjAwCkxDRF9ubzE9OApMQ0Rfbm8yPTkK",
        "TENEX25vMz0xMApUeXBlPTIKQ291cGxlPTAKQnJpZ2h0PTAKI2NtPUZsdApmcmVxPTE1MC4wMApzdGVyZW89MC4wMApyZXNvPTAuMDAKYmxlbmQ9MC4wMAp0eXBlPTEK",
        "I2NtPU91dApNaXg9NTAuMDAKV2lkdGg9MTAwLjAwCkdhaW5NaXg9MC4wMApCeXBhc3M9MApvdXRjbHA9MAojY209QW1wTW9kClNyYz0wCkRlcHRoPTAuMDAKI2NtPUxN",
        "ZW0KTGF5TWVtMT0wCgoKCgovLyBTZWN0aW9uIGZvciB1Z2x5IGNvbXByZXNzZWQgYmluYXJ5IERhdGEKLy8gRE9OJ1QgVE9VQ0ggVEhJUwoKJCQkJDEyOTgKP2dkZ2Nl",
        "bmViOmFhYWJhYWFhOmVhYWFhYWFhOmFrYWFhYWFhOmFhYWFpYWRwOmdqZ29namhlOmdqZ2JnbWdqOgpoa2dmY29naTpkY2hhYWFhYTpvYmNqcGNkbDphYTpjbjprZDpt",
        "bTphZTpjajpkYjpkYzppYTppaTppcDphYjphCmQ6YWc6YWk6YWs6YW46YW86Ymc6Y2w6ZGQ6ZGg6ZGk6ZGo6ZGs6ZHAhZ2RnY2VuZWJBTEEyNjVnZGdjZW5lYmUKYUEx",
        "MGdqZ29namhlZ2pnYmdtZ2poa2dmY29naUhoYUE0OWdkZ2NlbmViZWFBNzRnZGdjZW5lYmVhQTEwb2JGcApjZGxSaGRpb2ZhVGxqaW5nYmdhSmtla25tY01sYXBtZmlm",
        "am9rZm9obGhibG9GQ1FEb2Jua2trZWptYWdrR0toCmZtaG9wRkRtZktscGlkbGhFbG5ET25oQ2lma2FoZVNwb1ZZbGNKZ2RnY2VuZWJFQTEwTENOQWdkZ2NlbmViQUwK",
        "QTI2NWdkZ2NlbmViSUExMzhnZGdjZW5lYkFMQTI2NWdkZ2NlbmViUEE4SVplZEJIR0E1Z2RnY2VuZWJQQThJWgplZkJVV0E1Z2RnY2VuZWJQQThJWmVlQkhYQTU9NDM2",
        "NDMKAABdBgAAAAAAAFkGAAAjcGdtPWluaXRpYWxpemUuaDJwCiNBTT1Ud2FuZ3N0cm9tCiNWZXJzPTEwMDAwCiNFbmRpYW49bGl0dGxlCiNubT03CiNtcz1ub25lCiNt",
        "cz1Nb2RXaGwKI21zPVBpdGNoVwojbXM9Q3RybEEKI21zPUN0cmxCCiNtcz1MRk8KI21zPUVudmVsb3BlCiNudj0wCiNjbT1tYWluCkNyY1I9MQpDcmNSMj0xCiNjbT1Q",
        "Q29yZQpTVHJpZz0xClBQcm9qPTAKUEZvbGQ9MApQRmlsZT0xCkdGaWxlPTIKR1NjYWxlPTAKQ2hMYXk9MApTdXJyTz0xClJldj05Nzc1CkxFRD0wLjAwClBBR0U9MApQ",
        "YWdlc09uPTAKQ29yZU49MwpTbGljZT00ClVJX29wPTMKTWlkaUE9NQpNaWRpUD02CkRGb2xkPTcKQ3RybEE9MgpDdHJsQj0xMQojY209TU0xCkFjdGl2ZT0xClNvdXJj",
        "ZT0wCkRlc3QxPW5vbmU6YXNzaWduZWQKRGVwdGgxPTAuMDAKQ3VydmUxPTIKUW50emUxPTAKUmVjdDE9MApTSDE9MApTbGV3MT0wCiNjbT1NTTIKQWN0aXZlPTEKU291",
        "cmNlPTAKRGVzdDE9bm9uZTphc3NpZ25lZApEZXB0aDE9MC4wMApDdXJ2ZTE9MgpRbnR6ZTE9MApSZWN0MT0wClNIMT0wClNsZXcxPTAKI2NtPU1NMwpBY3RpdmU9MQpT",
        "b3VyY2U9MApEZXN0MT1ub25lOmFzc2lnbmVkCkRlcHRoMT0wLjAwCkN1cnZlMT0yClFudHplMT0wClJlY3QxPTAKU0gxPTAKU2xldzE9MAojY209TEZPClN5bmM9NgpX",
        "YXZlPTEKUmF0ZT0wLjAwCiNjbT1FbnYKU291cmNlPTAKTW9kZT0wClRocmVzPS0zMC4wMApBdHRhY2s9MjUuMDAKRGVjYXk9NTAuMDAKI2NtPUlucApJbnB1dD0wLjAw",
        "CkRyaXZlPTAuMDAKVG9uZT01MC4wMAojY209UmV2ClRlbnNpb249MC4wMApEZWNheT01MC4wMApTaGFrZU09MC4wMApEZW5zaXR5PTAuMDAKTENEX25vMT04CkxDRF9u",
        "bzI9OQpMQ0Rfbm8zPTEwClR5cGU9MgpDb3VwbGU9MApCcmlnaHQ9MAojY209Rmx0CmZyZXE9MTUwLjAwCnN0ZXJlbz0wLjAwCnJlc289MC4wMApibGVuZD0wLjAwCnR5",
        "cGU9MQojY209T3V0Ck1peD01MC4wMApXaWR0aD0xMDAuMDAKR2Fpbk1peD0wLjAwCkJ5cGFzcz0wCm91dGNscD0wCiNjbT1BbXBNb2QKU3JjPTAKRGVwdGg9MC4wMAoj",
        "Y209TE1lbQpMYXlNZW0xPTAKCgoKCi8vIFNlY3Rpb24gZm9yIHVnbHkgY29tcHJlc3NlZCBiaW5hcnkgRGF0YQovLyBET04nVCBUT1VDSCBUSElTCgokJCQkMTI5OAo/",
        "Z2RnY2VuZWI6YWFhYmFhYWE6ZWFhYWFhYWE6YWthYWFhYWE6YWFhYWlhZHA6Z2pnb2dqaGU6Z2pnYmdtZ2o6CmhrZ2Zjb2dpOmRjaGFhYWFhOm9iY2pwY2RsOmFhOmNu",
        "OmtkOm1tOmFlOmNqOmRiOmRjOmlhOmlpOmlwOmFiOmEKZDphZzphaTphazphbjphbzpiZzpjbDpkZDpkaDpkaTpkajpkazpkcCFnZGdjZW5lYkFMQTI2NWdkZ2NlbmVi",
        "ZQphQTEwZ2pnb2dqaGVnamdiZ21namhrZ2Zjb2dpSGhhQTQ5Z2RnY2VuZWJlYUE3NGdkZ2NlbmViZWFBMTBvYkZwCmNkbFJoZGlvZmFUbGppbmdiZ2FKa2Vrbm1jTWxh",
        "cG1maWZqb2tmb2hsaGJsb0ZDUURvYm5ra2tlam1hZ2tHS2gKZm1ob3BGRG1mS2xwaWRsaEVsbkRPbmhDaWZrYWhlU3BvVllsY0pnZGdjZW5lYkVBMTBMQ05BZ2RnY2Vu",
        "ZWJBTApBMjY1Z2RnY2VuZWJJQTEzOGdkZ2NlbmViQUxBMjY1Z2RnY2VuZWJQQThJWmVkQkhHQTVnZGdjZW5lYlBBOElaCmVmQlVXQTVnZGdjZW5lYlBBOElaZWVCSFhB",
        "NT00MzY0MwoAAA==",
        "AHByb2dyYW06IFByb2dyYW0gMAAQAAAA",
    ],
    {
        "drive": "15:15",
        "tone": "16:16",
        "tension": "17:17",
        "decay": "18:18",
        # "shake": "19:19",
        "density": "20:20",
    },
)
