# ronswanson
![CI](https://github.com/grburgess/ronswanson/workflows/CI/badge.svg?branch=master)
[![codecov](https://codecov.io/gh/grburgess/ronswanson/branch/master/graph/badge.svg)](https://codecov.io/gh/grburgess/ronswanson)
[![Documentation Status](https://readthedocs.org/projects/ronswanson/badge/?version=latest)](http://jmichaelburgess.com/ronswanson/index.html)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3372456.svg)](https://doi.org/10.5281/zenodo.3372456)
![PyPI](https://img.shields.io/pypi/v/ronswanson)
![PyPI - Downloads](https://img.shields.io/pypi/dm/ronswanson)

![alt text](https://raw.githubusercontent.com/grburgess/ronswanson/master/docs/media/logo.png)


Ron Swanson builds tables for 3ML.

This tool provides an easy interface to construct 3ML table models from
computational expensive simulations on HPC systems. Why? Because it is your
right to do so!

## Installation

```sh
pip install ronswanson
```
or

```sh
git clone https://github.com/grburgess/ronswanson
cd ronswanson
python setup.py install
```


## Contributing

Contributions to `ronswanson` are always welcome. They can come in the form of:

### Bug reports

Please use the [Github issue tracking system for any
bugs](https://github.com/grburgess/ronswanson/issues), for questions,
and or feature requests.

### Code

Additional features you have the impetus to add are always welcome. Please
follow the PEP8 python standards and format your code with
[black](https://github.com/psf/black)



### Documentation

Additions or examples, tutorials, or better explanations are always
welcome. To ensure that the documentation builds with the current
version of the software, I am using
[jupytext](https://jupytext.readthedocs.io/en/latest/) to write the
documentation in Markdown. These are automatically converted to and
executed as jupyter notebooks when changes are pushed to Github.



## Credits
Inspiration by Elisa Schoesser.
