/*
 * SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
 * SPDX-License-Identifier: BSD-3-Clause
 */

// Autogenerated by Thrift Compiler (0.14.1-yarped)
//
// This is an automatically generated file.
// It could get re-generated if the ALLOW_IDL_GENERATION flag is on.

#ifndef YARP_THRIFT_GENERATOR_STRUCT_LASERSCAN2D_H
#define YARP_THRIFT_GENERATOR_STRUCT_LASERSCAN2D_H

#include <yarp/dev/api.h>

#include <yarp/os/Wire.h>
#include <yarp/os/idl/WireTypes.h>
#include <yarp/sig/Vector.h>

namespace yarp {
namespace dev {

class YARP_dev_API LaserScan2D :
        public yarp::os::idl::WirePortable
{
public:
    // Fields
    /**
     * first angle of the scan [deg]
     */
    double angle_min;
    /**
     * last angle of the scan [deg]
     */
    double angle_max;
    /**
     * the minimum distance of the scan [m]
     */
    double range_min;
    /**
     * the maximum distance of the scan [m]
     */
    double range_max;
    /**
     * the scan data, measured in [m]. The angular increment of each ray is obtained by (angle_max-angle_min)/num_of_elements. Invalid data are represented as std::inf.
     */
    yarp::sig::Vector scans;
    std::int32_t status;

    // Default constructor
    LaserScan2D();

    // Constructor with field values
    LaserScan2D(const double angle_min,
                const double angle_max,
                const double range_min,
                const double range_max,
                const yarp::sig::Vector& scans,
                const std::int32_t status);

    // Read structure on a Wire
    bool read(yarp::os::idl::WireReader& reader) override;

    // Read structure on a Connection
    bool read(yarp::os::ConnectionReader& connection) override;

    // Write structure on a Wire
    bool write(const yarp::os::idl::WireWriter& writer) const override;

    // Write structure on a Connection
    bool write(yarp::os::ConnectionWriter& connection) const override;

    // Convert to a printable string
    std::string toString() const;

    // If you want to serialize this class without nesting, use this helper
    typedef yarp::os::idl::Unwrapped<LaserScan2D> unwrapped;

    class Editor :
            public yarp::os::Wire,
            public yarp::os::PortWriter
    {
    public:
        // Editor: default constructor
        Editor();

        // Editor: constructor with base class
        Editor(LaserScan2D& obj);

        // Editor: destructor
        ~Editor() override;

        // Editor: Deleted constructors and operator=
        Editor(const Editor& rhs) = delete;
        Editor(Editor&& rhs) = delete;
        Editor& operator=(const Editor& rhs) = delete;
        Editor& operator=(Editor&& rhs) = delete;

        // Editor: edit
        bool edit(LaserScan2D& obj, bool dirty = true);

        // Editor: validity check
        bool isValid() const;

        // Editor: state
        LaserScan2D& state();

        // Editor: start editing
        void start_editing();

#ifndef YARP_NO_DEPRECATED // Since YARP 3.2
        YARP_DEPRECATED_MSG("Use start_editing() instead")
        void begin()
        {
            start_editing();
        }
#endif // YARP_NO_DEPRECATED

        // Editor: stop editing
        void stop_editing();

#ifndef YARP_NO_DEPRECATED // Since YARP 3.2
        YARP_DEPRECATED_MSG("Use stop_editing() instead")
        void end()
        {
            stop_editing();
        }
#endif // YARP_NO_DEPRECATED

        // Editor: angle_min field
        void set_angle_min(const double angle_min);
        double get_angle_min() const;
        virtual bool will_set_angle_min();
        virtual bool did_set_angle_min();

        // Editor: angle_max field
        void set_angle_max(const double angle_max);
        double get_angle_max() const;
        virtual bool will_set_angle_max();
        virtual bool did_set_angle_max();

        // Editor: range_min field
        void set_range_min(const double range_min);
        double get_range_min() const;
        virtual bool will_set_range_min();
        virtual bool did_set_range_min();

        // Editor: range_max field
        void set_range_max(const double range_max);
        double get_range_max() const;
        virtual bool will_set_range_max();
        virtual bool did_set_range_max();

        // Editor: scans field
        void set_scans(const yarp::sig::Vector& scans);
        const yarp::sig::Vector& get_scans() const;
        virtual bool will_set_scans();
        virtual bool did_set_scans();

        // Editor: status field
        void set_status(const std::int32_t status);
        std::int32_t get_status() const;
        virtual bool will_set_status();
        virtual bool did_set_status();

        // Editor: clean
        void clean();

        // Editor: read
        bool read(yarp::os::ConnectionReader& connection) override;

        // Editor: write
        bool write(yarp::os::ConnectionWriter& connection) const override;

    private:
        // Editor: state
        LaserScan2D* obj;
        bool obj_owned;
        int group;

        // Editor: dirty variables
        bool is_dirty;
        bool is_dirty_angle_min;
        bool is_dirty_angle_max;
        bool is_dirty_range_min;
        bool is_dirty_range_max;
        bool is_dirty_scans;
        bool is_dirty_status;
        int dirty_count;

        // Editor: send if possible
        void communicate();

        // Editor: mark dirty overall
        void mark_dirty();

        // Editor: mark dirty single fields
        void mark_dirty_angle_min();
        void mark_dirty_angle_max();
        void mark_dirty_range_min();
        void mark_dirty_range_max();
        void mark_dirty_scans();
        void mark_dirty_status();

        // Editor: dirty_flags
        void dirty_flags(bool flag);
    };

private:
    // read/write angle_min field
    bool read_angle_min(yarp::os::idl::WireReader& reader);
    bool write_angle_min(const yarp::os::idl::WireWriter& writer) const;
    bool nested_read_angle_min(yarp::os::idl::WireReader& reader);
    bool nested_write_angle_min(const yarp::os::idl::WireWriter& writer) const;

    // read/write angle_max field
    bool read_angle_max(yarp::os::idl::WireReader& reader);
    bool write_angle_max(const yarp::os::idl::WireWriter& writer) const;
    bool nested_read_angle_max(yarp::os::idl::WireReader& reader);
    bool nested_write_angle_max(const yarp::os::idl::WireWriter& writer) const;

    // read/write range_min field
    bool read_range_min(yarp::os::idl::WireReader& reader);
    bool write_range_min(const yarp::os::idl::WireWriter& writer) const;
    bool nested_read_range_min(yarp::os::idl::WireReader& reader);
    bool nested_write_range_min(const yarp::os::idl::WireWriter& writer) const;

    // read/write range_max field
    bool read_range_max(yarp::os::idl::WireReader& reader);
    bool write_range_max(const yarp::os::idl::WireWriter& writer) const;
    bool nested_read_range_max(yarp::os::idl::WireReader& reader);
    bool nested_write_range_max(const yarp::os::idl::WireWriter& writer) const;

    // read/write scans field
    bool read_scans(yarp::os::idl::WireReader& reader);
    bool write_scans(const yarp::os::idl::WireWriter& writer) const;
    bool nested_read_scans(yarp::os::idl::WireReader& reader);
    bool nested_write_scans(const yarp::os::idl::WireWriter& writer) const;

    // read/write status field
    bool read_status(yarp::os::idl::WireReader& reader);
    bool write_status(const yarp::os::idl::WireWriter& writer) const;
    bool nested_read_status(yarp::os::idl::WireReader& reader);
    bool nested_write_status(const yarp::os::idl::WireWriter& writer) const;
};

} // namespace yarp
} // namespace dev

#endif // YARP_THRIFT_GENERATOR_STRUCT_LASERSCAN2D_H
