from setuptools import setup, find_packages

if __name__ == "__main__":
    setup(
        name="polyatomic_complexes",
        version="1.0.5",
        packages=find_packages(),
        include_package_data=True,
        package_data={
            "polyatomic_complexes": [
                "dataset/construct/*",
                "dataset/esol/ESOL.csv",
                "dataset/free_solv/FreeSolv.csv",
                "dataset/lipophilicity/Lipophilicity.csv",
                "dataset/photoswitches/photoswitches.csv",
            ],
        },
        install_requires=[
            "ase>=3.24.0",
            "babel>=2.16.0",
            "beautifulsoup4>=4.12.3",
            "biopandas>=0.5.1",
            "biopython>=1.84",
            "bioservices>=1.11.2",
            "botorch>=0.12.0",
            "cpdb-protein>=0.2.0",
            "dftd3>=1.2.1",
            "dill>=0.3.9",
            "gauche>=0.1.6",
            "geometric>=1.0.2",
            "git-lfs>=1.6",
            "gpytorch>=1.13",
            "GraKeL>=0.1.10",
            "graphein>=1.7.7",
            "gudhi>=3.10.1",
            "jax>=0.4.38",
            "jaxlib>=0.4.38",
            "matplotlib>=3.10.0",
            "monty>=2025.1.9",
            "mpmath>=1.3.0",
            "networkx>=3.4.2",
            "numpy>=1.26.4",
            "pandas",
            "periodictable>=2.0.2",
            "pillow>=11.1.0",
            "plotly>=5.24.1",
            "pymatgen>=2025.1.9",
            "pyro-api>=0.1.2",
            "pyro-ppl>=1.9.1",
            "pyscf>=2.8.0",
            "rdkit>=2024.9.4",
            "scikit-learn>=1.6.1",
            "scipy>=1.15.0",
            "seaborn>=0.13.2",
            "selfies>=2.1.2",
            "sympy>=1.13.1",
            "TopoNetX>=0.2.0",
            "torch>=2.5.1",
        ],
    )
