"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUserPoolAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
class HttpUserPoolAuthorizer {
    /**
     * (experimental) Initialize a Cognito user pool authorizer to be bound with HTTP route.
     *
     * @param id The id of the underlying construct.
     * @param pool The user pool to use for authorization.
     * @param props Properties to configure the authorizer.
     * @experimental
     */
    constructor(id, pool, props = {}) {
        this.id = id;
        this.pool = pool;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_HttpUserPoolAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c, _d, _e;
        if (!this.authorizer) {
            const region = (_b = this.props.userPoolRegion) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.Stack.of(options.scope).region;
            const clients = (_c = this.props.userPoolClients) !== null && _c !== void 0 ? _c : [this.pool.addClient('UserPoolAuthorizerClient')];
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_d = this.props.identitySource) !== null && _d !== void 0 ? _d : ['$request.header.Authorization'],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.JWT,
                authorizerName: (_e = this.props.authorizerName) !== null && _e !== void 0 ? _e : this.id,
                jwtAudience: clients.map((c) => c.userPoolClientId),
                jwtIssuer: `https://cognito-idp.${region}.amazonaws.com/${this.pool.userPoolId}`,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpUserPoolAuthorizer = HttpUserPoolAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpUserPoolAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpUserPoolAuthorizer", version: "2.11.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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