"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaAuthorizer = exports.HttpLambdaResponseType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) Specifies the type responses the lambda returns.
 *
 * @experimental
 */
var HttpLambdaResponseType;
(function (HttpLambdaResponseType) {
    HttpLambdaResponseType[HttpLambdaResponseType["SIMPLE"] = 0] = "SIMPLE";
    HttpLambdaResponseType[HttpLambdaResponseType["IAM"] = 1] = "IAM";
})(HttpLambdaResponseType = exports.HttpLambdaResponseType || (exports.HttpLambdaResponseType = {}));
/**
 * (experimental) Authorize Http Api routes via a lambda function.
 *
 * @experimental
 */
class HttpLambdaAuthorizer {
    /**
     * (experimental) Initialize a lambda authorizer to be bound with HTTP route.
     *
     * @param id The id of the underlying construct.
     * @param props Properties to configure the authorizer.
     * @experimental
     */
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_HttpLambdaAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c, _d, _e;
        if (this.httpApi && (this.httpApi.apiId !== options.route.httpApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            const responseTypes = (_b = this.props.responseTypes) !== null && _b !== void 0 ? _b : [HttpLambdaResponseType.IAM];
            const enableSimpleResponses = responseTypes.includes(HttpLambdaResponseType.SIMPLE) || undefined;
            this.httpApi = options.route.httpApi;
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_c = this.props.identitySource) !== null && _c !== void 0 ? _c : [
                    '$request.header.Authorization',
                ],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.LAMBDA,
                authorizerName: (_d = this.props.authorizerName) !== null && _d !== void 0 ? _d : this.id,
                enableSimpleResponses,
                payloadFormatVersion: enableSimpleResponses ? aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_2_0 : aws_apigatewayv2_alpha_1.AuthorizerPayloadVersion.VERSION_1_0,
                authorizerUri: lambdaAuthorizerArn(this.handler),
                resultsCacheTtl: (_e = this.props.resultsCacheTtl) !== null && _e !== void 0 ? _e : aws_cdk_lib_1.Duration.minutes(5),
            });
            this.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: aws_cdk_lib_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.httpApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.HttpLambdaAuthorizer = HttpLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpLambdaAuthorizer", version: "2.11.0-alpha.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${aws_cdk_lib_1.Stack.of(handler).partition}:apigateway:${aws_cdk_lib_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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