<a id="mypy-boto3-wisdom"></a>

# mypy-boto3-wisdom

[![PyPI - mypy-boto3-wisdom](https://img.shields.io/pypi/v/mypy-boto3-wisdom.svg?color=blue)](https://pypi.org/project/mypy-boto3-wisdom)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-wisdom.svg?color=blue)](https://pypi.org/project/mypy-boto3-wisdom)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-wisdom?color=blue)](https://pypistats.org/packages/mypy-boto3-wisdom)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ConnectWisdomService 1.19.0](https://boto3.amazonaws.com/v1/documentation/api/1.19.0/reference/services/wisdom.html#ConnectWisdomService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.5.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-wisdom docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_wisdom/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-wisdom](#mypy-boto3-wisdom)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `ConnectWisdomService` service.

```bash
python -m pip install boto3-stubs[wisdom]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[wisdom]` in your environment:
  `python -m pip install 'boto3-stubs[wisdom]'`

Both type checking and auto-complete should work for `ConnectWisdomService`
service. No explicit type annotations required, write your `boto3` code as
usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[wisdom]` in your environment:
  `python -m pip install 'boto3-stubs[wisdom]'`

Both type checking and auto-complete should work for `ConnectWisdomService`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[wisdom]` in your environment:
  `python -m pip install 'boto3-stubs[wisdom]'`
- Run `mypy` as usual

Type checking should work for `ConnectWisdomService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[wisdom]` in your environment:
  `python -m pip install 'boto3-stubs[wisdom]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ConnectWisdomService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`ConnectWisdomServiceClient` provides annotations for `boto3.client("wisdom")`.

```python
import boto3

from mypy_boto3_wisdom import ConnectWisdomServiceClient

client: ConnectWisdomServiceClient = boto3.client("wisdom")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ConnectWisdomServiceClient = session.client("wisdom")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_wisdom.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_wisdom import ConnectWisdomServiceClient
from mypy_boto3_wisdom.paginator import (
    ListAssistantAssociationsPaginator,
    ListAssistantsPaginator,
    ListContentsPaginator,
    ListKnowledgeBasesPaginator,
    QueryAssistantPaginator,
    SearchContentPaginator,
    SearchSessionsPaginator,
)

client: ConnectWisdomServiceClient = boto3.client("wisdom")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_assistant_associations_paginator: ListAssistantAssociationsPaginator = client.get_paginator("list_assistant_associations")
list_assistants_paginator: ListAssistantsPaginator = client.get_paginator("list_assistants")
list_contents_paginator: ListContentsPaginator = client.get_paginator("list_contents")
list_knowledge_bases_paginator: ListKnowledgeBasesPaginator = client.get_paginator("list_knowledge_bases")
query_assistant_paginator: QueryAssistantPaginator = client.get_paginator("query_assistant")
search_content_paginator: SearchContentPaginator = client.get_paginator("search_content")
search_sessions_paginator: SearchSessionsPaginator = client.get_paginator("search_sessions")
```

<a id="literals"></a>

### Literals

`mypy_boto3_wisdom.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_wisdom.literals import (
    AssistantStatusType,
    AssistantTypeType,
    AssociationTypeType,
    ContentStatusType,
    FilterFieldType,
    FilterOperatorType,
    KnowledgeBaseStatusType,
    KnowledgeBaseTypeType,
    ListAssistantAssociationsPaginatorName,
    ListAssistantsPaginatorName,
    ListContentsPaginatorName,
    ListKnowledgeBasesPaginatorName,
    QueryAssistantPaginatorName,
    RelevanceLevelType,
    SearchContentPaginatorName,
    SearchSessionsPaginatorName,
    ServiceName,
    PaginatorName,
)

def check_value(value: AssistantStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_wisdom.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_wisdom.type_defs import (
    AppIntegrationsConfigurationTypeDef,
    AssistantAssociationDataTypeDef,
    AssistantAssociationInputDataTypeDef,
    AssistantAssociationOutputDataTypeDef,
    AssistantAssociationSummaryTypeDef,
    AssistantDataTypeDef,
    AssistantSummaryTypeDef,
    ContentDataTypeDef,
    ContentReferenceTypeDef,
    ContentSummaryTypeDef,
    CreateAssistantAssociationRequestRequestTypeDef,
    CreateAssistantAssociationResponseTypeDef,
    CreateAssistantRequestRequestTypeDef,
    CreateAssistantResponseTypeDef,
    CreateContentRequestRequestTypeDef,
    CreateContentResponseTypeDef,
    CreateKnowledgeBaseRequestRequestTypeDef,
    CreateKnowledgeBaseResponseTypeDef,
    CreateSessionRequestRequestTypeDef,
    CreateSessionResponseTypeDef,
    DeleteAssistantAssociationRequestRequestTypeDef,
    DeleteAssistantRequestRequestTypeDef,
    DeleteContentRequestRequestTypeDef,
    DeleteKnowledgeBaseRequestRequestTypeDef,
    DocumentTextTypeDef,
    DocumentTypeDef,
    FilterTypeDef,
    GetAssistantAssociationRequestRequestTypeDef,
    GetAssistantAssociationResponseTypeDef,
    GetAssistantRequestRequestTypeDef,
    GetAssistantResponseTypeDef,
    GetContentRequestRequestTypeDef,
    GetContentResponseTypeDef,
    GetContentSummaryRequestRequestTypeDef,
    GetContentSummaryResponseTypeDef,
    GetKnowledgeBaseRequestRequestTypeDef,
    GetKnowledgeBaseResponseTypeDef,
    GetRecommendationsRequestRequestTypeDef,
    GetRecommendationsResponseTypeDef,
    GetSessionRequestRequestTypeDef,
    GetSessionResponseTypeDef,
    HighlightTypeDef,
    KnowledgeBaseAssociationDataTypeDef,
    KnowledgeBaseDataTypeDef,
    KnowledgeBaseSummaryTypeDef,
    ListAssistantAssociationsRequestRequestTypeDef,
    ListAssistantAssociationsResponseTypeDef,
    ListAssistantsRequestRequestTypeDef,
    ListAssistantsResponseTypeDef,
    ListContentsRequestRequestTypeDef,
    ListContentsResponseTypeDef,
    ListKnowledgeBasesRequestRequestTypeDef,
    ListKnowledgeBasesResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    NotifyRecommendationsReceivedErrorTypeDef,
    NotifyRecommendationsReceivedRequestRequestTypeDef,
    NotifyRecommendationsReceivedResponseTypeDef,
    PaginatorConfigTypeDef,
    QueryAssistantRequestRequestTypeDef,
    QueryAssistantResponseTypeDef,
    RecommendationDataTypeDef,
    RemoveKnowledgeBaseTemplateUriRequestRequestTypeDef,
    RenderingConfigurationTypeDef,
    ResponseMetadataTypeDef,
    ResultDataTypeDef,
    SearchContentRequestRequestTypeDef,
    SearchContentResponseTypeDef,
    SearchExpressionTypeDef,
    SearchSessionsRequestRequestTypeDef,
    SearchSessionsResponseTypeDef,
    ServerSideEncryptionConfigurationTypeDef,
    SessionDataTypeDef,
    SessionSummaryTypeDef,
    SourceConfigurationTypeDef,
    StartContentUploadRequestRequestTypeDef,
    StartContentUploadResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateContentRequestRequestTypeDef,
    UpdateContentResponseTypeDef,
    UpdateKnowledgeBaseTemplateUriRequestRequestTypeDef,
    UpdateKnowledgeBaseTemplateUriResponseTypeDef,
)

def get_structure() -> AppIntegrationsConfigurationTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-wisdom` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-wisdom docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_wisdom/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
