# Release notes for MASSpy 0.1.3

The MASSpy publication can be cited!


## New features

Working toward the next major release, in the meantime...


* Added Python 3.8 and 3.9 support

* Installation and setup updates based on the following PEP guidelines:

    - [PEP 440](https://www.python.org/dev/peps/pep-0440/)
    - [PEP 517](https://www.python.org/dev/peps/pep-0517/)
    - [PEP 518](https://www.python.org/dev/peps/pep-0518/)
    - [PEP 566](https://www.python.org/dev/peps/pep-0566/)

* MASSpy now contains several new tools for standardized testing and development!

    - New CI-CD testing workflow in **main.yml** for GitHub actions and
      coverage using [CodeCov](https://codecov.io/)
    - Configuration for tools is primarily in **pyproject.toml**. Options without
      `.toml` compatibility are in **setup.cfg**

#### Details for installation and setup updates.
* Apply `src/` layout to package
* Applied new PEP guidelines for setup using **pyproject.toml**
    - New file **pyproject.toml** for building package based on **setup.cfg**,
      [setuptools](https://setuptools.readthedocs.io/en/latest/setuptools.html),
      and [pypa/build](https://github.com/pypa/build).

#### Standardized testing and development tools
* Implemented [tox](https://tox.readthedocs.io/en/latest/) for testing. Configuration is found in **pyproject.toml**.

    - Utilize `pytest` for testing, and coverage via `pytest-cov` for coverage reports.
    - Added `lint`, `safety`, and `py3{6,7} testing environments.

* Implemented [pre-commit](https://pre-commit.com/) for maintaining repository. Utilizes pre-commit hooks for

    - [isort](https://github.com/PyCQA/isort), [black](https://black.readthedocs.io/en/stable/), and [flake8](https://flake8.pycqa.org/en/3.8.4/) for linting.
    - Several additional [pre-commit hooks](https://github.com/pre-commit/pre-commit-hooks) and [pygrep hooks](https://github.com/pre-commit/pygrep-hooks)
      for formatting other file types.
    - Configuration found in new **.pre-commit-config.yaml**

## Fixes

* Udated CI-CD workflow to one single file (main)
* Updates to sphinx documentation builder to account for new build.
* Code of conduct
* Added security policy
* .gitignore improvements
* Updated manifest
* Updated README.rst to .md
* Dockerfile bugfixes and more organization
* Sphinx make file cleanup
* Additional repository links
* Added MASSpy publication for citation!
* Badge fixes


## Backwards incompatible changes
* test data within the MASSpy package is now example_data. methods change to reflect
* Test methods and model still exist, but outside the package in the tests directory
