# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WorkPlanRotationResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WorkPlanRotationResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'enabled': 'bool',
            'date_range': 'DateRangeWithOptionalEnd',
            'pattern': 'WorkPlanPatternResponse',
            'agent_count': 'int',
            'agents': 'list[WorkPlanRotationAgentResponse]',
            'metadata': 'WfmVersionedEntityMetadata',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'enabled': 'enabled',
            'date_range': 'dateRange',
            'pattern': 'pattern',
            'agent_count': 'agentCount',
            'agents': 'agents',
            'metadata': 'metadata',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._enabled = None
        self._date_range = None
        self._pattern = None
        self._agent_count = None
        self._agents = None
        self._metadata = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this WorkPlanRotationResponse.
        The globally unique identifier for the object.

        :return: The id of this WorkPlanRotationResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WorkPlanRotationResponse.
        The globally unique identifier for the object.

        :param id: The id of this WorkPlanRotationResponse.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this WorkPlanRotationResponse.


        :return: The name of this WorkPlanRotationResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WorkPlanRotationResponse.


        :param name: The name of this WorkPlanRotationResponse.
        :type: str
        """
        
        self._name = name

    @property
    def enabled(self):
        """
        Gets the enabled of this WorkPlanRotationResponse.
        Whether the work plan rotation is enabled for scheduling

        :return: The enabled of this WorkPlanRotationResponse.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this WorkPlanRotationResponse.
        Whether the work plan rotation is enabled for scheduling

        :param enabled: The enabled of this WorkPlanRotationResponse.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def date_range(self):
        """
        Gets the date_range of this WorkPlanRotationResponse.
        The date range to which this work plan rotation applies

        :return: The date_range of this WorkPlanRotationResponse.
        :rtype: DateRangeWithOptionalEnd
        """
        return self._date_range

    @date_range.setter
    def date_range(self, date_range):
        """
        Sets the date_range of this WorkPlanRotationResponse.
        The date range to which this work plan rotation applies

        :param date_range: The date_range of this WorkPlanRotationResponse.
        :type: DateRangeWithOptionalEnd
        """
        
        self._date_range = date_range

    @property
    def pattern(self):
        """
        Gets the pattern of this WorkPlanRotationResponse.
        Pattern with ordered list of work plans that rotate on a weekly basis

        :return: The pattern of this WorkPlanRotationResponse.
        :rtype: WorkPlanPatternResponse
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """
        Sets the pattern of this WorkPlanRotationResponse.
        Pattern with ordered list of work plans that rotate on a weekly basis

        :param pattern: The pattern of this WorkPlanRotationResponse.
        :type: WorkPlanPatternResponse
        """
        
        self._pattern = pattern

    @property
    def agent_count(self):
        """
        Gets the agent_count of this WorkPlanRotationResponse.
        Number of agents in this work plan rotation

        :return: The agent_count of this WorkPlanRotationResponse.
        :rtype: int
        """
        return self._agent_count

    @agent_count.setter
    def agent_count(self, agent_count):
        """
        Sets the agent_count of this WorkPlanRotationResponse.
        Number of agents in this work plan rotation

        :param agent_count: The agent_count of this WorkPlanRotationResponse.
        :type: int
        """
        
        self._agent_count = agent_count

    @property
    def agents(self):
        """
        Gets the agents of this WorkPlanRotationResponse.
        Agents in this work plan rotation. Populate with expand=agents for GET WorkPlanRotationsList (defaults to empty list)

        :return: The agents of this WorkPlanRotationResponse.
        :rtype: list[WorkPlanRotationAgentResponse]
        """
        return self._agents

    @agents.setter
    def agents(self, agents):
        """
        Sets the agents of this WorkPlanRotationResponse.
        Agents in this work plan rotation. Populate with expand=agents for GET WorkPlanRotationsList (defaults to empty list)

        :param agents: The agents of this WorkPlanRotationResponse.
        :type: list[WorkPlanRotationAgentResponse]
        """
        
        self._agents = agents

    @property
    def metadata(self):
        """
        Gets the metadata of this WorkPlanRotationResponse.
        Version metadata for this work plan rotation

        :return: The metadata of this WorkPlanRotationResponse.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this WorkPlanRotationResponse.
        Version metadata for this work plan rotation

        :param metadata: The metadata of this WorkPlanRotationResponse.
        :type: WfmVersionedEntityMetadata
        """
        
        self._metadata = metadata

    @property
    def self_uri(self):
        """
        Gets the self_uri of this WorkPlanRotationResponse.
        The URI for this object

        :return: The self_uri of this WorkPlanRotationResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this WorkPlanRotationResponse.
        The URI for this object

        :param self_uri: The self_uri of this WorkPlanRotationResponse.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

