# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ValidationServiceRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ValidationServiceRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'date_import_ended': 'datetime',
            'file_url': 'str',
            'upload_key': 'str'
        }

        self.attribute_map = {
            'date_import_ended': 'dateImportEnded',
            'file_url': 'fileUrl',
            'upload_key': 'uploadKey'
        }

        self._date_import_ended = None
        self._file_url = None
        self._upload_key = None

    @property
    def date_import_ended(self):
        """
        Gets the date_import_ended of this ValidationServiceRequest.
        The last day of the data you are importing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_import_ended of this ValidationServiceRequest.
        :rtype: datetime
        """
        return self._date_import_ended

    @date_import_ended.setter
    def date_import_ended(self, date_import_ended):
        """
        Sets the date_import_ended of this ValidationServiceRequest.
        The last day of the data you are importing. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_import_ended: The date_import_ended of this ValidationServiceRequest.
        :type: datetime
        """
        
        self._date_import_ended = date_import_ended

    @property
    def file_url(self):
        """
        Gets the file_url of this ValidationServiceRequest.
        File URL is deprecated, please use upload key

        :return: The file_url of this ValidationServiceRequest.
        :rtype: str
        """
        return self._file_url

    @file_url.setter
    def file_url(self, file_url):
        """
        Sets the file_url of this ValidationServiceRequest.
        File URL is deprecated, please use upload key

        :param file_url: The file_url of this ValidationServiceRequest.
        :type: str
        """
        
        self._file_url = file_url

    @property
    def upload_key(self):
        """
        Gets the upload_key of this ValidationServiceRequest.
        S3 key for the uploaded file

        :return: The upload_key of this ValidationServiceRequest.
        :rtype: str
        """
        return self._upload_key

    @upload_key.setter
    def upload_key(self, upload_key):
        """
        Sets the upload_key of this ValidationServiceRequest.
        S3 key for the uploaded file

        :param upload_key: The upload_key of this ValidationServiceRequest.
        :type: str
        """
        
        self._upload_key = upload_key

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

