# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ValidationLimits(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ValidationLimits - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'min_length': 'MinLength',
            'max_length': 'MaxLength',
            'min_items': 'MinLength',
            'max_items': 'MaxLength',
            'minimum': 'MinLength',
            'maximum': 'MaxLength'
        }

        self.attribute_map = {
            'min_length': 'minLength',
            'max_length': 'maxLength',
            'min_items': 'minItems',
            'max_items': 'maxItems',
            'minimum': 'minimum',
            'maximum': 'maximum'
        }

        self._min_length = None
        self._max_length = None
        self._min_items = None
        self._max_items = None
        self._minimum = None
        self._maximum = None

    @property
    def min_length(self):
        """
        Gets the min_length of this ValidationLimits.


        :return: The min_length of this ValidationLimits.
        :rtype: MinLength
        """
        return self._min_length

    @min_length.setter
    def min_length(self, min_length):
        """
        Sets the min_length of this ValidationLimits.


        :param min_length: The min_length of this ValidationLimits.
        :type: MinLength
        """
        
        self._min_length = min_length

    @property
    def max_length(self):
        """
        Gets the max_length of this ValidationLimits.


        :return: The max_length of this ValidationLimits.
        :rtype: MaxLength
        """
        return self._max_length

    @max_length.setter
    def max_length(self, max_length):
        """
        Sets the max_length of this ValidationLimits.


        :param max_length: The max_length of this ValidationLimits.
        :type: MaxLength
        """
        
        self._max_length = max_length

    @property
    def min_items(self):
        """
        Gets the min_items of this ValidationLimits.


        :return: The min_items of this ValidationLimits.
        :rtype: MinLength
        """
        return self._min_items

    @min_items.setter
    def min_items(self, min_items):
        """
        Sets the min_items of this ValidationLimits.


        :param min_items: The min_items of this ValidationLimits.
        :type: MinLength
        """
        
        self._min_items = min_items

    @property
    def max_items(self):
        """
        Gets the max_items of this ValidationLimits.


        :return: The max_items of this ValidationLimits.
        :rtype: MaxLength
        """
        return self._max_items

    @max_items.setter
    def max_items(self, max_items):
        """
        Sets the max_items of this ValidationLimits.


        :param max_items: The max_items of this ValidationLimits.
        :type: MaxLength
        """
        
        self._max_items = max_items

    @property
    def minimum(self):
        """
        Gets the minimum of this ValidationLimits.


        :return: The minimum of this ValidationLimits.
        :rtype: MinLength
        """
        return self._minimum

    @minimum.setter
    def minimum(self, minimum):
        """
        Sets the minimum of this ValidationLimits.


        :param minimum: The minimum of this ValidationLimits.
        :type: MinLength
        """
        
        self._minimum = minimum

    @property
    def maximum(self):
        """
        Gets the maximum of this ValidationLimits.


        :return: The maximum of this ValidationLimits.
        :rtype: MaxLength
        """
        return self._maximum

    @maximum.setter
    def maximum(self, maximum):
        """
        Sets the maximum of this ValidationLimits.


        :param maximum: The maximum of this ValidationLimits.
        :type: MaxLength
        """
        
        self._maximum = maximum

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

