# coding: utf-8

"""
    Auth - Application API

    Auth manages access for services that need accesses management for their clients. Auth also issues temporary credentials for the services' clients and validates them for the services  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_auth_api.models.ssh_certificate_type import SSHCertificateType  # noqa: F401,E501


class SSHCertificateIssueDetails(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allowed_domains': 'list[str]',
        'allowed_user_key_lengths': 'dict(str, int)',
        'allowed_users': 'list[str]',
        'cert_type': 'SSHCertificateType',
        'critical_options': 'dict(str, str)',
        'extensions': 'dict(str, str)',
        'max_ttl': 'int',
        'principals': 'list[str]',
        'static_key_id': 'str'
    }

    attribute_map = {
        'allowed_domains': 'allowed_domains',
        'allowed_user_key_lengths': 'allowed_user_key_lengths',
        'allowed_users': 'allowed_users',
        'cert_type': 'cert_type',
        'critical_options': 'critical_options',
        'extensions': 'extensions',
        'max_ttl': 'max_ttl',
        'principals': 'principals',
        'static_key_id': 'static_key_id'
    }

    def __init__(self, allowed_domains=None, allowed_user_key_lengths=None, allowed_users=None, cert_type=None, critical_options=None, extensions=None, max_ttl=None, principals=None, static_key_id=None):  # noqa: E501
        """SSHCertificateIssueDetails - a model defined in Swagger"""  # noqa: E501

        self._allowed_domains = None
        self._allowed_user_key_lengths = None
        self._allowed_users = None
        self._cert_type = None
        self._critical_options = None
        self._extensions = None
        self._max_ttl = None
        self._principals = None
        self._static_key_id = None
        self.discriminator = None

        if allowed_domains is not None:
            self.allowed_domains = allowed_domains
        if allowed_user_key_lengths is not None:
            self.allowed_user_key_lengths = allowed_user_key_lengths
        if allowed_users is not None:
            self.allowed_users = allowed_users
        if cert_type is not None:
            self.cert_type = cert_type
        if critical_options is not None:
            self.critical_options = critical_options
        if extensions is not None:
            self.extensions = extensions
        if max_ttl is not None:
            self.max_ttl = max_ttl
        if principals is not None:
            self.principals = principals
        if static_key_id is not None:
            self.static_key_id = static_key_id

    @property
    def allowed_domains(self):
        """Gets the allowed_domains of this SSHCertificateIssueDetails.  # noqa: E501

        Relevant for host certificate  # noqa: E501

        :return: The allowed_domains of this SSHCertificateIssueDetails.  # noqa: E501
        :rtype: list[str]
        """
        return self._allowed_domains

    @allowed_domains.setter
    def allowed_domains(self, allowed_domains):
        """Sets the allowed_domains of this SSHCertificateIssueDetails.

        Relevant for host certificate  # noqa: E501

        :param allowed_domains: The allowed_domains of this SSHCertificateIssueDetails.  # noqa: E501
        :type: list[str]
        """

        self._allowed_domains = allowed_domains

    @property
    def allowed_user_key_lengths(self):
        """Gets the allowed_user_key_lengths of this SSHCertificateIssueDetails.  # noqa: E501


        :return: The allowed_user_key_lengths of this SSHCertificateIssueDetails.  # noqa: E501
        :rtype: dict(str, int)
        """
        return self._allowed_user_key_lengths

    @allowed_user_key_lengths.setter
    def allowed_user_key_lengths(self, allowed_user_key_lengths):
        """Sets the allowed_user_key_lengths of this SSHCertificateIssueDetails.


        :param allowed_user_key_lengths: The allowed_user_key_lengths of this SSHCertificateIssueDetails.  # noqa: E501
        :type: dict(str, int)
        """

        self._allowed_user_key_lengths = allowed_user_key_lengths

    @property
    def allowed_users(self):
        """Gets the allowed_users of this SSHCertificateIssueDetails.  # noqa: E501

        Relevant for user certificate  # noqa: E501

        :return: The allowed_users of this SSHCertificateIssueDetails.  # noqa: E501
        :rtype: list[str]
        """
        return self._allowed_users

    @allowed_users.setter
    def allowed_users(self, allowed_users):
        """Sets the allowed_users of this SSHCertificateIssueDetails.

        Relevant for user certificate  # noqa: E501

        :param allowed_users: The allowed_users of this SSHCertificateIssueDetails.  # noqa: E501
        :type: list[str]
        """

        self._allowed_users = allowed_users

    @property
    def cert_type(self):
        """Gets the cert_type of this SSHCertificateIssueDetails.  # noqa: E501


        :return: The cert_type of this SSHCertificateIssueDetails.  # noqa: E501
        :rtype: SSHCertificateType
        """
        return self._cert_type

    @cert_type.setter
    def cert_type(self, cert_type):
        """Sets the cert_type of this SSHCertificateIssueDetails.


        :param cert_type: The cert_type of this SSHCertificateIssueDetails.  # noqa: E501
        :type: SSHCertificateType
        """

        self._cert_type = cert_type

    @property
    def critical_options(self):
        """Gets the critical_options of this SSHCertificateIssueDetails.  # noqa: E501


        :return: The critical_options of this SSHCertificateIssueDetails.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._critical_options

    @critical_options.setter
    def critical_options(self, critical_options):
        """Sets the critical_options of this SSHCertificateIssueDetails.


        :param critical_options: The critical_options of this SSHCertificateIssueDetails.  # noqa: E501
        :type: dict(str, str)
        """

        self._critical_options = critical_options

    @property
    def extensions(self):
        """Gets the extensions of this SSHCertificateIssueDetails.  # noqa: E501


        :return: The extensions of this SSHCertificateIssueDetails.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._extensions

    @extensions.setter
    def extensions(self, extensions):
        """Sets the extensions of this SSHCertificateIssueDetails.


        :param extensions: The extensions of this SSHCertificateIssueDetails.  # noqa: E501
        :type: dict(str, str)
        """

        self._extensions = extensions

    @property
    def max_ttl(self):
        """Gets the max_ttl of this SSHCertificateIssueDetails.  # noqa: E501


        :return: The max_ttl of this SSHCertificateIssueDetails.  # noqa: E501
        :rtype: int
        """
        return self._max_ttl

    @max_ttl.setter
    def max_ttl(self, max_ttl):
        """Sets the max_ttl of this SSHCertificateIssueDetails.


        :param max_ttl: The max_ttl of this SSHCertificateIssueDetails.  # noqa: E501
        :type: int
        """

        self._max_ttl = max_ttl

    @property
    def principals(self):
        """Gets the principals of this SSHCertificateIssueDetails.  # noqa: E501


        :return: The principals of this SSHCertificateIssueDetails.  # noqa: E501
        :rtype: list[str]
        """
        return self._principals

    @principals.setter
    def principals(self, principals):
        """Sets the principals of this SSHCertificateIssueDetails.


        :param principals: The principals of this SSHCertificateIssueDetails.  # noqa: E501
        :type: list[str]
        """

        self._principals = principals

    @property
    def static_key_id(self):
        """Gets the static_key_id of this SSHCertificateIssueDetails.  # noqa: E501

        In case it is empty, the key ID will be combination of user identifiers and a random string  # noqa: E501

        :return: The static_key_id of this SSHCertificateIssueDetails.  # noqa: E501
        :rtype: str
        """
        return self._static_key_id

    @static_key_id.setter
    def static_key_id(self, static_key_id):
        """Sets the static_key_id of this SSHCertificateIssueDetails.

        In case it is empty, the key ID will be combination of user identifiers and a random string  # noqa: E501

        :param static_key_id: The static_key_id of this SSHCertificateIssueDetails.  # noqa: E501
        :type: str
        """

        self._static_key_id = static_key_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SSHCertificateIssueDetails, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SSHCertificateIssueDetails):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
