# coding: utf-8

"""
    Auth - Application API

    Auth manages access for services that need accesses management for their clients. Auth also issues temporary credentials for the services' clients and validates them for the services  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_auth_api.models.saml_attribute import SamlAttribute  # noqa: F401,E501


class SamlAccessRules(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bound_attributes': 'list[SamlAttribute]',
        'idp_metadata_url': 'str'
    }

    attribute_map = {
        'bound_attributes': 'bound_attributes',
        'idp_metadata_url': 'idp_metadata_url'
    }

    def __init__(self, bound_attributes=None, idp_metadata_url=None):  # noqa: E501
        """SamlAccessRules - a model defined in Swagger"""  # noqa: E501

        self._bound_attributes = None
        self._idp_metadata_url = None
        self.discriminator = None

        if bound_attributes is not None:
            self.bound_attributes = bound_attributes
        if idp_metadata_url is not None:
            self.idp_metadata_url = idp_metadata_url

    @property
    def bound_attributes(self):
        """Gets the bound_attributes of this SamlAccessRules.  # noqa: E501

        The attributes that login is restricted to.  # noqa: E501

        :return: The bound_attributes of this SamlAccessRules.  # noqa: E501
        :rtype: list[SamlAttribute]
        """
        return self._bound_attributes

    @bound_attributes.setter
    def bound_attributes(self, bound_attributes):
        """Sets the bound_attributes of this SamlAccessRules.

        The attributes that login is restricted to.  # noqa: E501

        :param bound_attributes: The bound_attributes of this SamlAccessRules.  # noqa: E501
        :type: list[SamlAttribute]
        """

        self._bound_attributes = bound_attributes

    @property
    def idp_metadata_url(self):
        """Gets the idp_metadata_url of this SamlAccessRules.  # noqa: E501

        IDP metadata url  # noqa: E501

        :return: The idp_metadata_url of this SamlAccessRules.  # noqa: E501
        :rtype: str
        """
        return self._idp_metadata_url

    @idp_metadata_url.setter
    def idp_metadata_url(self, idp_metadata_url):
        """Sets the idp_metadata_url of this SamlAccessRules.

        IDP metadata url  # noqa: E501

        :param idp_metadata_url: The idp_metadata_url of this SamlAccessRules.  # noqa: E501
        :type: str
        """

        self._idp_metadata_url = idp_metadata_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SamlAccessRules, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SamlAccessRules):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
