# coding: utf-8

"""
    Auth - Application API

    Auth manages access for services that need accesses management for their clients. Auth also issues temporary credentials for the services' clients and validates them for the services  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_auth_api.models.access_rules import AccessRules  # noqa: F401,E501
from akeyless_auth_api.models.access_rules_type import AccessRulesType  # noqa: F401,E501


class AccessParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_rules_type': 'AccessRulesType',
        'account_id': 'str',
        'attaches': 'str',
        'comment': 'str',
        'expires': 'int',
        'rules': 'AccessRules'
    }

    attribute_map = {
        'access_rules_type': 'access_rules_type',
        'account_id': 'account_id',
        'attaches': 'attaches',
        'comment': 'comment',
        'expires': 'expires',
        'rules': 'rules'
    }

    def __init__(self, access_rules_type=None, account_id=None, attaches=None, comment=None, expires=None, rules=None):  # noqa: E501
        """AccessParams - a model defined in Swagger"""  # noqa: E501

        self._access_rules_type = None
        self._account_id = None
        self._attaches = None
        self._comment = None
        self._expires = None
        self._rules = None
        self.discriminator = None

        if access_rules_type is not None:
            self.access_rules_type = access_rules_type
        if account_id is not None:
            self.account_id = account_id
        if attaches is not None:
            self.attaches = attaches
        if comment is not None:
            self.comment = comment
        self.expires = expires
        if rules is not None:
            self.rules = rules

    @property
    def access_rules_type(self):
        """Gets the access_rules_type of this AccessParams.  # noqa: E501


        :return: The access_rules_type of this AccessParams.  # noqa: E501
        :rtype: AccessRulesType
        """
        return self._access_rules_type

    @access_rules_type.setter
    def access_rules_type(self, access_rules_type):
        """Sets the access_rules_type of this AccessParams.


        :param access_rules_type: The access_rules_type of this AccessParams.  # noqa: E501
        :type: AccessRulesType
        """

        self._access_rules_type = access_rules_type

    @property
    def account_id(self):
        """Gets the account_id of this AccessParams.  # noqa: E501

        Account id.  # noqa: E501

        :return: The account_id of this AccessParams.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this AccessParams.

        Account id.  # noqa: E501

        :param account_id: The account_id of this AccessParams.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def attaches(self):
        """Gets the attaches of this AccessParams.  # noqa: E501

        Generic field in a JSON format that contains additional information about the access authentication. This JSON will be attached to the temporary credentials that will be issued for this access authentication.  # noqa: E501

        :return: The attaches of this AccessParams.  # noqa: E501
        :rtype: str
        """
        return self._attaches

    @attaches.setter
    def attaches(self, attaches):
        """Sets the attaches of this AccessParams.

        Generic field in a JSON format that contains additional information about the access authentication. This JSON will be attached to the temporary credentials that will be issued for this access authentication.  # noqa: E501

        :param attaches: The attaches of this AccessParams.  # noqa: E501
        :type: str
        """

        self._attaches = attaches

    @property
    def comment(self):
        """Gets the comment of this AccessParams.  # noqa: E501

        Comments  # noqa: E501

        :return: The comment of this AccessParams.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this AccessParams.

        Comments  # noqa: E501

        :param comment: The comment of this AccessParams.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def expires(self):
        """Gets the expires of this AccessParams.  # noqa: E501

        Access expiration date (Unix timestamp).  # noqa: E501

        :return: The expires of this AccessParams.  # noqa: E501
        :rtype: int
        """
        return self._expires

    @expires.setter
    def expires(self, expires):
        """Sets the expires of this AccessParams.

        Access expiration date (Unix timestamp).  # noqa: E501

        :param expires: The expires of this AccessParams.  # noqa: E501
        :type: int
        """
        if expires is None:
            raise ValueError("Invalid value for `expires`, must not be `None`")  # noqa: E501

        self._expires = expires

    @property
    def rules(self):
        """Gets the rules of this AccessParams.  # noqa: E501


        :return: The rules of this AccessParams.  # noqa: E501
        :rtype: AccessRules
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """Sets the rules of this AccessParams.


        :param rules: The rules of this AccessParams.  # noqa: E501
        :type: AccessRules
        """

        self._rules = rules

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AccessParams, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccessParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
