# coding: utf-8

"""
    Auth - Application API

    Auth manages access for services that need accesses management for their clients. Auth also issues temporary credentials for the services' clients and validates them for the services  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from akeyless_auth_api.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def authenticate(self, access_id, **kwargs):  # noqa: E501
        """Return a temporary access credentials  # noqa: E501

        Client that meet an access params will be able to get temporary credentials to access the service that created the access for him. The client must provide the relevant parameters that proves his compliance with the access. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int timestamp: A Unix timestamp which was used for the signature (relevant only in case of api key access).
        :param str nonce: Random string which was used for the signature (relevant only in case of api key access authentication).
        :param str signature: A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication).
        :param str access_token: An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication).
        :param str client_ip: The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.authenticate_with_http_info(access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.authenticate_with_http_info(access_id, **kwargs)  # noqa: E501
            return data

    def authenticate_with_http_info(self, access_id, **kwargs):  # noqa: E501
        """Return a temporary access credentials  # noqa: E501

        Client that meet an access params will be able to get temporary credentials to access the service that created the access for him. The client must provide the relevant parameters that proves his compliance with the access. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate_with_http_info(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int timestamp: A Unix timestamp which was used for the signature (relevant only in case of api key access).
        :param str nonce: Random string which was used for the signature (relevant only in case of api key access authentication).
        :param str signature: A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication).
        :param str access_token: An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication).
        :param str client_ip: The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_id', 'akeyless_request_id', 'akeyless_client_id', 'timestamp', 'nonce', 'signature', 'access_token', 'client_ip', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authenticate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `authenticate`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_id' in params:
            query_params.append(('access_id', params['access_id']))  # noqa: E501
        if 'timestamp' in params:
            query_params.append(('timestamp', params['timestamp']))  # noqa: E501
        if 'nonce' in params:
            query_params.append(('nonce', params['nonce']))  # noqa: E501
        if 'signature' in params:
            query_params.append(('signature', params['signature']))  # noqa: E501
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'client_ip' in params:
            query_params.append(('client_ip', params['client_ip']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def authenticate_uam(self, access_id, **kwargs):  # noqa: E501
        """Return a combination of three temporary access credentials for accessing Auth, UAM and KFMs instances.  # noqa: E501

        UAM client that meet the access rules will be able to get a combination of three temporary access credentials signed by Auth for accessing Auth, UAM and KFMs instances. The client must provide the relevant parameters that proves his compliance with the access. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate_uam(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int timestamp: A Unix timestamp which was used for the signature (relevant only in case of api key access).
        :param str nonce: Random string which was used for the signature (relevant only in case of api key access authentication).
        :param str signature: A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication).
        :param str access_token: An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication).
        :param str client_ip: The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SystemAccessCredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.authenticate_uam_with_http_info(access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.authenticate_uam_with_http_info(access_id, **kwargs)  # noqa: E501
            return data

    def authenticate_uam_with_http_info(self, access_id, **kwargs):  # noqa: E501
        """Return a combination of three temporary access credentials for accessing Auth, UAM and KFMs instances.  # noqa: E501

        UAM client that meet the access rules will be able to get a combination of three temporary access credentials signed by Auth for accessing Auth, UAM and KFMs instances. The client must provide the relevant parameters that proves his compliance with the access. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.authenticate_uam_with_http_info(access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param int timestamp: A Unix timestamp which was used for the signature (relevant only in case of api key access).
        :param str nonce: Random string which was used for the signature (relevant only in case of api key access authentication).
        :param str signature: A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication).
        :param str access_token: An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication).
        :param str client_ip: The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SystemAccessCredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_id', 'akeyless_request_id', 'akeyless_client_id', 'timestamp', 'nonce', 'signature', 'access_token', 'client_ip', 'creds_expiry']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authenticate_uam" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `authenticate_uam`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate_uam`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate_uam`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_id' in params:
            query_params.append(('access_id', params['access_id']))  # noqa: E501
        if 'timestamp' in params:
            query_params.append(('timestamp', params['timestamp']))  # noqa: E501
        if 'nonce' in params:
            query_params.append(('nonce', params['nonce']))  # noqa: E501
        if 'signature' in params:
            query_params.append(('signature', params['signature']))  # noqa: E501
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501
        if 'client_ip' in params:
            query_params.append(('client_ip', params['client_ip']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-uam', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemAccessCredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_access(self, akeyless_credentials, body, **kwargs):  # noqa: E501
        """Creating a new access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access(akeyless_credentials, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param AccessParams body: Access rules and attaches. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CreateAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_access_with_http_info(akeyless_credentials, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_access_with_http_info(akeyless_credentials, body, **kwargs)  # noqa: E501
            return data

    def create_access_with_http_info(self, akeyless_credentials, body, **kwargs):  # noqa: E501
        """Creating a new access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_with_http_info(akeyless_credentials, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param AccessParams body: Access rules and attaches. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CreateAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'body', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `create_access`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/access', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateAccessReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_creds(self, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access to be used for accessing the account  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_creds(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAccountCredsParams body: Access rules to be used for accessing the new account. (required)
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_creds_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_creds_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_account_creds_with_http_info(self, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access to be used for accessing the account  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_creds_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateAccountCredsParams body: Access rules to be used for accessing the new account. (required)
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_account_creds`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-account-creds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access(self, akeyless_credentials, access_id, **kwargs):  # noqa: E501
        """Deleting an existing access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access(akeyless_credentials, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_access_with_http_info(akeyless_credentials, access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_access_with_http_info(akeyless_credentials, access_id, **kwargs)  # noqa: E501
            return data

    def delete_access_with_http_info(self, akeyless_credentials, access_id, **kwargs):  # noqa: E501
        """Deleting an existing access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_with_http_info(akeyless_credentials, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'access_id', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `delete_access`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `delete_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_id' in params:
            path_params['access_id'] = params['access_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/access/{access_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_access(self, akeyless_credentials, access_id, **kwargs):  # noqa: E501
        """Getting an existing access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access(akeyless_credentials, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_access_with_http_info(akeyless_credentials, access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_access_with_http_info(akeyless_credentials, access_id, **kwargs)  # noqa: E501
            return data

    def get_access_with_http_info(self, akeyless_credentials, access_id, **kwargs):  # noqa: E501
        """Getting an existing access.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_access_with_http_info(akeyless_credentials, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: GetAccessReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'access_id', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `get_access`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `get_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_id' in params:
            path_params['access_id'] = params['access_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/access/{access_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccessReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_accesses(self, akeyless_credentials, **kwargs):  # noqa: E501
        """Geting a list of accesses  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accesses(akeyless_credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param list[str] filter_keys: Keys array of fields in the access attaches.
        :param list[str] filter_values: Values array of fields in the access attaches.
        :param bool include_expired:
        :return: GetAccessesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_accesses_with_http_info(akeyless_credentials, **kwargs)  # noqa: E501
        else:
            (data) = self.get_accesses_with_http_info(akeyless_credentials, **kwargs)  # noqa: E501
            return data

    def get_accesses_with_http_info(self, akeyless_credentials, **kwargs):  # noqa: E501
        """Geting a list of accesses  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_accesses_with_http_info(akeyless_credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :param list[str] filter_keys: Keys array of fields in the access attaches.
        :param list[str] filter_values: Values array of fields in the access attaches.
        :param bool include_expired:
        :return: GetAccessesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'akeyless_request_id', 'akeyless_client_id', 'filter_keys', 'filter_values', 'include_expired']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_accesses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `get_accesses`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter_keys' in params:
            query_params.append(('filter_keys', params['filter_keys']))  # noqa: E501
            collection_formats['filter_keys'] = 'multi'  # noqa: E501
        if 'filter_values' in params:
            query_params.append(('filter_values', params['filter_values']))  # noqa: E501
            collection_formats['filter_values'] = 'multi'  # noqa: E501
        if 'include_expired' in params:
            query_params.append(('include_expired', params['include_expired']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/accesses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAccessesReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_auth_status(self, **kwargs):  # noqa: E501
        """get_auth_status  # noqa: E501

        Get Auth server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: AuthStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_auth_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_auth_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_auth_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_auth_status  # noqa: E501

        Get Auth server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_auth_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: AuthStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_auth_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthStatusReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_public_signing_key(self, signing_key_id, **kwargs):  # noqa: E501
        """Getting the public part of the key used by Auth to sign the temporary access credentials.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_signing_key(signing_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str signing_key_id: The ID of the key used by Auth to sign the temporary access credentials. (required)
        :return: PublicSigningKeyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_public_signing_key_with_http_info(signing_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_public_signing_key_with_http_info(signing_key_id, **kwargs)  # noqa: E501
            return data

    def get_public_signing_key_with_http_info(self, signing_key_id, **kwargs):  # noqa: E501
        """Getting the public part of the key used by Auth to sign the temporary access credentials.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_signing_key_with_http_info(signing_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str signing_key_id: The ID of the key used by Auth to sign the temporary access credentials. (required)
        :return: PublicSigningKeyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['signing_key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_signing_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'signing_key_id' is set
        if ('signing_key_id' not in params or
                params['signing_key_id'] is None):
            raise ValueError("Missing the required parameter `signing_key_id` when calling `get_public_signing_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'signing_key_id' in params:
            path_params['signing_key_id'] = params['signing_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/public-signing-key/{signing_key_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublicSigningKeyReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_time(self, **kwargs):  # noqa: E501
        """get_time  # noqa: E501

        Get Auth server time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_time(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: TimeReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_time_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_time_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_time_with_http_info(self, **kwargs):  # noqa: E501
        """get_time  # noqa: E501

        Get Auth server time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_time_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: TimeReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_time" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/time', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_access_key(self, **kwargs):  # noqa: E501
        """Getting a validation number to reset an admin account's access key.  # noqa: E501

        This endpoint is accessible to all clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_access_key(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_access_key_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.reset_access_key_with_http_info(**kwargs)  # noqa: E501
            return data

    def reset_access_key_with_http_info(self, **kwargs):  # noqa: E501
        """Getting a validation number to reset an admin account's access key.  # noqa: E501

        This endpoint is accessible to all clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_access_key_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_access_key" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/reset-access-key', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_access_key_0(self, **kwargs):  # noqa: E501
        """Getting temporary access credentials to reset an account's access key. The UAM service will use these credentials to update the account's api key auth method.  # noqa: E501

        This endpoint is accessible to all clients  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_access_key_0(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_access_key_0_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.reset_access_key_0_with_http_info(**kwargs)  # noqa: E501
            return data

    def reset_access_key_0_with_http_info(self, **kwargs):  # noqa: E501
        """Getting temporary access credentials to reset an account's access key. The UAM service will use these credentials to update the account's api key auth method.  # noqa: E501

        This endpoint is accessible to all clients  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_access_key_0_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_access_key_0" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/reset-access-key', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_uam_access_creds(self, akeyless_auth_creds, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to add a new access or to update an existing access in an UAM account. The UAM service will use this credentials to create/update an access to be used for accessing key fragments.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_uam_access_creds(akeyless_auth_creds, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_auth_creds: Temporary credentials for accessing the endpoint (required)
        :param SetUAMAccessCredsParams body: Access params. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_uam_access_creds_with_http_info(akeyless_auth_creds, body, **kwargs)  # noqa: E501
        else:
            (data) = self.set_uam_access_creds_with_http_info(akeyless_auth_creds, body, **kwargs)  # noqa: E501
            return data

    def set_uam_access_creds_with_http_info(self, akeyless_auth_creds, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to add a new access or to update an existing access in an UAM account. The UAM service will use this credentials to create/update an access to be used for accessing key fragments.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_uam_access_creds_with_http_info(akeyless_auth_creds, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_auth_creds: Temporary credentials for accessing the endpoint (required)
        :param SetUAMAccessCredsParams body: Access params. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_auth_creds', 'body', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_uam_access_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_auth_creds' is set
        if ('akeyless_auth_creds' not in params or
                params['akeyless_auth_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_auth_creds` when calling `set_uam_access_creds`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_uam_access_creds`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_auth_creds' in params:
            header_params['AkeylessAuthCreds'] = params['akeyless_auth_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/set-uam-access-creds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_access(self, akeyless_credentials, body, access_id, **kwargs):  # noqa: E501
        """Updating an existing access  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_access(akeyless_credentials, body, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param AccessParams body: Access rules and attaches. (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_access_with_http_info(akeyless_credentials, body, access_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_access_with_http_info(akeyless_credentials, body, access_id, **kwargs)  # noqa: E501
            return data

    def update_access_with_http_info(self, akeyless_credentials, body, access_id, **kwargs):  # noqa: E501
        """Updating an existing access  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their accesses for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_access_with_http_info(akeyless_credentials, body, access_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param AccessParams body: Access rules and attaches. (required)
        :param str access_id: Access id. (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'body', 'access_id', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_access" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `update_access`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_access`")  # noqa: E501
        # verify the required parameter 'access_id' is set
        if ('access_id' not in params or
                params['access_id'] is None):
            raise ValueError("Missing the required parameter `access_id` when calling `update_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_id' in params:
            path_params['access_id'] = params['access_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/access/{access_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_client_credentials(self, akeyless_credentials, client_credentials, **kwargs):  # noqa: E501
        """Validate client credentials  # noqa: E501

        Allows the services to validate the temporary access credentials that received from their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_client_credentials(akeyless_credentials, client_credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str client_credentials: Temporary credentials for validation (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: ValidateClientCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_client_credentials_with_http_info(akeyless_credentials, client_credentials, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_client_credentials_with_http_info(akeyless_credentials, client_credentials, **kwargs)  # noqa: E501
            return data

    def validate_client_credentials_with_http_info(self, akeyless_credentials, client_credentials, **kwargs):  # noqa: E501
        """Validate client credentials  # noqa: E501

        Allows the services to validate the temporary access credentials that received from their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.validate_client_credentials_with_http_info(akeyless_credentials, client_credentials, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str client_credentials: Temporary credentials for validation (required)
        :param str akeyless_request_id: Request Id for logging
        :param str akeyless_client_id: Client Id for logging
        :return: ValidateClientCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'client_credentials', 'akeyless_request_id', 'akeyless_client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_client_credentials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `validate_client_credentials`")  # noqa: E501
        # verify the required parameter 'client_credentials' is set
        if ('client_credentials' not in params or
                params['client_credentials'] is None):
            raise ValueError("Missing the required parameter `client_credentials` when calling `validate_client_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'client_credentials' in params:
            query_params.append(('client_credentials', params['client_credentials']))  # noqa: E501

        header_params = {}
        if 'akeyless_request_id' in params:
            header_params['AkeylessRequestId'] = params['akeyless_request_id']  # noqa: E501
        if 'akeyless_client_id' in params:
            header_params['AkeylessClientId'] = params['akeyless_client_id']  # noqa: E501
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/validate-client-credentials', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ValidateClientCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
