# akeyless-auth-api
Auth manages access for services that need accesses management for their clients. Auth also issues temporary credentials for the services' clients and validates them for the services

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.1.0
- Package version: 0.1.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.akeyless-security.com](https://www.akeyless-security.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import akeyless_auth_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import akeyless_auth_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import akeyless_auth_api
from akeyless_auth_api.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = akeyless_auth_api.DefaultApi(akeyless_auth_api.ApiClient(configuration))
access_id = 'access_id_example' # str | Access id.
akeyless_request_id = 'akeyless_request_id_example' # str | Request Id for logging (optional)
akeyless_client_id = 'akeyless_client_id_example' # str | Client Id for logging (optional)
timestamp = 789 # int | A Unix timestamp which was used for the signature (relevant only in case of api key access). (optional)
nonce = 'nonce_example' # str | Random string which was used for the signature (relevant only in case of api key access authentication). (optional)
signature = 'signature_example' # str | A digital signature generated with the private key that complies with the access authentication (relevant only in case of api key access authentication). (optional)
access_token = 'access_token_example' # str | An access token as a signed JSON Web Toke (relevant only in case of azure-az/oauth2 access authentication). (optional)
client_ip = 'client_ip_example' # str | The Client's IP for authentication. Relevant only in case of the services that mediate between Auth and their clients in obtaining temporary access credentials. (optional)
creds_expiry = 60 # int | The requested expiration time of the temporary credentials in minutes. (optional) (default to 60)

try:
    # Return a temporary access credentials
    api_response = api_instance.authenticate(access_id, akeyless_request_id=akeyless_request_id, akeyless_client_id=akeyless_client_id, timestamp=timestamp, nonce=nonce, signature=signature, access_token=access_token, client_ip=client_ip, creds_expiry=creds_expiry)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->authenticate: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://$HOST*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**authenticate**](docs/DefaultApi.md#authenticate) | **POST** /auth | Return a temporary access credentials
*DefaultApi* | [**authenticate_uam**](docs/DefaultApi.md#authenticate_uam) | **POST** /auth-uam | Return a combination of three temporary access credentials for accessing Auth, UAM and KFMs instances.
*DefaultApi* | [**create_access**](docs/DefaultApi.md#create_access) | **POST** /access | Creating a new access.
*DefaultApi* | [**create_account_creds**](docs/DefaultApi.md#create_account_creds) | **POST** /create-account-creds | Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access to be used for accessing the account
*DefaultApi* | [**delete_access**](docs/DefaultApi.md#delete_access) | **DELETE** /access/{access_id} | Deleting an existing access.
*DefaultApi* | [**get_access**](docs/DefaultApi.md#get_access) | **GET** /access/{access_id} | Getting an existing access.
*DefaultApi* | [**get_accesses**](docs/DefaultApi.md#get_accesses) | **GET** /accesses | Geting a list of accesses
*DefaultApi* | [**get_auth_status**](docs/DefaultApi.md#get_auth_status) | **GET** /auth-status | 
*DefaultApi* | [**get_public_signing_key**](docs/DefaultApi.md#get_public_signing_key) | **GET** /public-signing-key/{signing_key_id} | Getting the public part of the key used by Auth to sign the temporary access credentials.
*DefaultApi* | [**get_time**](docs/DefaultApi.md#get_time) | **GET** /time | 
*DefaultApi* | [**reset_access_key**](docs/DefaultApi.md#reset_access_key) | **GET** /reset-access-key | Getting a validation number to reset an admin account&#39;s access key.
*DefaultApi* | [**reset_access_key_0**](docs/DefaultApi.md#reset_access_key_0) | **PUT** /reset-access-key | Getting temporary access credentials to reset an account&#39;s access key. The UAM service will use these credentials to update the account&#39;s api key auth method.
*DefaultApi* | [**set_uam_access_creds**](docs/DefaultApi.md#set_uam_access_creds) | **POST** /set-uam-access-creds | Getting temporary access credentials to add a new access or to update an existing access in an UAM account. The UAM service will use this credentials to create/update an access to be used for accessing key fragments.
*DefaultApi* | [**update_access**](docs/DefaultApi.md#update_access) | **PUT** /access/{access_id} | Updating an existing access
*DefaultApi* | [**validate_client_credentials**](docs/DefaultApi.md#validate_client_credentials) | **POST** /validate-client-credentials | Validate client credentials


## Documentation For Models

 - [APIKeyAccessRules](docs/APIKeyAccessRules.md)
 - [AccessParams](docs/AccessParams.md)
 - [AccessRules](docs/AccessRules.md)
 - [AccessRulesType](docs/AccessRulesType.md)
 - [AccessType](docs/AccessType.md)
 - [AccountReplyObj](docs/AccountReplyObj.md)
 - [AccountStatus](docs/AccountStatus.md)
 - [Algorithm](docs/Algorithm.md)
 - [AuthMethodAccessInfo](docs/AuthMethodAccessInfo.md)
 - [AuthMethodRoleAssociation](docs/AuthMethodRoleAssociation.md)
 - [AuthStatusReplyObj](docs/AuthStatusReplyObj.md)
 - [AzureADAccessRules](docs/AzureADAccessRules.md)
 - [CreateAccessReplyObj](docs/CreateAccessReplyObj.md)
 - [CreateAccountCredsParams](docs/CreateAccountCredsParams.md)
 - [CreateAuthMethodReplyObj](docs/CreateAuthMethodReplyObj.md)
 - [CreateRoleAuthMethodAssocReplyObj](docs/CreateRoleAuthMethodAssocReplyObj.md)
 - [CredentialsReplyObj](docs/CredentialsReplyObj.md)
 - [DerivationCredsReplyObj](docs/DerivationCredsReplyObj.md)
 - [DerivedFragmentReplyObj](docs/DerivedFragmentReplyObj.md)
 - [DynamicSecretMQAccessReplyObj](docs/DynamicSecretMQAccessReplyObj.md)
 - [DynamicSecretMessageQueueInfo](docs/DynamicSecretMessageQueueInfo.md)
 - [DynamicSecretProducerCredsReplyObj](docs/DynamicSecretProducerCredsReplyObj.md)
 - [ErrorReplyObj](docs/ErrorReplyObj.md)
 - [FragmentType](docs/FragmentType.md)
 - [FragmentsDerivationsCreds](docs/FragmentsDerivationsCreds.md)
 - [GetAccessReplyObj](docs/GetAccessReplyObj.md)
 - [GetAccessesReplyObj](docs/GetAccessesReplyObj.md)
 - [GetAccountAuthMethodsReplyObj](docs/GetAccountAuthMethodsReplyObj.md)
 - [GetAccountDetailsReplyObj](docs/GetAccountDetailsReplyObj.md)
 - [GetAccountRolesReplyObj](docs/GetAccountRolesReplyObj.md)
 - [GetAuthMethodReplyObj](docs/GetAuthMethodReplyObj.md)
 - [GetFragmentDetailsReplyObj](docs/GetFragmentDetailsReplyObj.md)
 - [GetItemReplyObj](docs/GetItemReplyObj.md)
 - [GetRoleReplyObj](docs/GetRoleReplyObj.md)
 - [KFMStatusReplyObj](docs/KFMStatusReplyObj.md)
 - [LdapAccessRules](docs/LdapAccessRules.md)
 - [ListItemsInPathReplyObj](docs/ListItemsInPathReplyObj.md)
 - [ListItemsReplyObj](docs/ListItemsReplyObj.md)
 - [OAuth2AccessRules](docs/OAuth2AccessRules.md)
 - [OAuth2CustomClaim](docs/OAuth2CustomClaim.md)
 - [PathRule](docs/PathRule.md)
 - [PrepareDynamicSecretValueReplyObj](docs/PrepareDynamicSecretValueReplyObj.md)
 - [PublicSigningKeyReplyObj](docs/PublicSigningKeyReplyObj.md)
 - [PullDynamicSecretValueReplyObj](docs/PullDynamicSecretValueReplyObj.md)
 - [RSADecryptCreds](docs/RSADecryptCreds.md)
 - [RSADecryptCredsReplyObj](docs/RSADecryptCredsReplyObj.md)
 - [RSAFragmentDecryptReplyObj](docs/RSAFragmentDecryptReplyObj.md)
 - [RoleAuthMethodAssociation](docs/RoleAuthMethodAssociation.md)
 - [Rules](docs/Rules.md)
 - [SSHCertIssuerAccessCredsReplyObj](docs/SSHCertIssuerAccessCredsReplyObj.md)
 - [SSHCertificateIssueDetails](docs/SSHCertificateIssueDetails.md)
 - [SSHCertificateParams](docs/SSHCertificateParams.md)
 - [SSHCertificateType](docs/SSHCertificateType.md)
 - [SamlAccessRules](docs/SamlAccessRules.md)
 - [SamlAttribute](docs/SamlAttribute.md)
 - [SecretAccessCredsReplyObj](docs/SecretAccessCredsReplyObj.md)
 - [SetItemRequestBodyParams](docs/SetItemRequestBodyParams.md)
 - [SetRoleRequestParams](docs/SetRoleRequestParams.md)
 - [SetUAMAccessCredsParams](docs/SetUAMAccessCredsParams.md)
 - [SystemAccessCredentialsReplyObj](docs/SystemAccessCredentialsReplyObj.md)
 - [TimeReplyObj](docs/TimeReplyObj.md)
 - [UAMStatusReplyObj](docs/UAMStatusReplyObj.md)
 - [UpdateAccessMode](docs/UpdateAccessMode.md)
 - [UploadRSAFragmentReplyObj](docs/UploadRSAFragmentReplyObj.md)
 - [UploadRSAKeyCredsReplyObj](docs/UploadRSAKeyCredsReplyObj.md)
 - [ValidateClientCredsReplyObj](docs/ValidateClientCredsReplyObj.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

refael@akeyless-security.com

