from __future__ import annotations

from tcsoa.gen.BusinessObjects import BusinessObject, ReportDefinition
from typing import List
from tcsoa.gen.Server import ServiceData
from tcsoa.base import TcBaseObj
from dataclasses import dataclass


@dataclass
class GenerateReportCriteria(TcBaseObj):
    """
    Data needed to generate a report.
    
    :var rdTag: The report definition.
    :var stylesheetTag: The style sheet Dataset . If supplied the style sheet will be applied to the final generated
    report. If this value is left null, a plain XML file will be generated for the report.
    :var contextObjects: A list of context business objects for a Item Report.
    :var datasetName: The name of the containing Dataset. If dataset name is provided, the generated report will be
    saved as a Dataset to Teamcenter with this given name.
    :var criteriaNames: A list of criteria names  in a series of Name/Value pairs used to specify additional criteria
    (optional).
    :var criteriaValues: A list of criteria values in a series of Name/Value pairs used to specify additional criteria
    (optional).
    """
    rdTag: BusinessObject = None
    stylesheetTag: BusinessObject = None
    contextObjects: List[BusinessObject] = ()
    datasetName: str = ''
    criteriaNames: List[str] = ()
    criteriaValues: List[str] = ()


@dataclass
class GenerateReportDefintionIdsResponse(TcBaseObj):
    """
    Response from generateReportDefintionIds.
    
    :var reportdefinitionIds: A list of report definition identifiers.
    :var serviceData: The ServiceData which includes the failure information.
    """
    reportdefinitionIds: List[ReportDefinitionIdObject] = ()
    serviceData: ServiceData = None


@dataclass
class GenerateReportResponse(TcBaseObj):
    """
    Response from generateReport.
    
    :var transientFileReadTickets: This is for future use, may be null.
    :var transientFileTicketInfos: A list of TransientFileTicketInfo  objects for retrieving generated report file. A
    TransientFileTicketInfo object contains the file name, the transient ticket information for the generated report
    file.
    :var serviceData: The ServiceData which includes the failure information.
    """
    transientFileReadTickets: List[str] = ()
    transientFileTicketInfos: List[TransientFileTicketInfo] = ()
    serviceData: ServiceData = None


@dataclass
class GetReportDefinitionsResponse(TcBaseObj):
    """
    Response from getReportDefinitions.
    
    :var reportdefinitions: a vector of ReportDefinitionObjects.
    :var serviceData: A serviceData contains the data.
    """
    reportdefinitions: List[ReportDefinitionObject] = ()
    serviceData: ServiceData = None


@dataclass
class ReportDefinitionIdObject(TcBaseObj):
    """
    A structure associating a report definition id
    with the requesting client.
    
    :var clientId: clientId
    :var reportDefinitionId: reportDefinitionId
    """
    clientId: str = ''
    reportDefinitionId: str = ''


@dataclass
class ReportDefinitionObject(TcBaseObj):
    """
    A structure associating a report definition with the requesting client.
    
    :var clientId: client identifier for routing purposes
    :var reportdefinition: report definition Tag
    """
    clientId: str = ''
    reportdefinition: ReportDefinition = None


@dataclass
class ReportProperties(TcBaseObj):
    """
    Properties needed to create a report definition.
    
    :var rdId: a unique identifier for this definition, may
    be autogenerated or user-specified (required)
    :var rdName: the report name (optional)
    :var rdStylesheets: a vector of stylesheet Tags (optional)
    :var rdEntries: a vector of strings containing the Entries in a series of
    Entry/Value pairs used to specify additional metadata (optional)
    :var rdValues: a vector of strings containing the Values in a series of
    Entry/Value pairs used to specify additional metadata (optional)
    :var rdDescription: the report description (optional)
    :var rdType: integer report type identifier, e.g. item, summary or custom (required)
    :var rdClass: class of designated report type (required for item reports)
    :var rdFolderName: name of the containing folder for this report definition (optional)
    :var rdSource: solution source of this definition, e.g. Teamcenter, TcRA (optional)
    :var rdState: integer for future use, may be any value
    :var rdQuerySource: the source of the report data (required)
    :var rdPropertySource: properties to include in the report (optional)
    """
    rdId: str = ''
    rdName: str = ''
    rdStylesheets: List[BusinessObject] = ()
    rdEntries: List[str] = ()
    rdValues: List[str] = ()
    rdDescription: str = ''
    rdType: int = 0
    rdClass: str = ''
    rdFolderName: str = ''
    rdSource: str = ''
    rdState: int = 0
    rdQuerySource: str = ''
    rdPropertySource: str = ''


@dataclass
class ReportsCriteria(TcBaseObj):
    """
    Criteria needed to retrieve report definitions
    or generate report definition ids. At least one
    of the optional parameters must be included.
    
    :var clientId: Client identifier for routing purposes (required).
    :var category: Designates report category, e.g. item, summary or custom (optional).
    :var source: Solution source of report definition, e.g. Teamcenter, TcRA (optional).
    :var status: It is for future use, may be null.
    :var contextObjects: A vector of gags representing context object(s) (required for item reports).
    """
    clientId: str = ''
    category: str = ''
    source: str = ''
    status: str = ''
    contextObjects: List[BusinessObject] = ()


@dataclass
class TransientFileInfo(TcBaseObj):
    """
    The information required for file upload.
    
    :var fileName: Absolute file path and name to transient volume
    :var isText: True if filetype is text
    """
    fileName: str = ''
    isText: bool = False


@dataclass
class TransientFileTicketInfo(TcBaseObj):
    """
    TransientFileInfo with a ticket.
    
    :var transientFileInfo: Information on the file to be downloaded.
    :var ticket: FMS file ticket
    """
    transientFileInfo: TransientFileInfo = None
    ticket: str = ''


@dataclass
class CreateReportDefinitionResponse(TcBaseObj):
    """
    Response from createReportDefinition.
    
    :var reportdefinition: report definition Tag
    :var serviceData: ServiceData
    """
    reportdefinition: BusinessObject = None
    serviceData: ServiceData = None
