from __future__ import annotations

from tcsoa.gen.BusinessObjects import BusinessObject, PSBOMViewRevision, ImanRelation, Dataset, GeneralDesignElement, GeneralDesignElementLink, PSConnection, Participant, Item, PSConnectionRevision, Form, ItemRevision
from enum import Enum
from tcsoa.gen.Core._2006_03.DataManagement import ExtendedAttributes
from typing import Dict, List
from tcsoa.gen.Server import ServiceData
from tcsoa.base import TcBaseObj
from dataclasses import dataclass
from datetime import datetime


@dataclass
class GDELinkInfo(TcBaseObj):
    """
    GDE Link Information
    
    :var clientID: A unique string identifier supplied by the caller for each GDELinkInfo. This ID is used to identify
    returned GDELink objects and Partial Errors associated with the input properties.
    :var name: Name of the GDELink to be created.
    :var description: The description text for the GDELink to be created.
    :var type: Type of the GDELink that needs to be created. The default type is GeneralDesignElementInfoLink.
    :var gdeLink: Existing GDELink to update (will be null in case of creation)
    :var attributes: Any additional attribute values to be set on the created GDELink.
    """
    clientID: str = ''
    name: str = ''
    description: str = ''
    type: str = ''
    gdeLink: GeneralDesignElementLink = None
    attributes: List[NameValueStruct] = ()


@dataclass
class GetItemAndRelatedObjectsInfo(TcBaseObj):
    """
    Input structure for 'GetItemAndRelatedObjects'. Must have a 'clientId', must contain an 'itemInfo' that is valid,
    may contain a list of information about revisions to return. If any bvr names are given then the tags for the BVRs
    will be returned.
    
    :var clientId: Client Identifier generated by client to identify output
    :var itemInfo: Item specifications, the itemInfo input is valid when one of the following is true:
     - has the uid field set to the UID of an existing Item,
     - has the ids filed set to key attribute values which identify a single existing Item,
     - it may be blank if the RevInfo uid field is set to the UID of an existing ItemRevision.
    :var revInfo: Revision specifications
    :var datasetInfo: Filter used to select datasets to return.
    :var bvrTypeNames: A list of a BVRs to return. optional.
    """
    clientId: str = ''
    itemInfo: ItemInfo = None
    revInfo: RevInfo = None
    datasetInfo: DatasetInfo = None
    bvrTypeNames: List[str] = ()


@dataclass
class GetItemAndRelatedObjectsItemOutput(TcBaseObj):
    """
    This structure contains item information.
    
    :var clientId: Identifier of input data used to generate output.
    :var item: Item object.
    :var itemRevOutput: List of 'RevisionOutputs'. When multiple are returned, the order will be oldest first to latest
    last.
    """
    clientId: str = ''
    item: Item = None
    itemRevOutput: List[RevisionOutput] = ()


@dataclass
class GetItemAndRelatedObjectsResponse(TcBaseObj):
    """
    Return structure for 'GetItemAndRelatedObjects' operation
    
    :var output: List of 'GetItemAndRelatedObjectsItemOutput'
    :var serviceData: Standard ServiceData member
    """
    output: List[GetItemAndRelatedObjectsItemOutput] = ()
    serviceData: ServiceData = None


@dataclass
class GetNRPatternsWithCountersResponse(TcBaseObj):
    """
    Response structure for getNRPatternsWithCounters service operation.
    
    :var patterns: List of structs which contain Patterns which has counters.
    :var preferredPattern: List of preferred patterns.
    :var condition: List of conditions.
    :var serviceData: Standard ServiceData structure. It contains partial errors and failures along with the clientIds.
    """
    patterns: List[PatternsWithCounters] = ()
    preferredPattern: List[str] = ()
    condition: List[str] = ()
    serviceData: ServiceData = None


@dataclass
class GetNextIdsResponse(TcBaseObj):
    """
    Response structure for 'getNextIds' service operation.
    
    :var nextIds: List containing next Id strings generated as per the pattern.
    :var serviceData: Standard 'ServiceData' structure. It contains partial errors and failures along with the
    clientIds.
    """
    nextIds: List[str] = ()
    serviceData: ServiceData = None


@dataclass
class GetRevNRAttachResponse(TcBaseObj):
    """
    Response structure for getRevNRAttachDetails service operation.
    
    :var initRevDetails: List containing information about Initial Revision Type.
    :var secRevDetails: List containing information about Secondary Revision Type.
    :var supplRevDetails: List containing information about Supplemental Revision Type.
    :var excludedLetters: List of exluded letters.
    :var serviceData: Standard ServiceData structure. It contains partial errors and failures along with the clientIds.
    """
    initRevDetails: List[RevOptionDetails] = ()
    secRevDetails: List[RevOptionDetails] = ()
    supplRevDetails: List[RevOptionDetails] = ()
    excludedLetters: List[str] = ()
    serviceData: ServiceData = None


@dataclass
class InfoForNextId(TcBaseObj):
    """
    Input structure for 'getNextIds' operation. It contains information about the object type, property name and
    pattern to be used for id generation.
    
    :var typeName: Type Name
    :var propName: Property Name
    :var pattern: Pattern String
    """
    typeName: str = ''
    propName: str = ''
    pattern: str = ''


@dataclass
class ItemElementProperties(TcBaseObj):
    """
    Input structure for createOrUpdateItemElements operation
    
    :var clientId: Identifier that helps the client to track the object(s) created should be unique for the input set
    :var name: Name of the ItemElement to be created
    :var type: Type of the ItemElement to be created. If it is not passed, operation takes default type.
    :var description: Description of the ItemElement to be created
    :var itemElemAttributes: Map<String,String> containing the attributes to be modified and its values. Required in
    case of updating an existing GDE.
    :var itemElement: ItemElement to be updated.
    """
    clientId: str = ''
    name: str = ''
    type: str = ''
    description: str = ''
    itemElemAttributes: AttributeMap = None
    itemElement: BusinessObject = None


@dataclass
class ItemElementsOutput(TcBaseObj):
    """
    This structure contains information for 'createOrUpdateItemElements' operation.
    
    :var clientId: Identifier that helps the client to track the object(s) created.
    :var itemElem: ItemElement object that was created
    """
    clientId: str = ''
    itemElem: GeneralDesignElement = None


@dataclass
class ItemInfo(TcBaseObj):
    """
    This structure contains either an item id or uid. Has a flag that indicates if the id is to be used first. If set
    then the id will be used. If the id does not resolve to an item then the uid will be used. If the flag is not set
    then the uid will be used first. If the uid does not resolve to an item then the id will be used. If no matching
    item is found then a null entry is placed in the output list and an error is returned.
    
    :var clientId: Client Identifier generated by client to identify output
    :var useIdFirst: A flag to indicate if the id is to be used before the uid.
    :var uid: Item uid string for Item to retrieve.
    :var ids: List of attributes and values for selecting the item. For pre TC8.1 versions only one entry is supported.
    This entry has the name 'item'_id.
    """
    clientId: str = ''
    useIdFirst: bool = False
    uid: str = ''
    ids: List[AttrInfo] = ()


@dataclass
class AttrInfo(TcBaseObj):
    """
    This structure contains information for specifying name value pairs.
    
    :var name: The name of the attribute.
    :var value: The value of the attribute.
    """
    name: str = ''
    value: str = ''


@dataclass
class MasterFormPropertiesInfo(TcBaseObj):
    """
    The data structure holds information for specifying property values to be set on a Form.
    
    :var form: Reference to Form object
    :var propertyValueInfo: A list of propertie names and values
    """
    form: Form = None
    propertyValueInfo: List[PropertyNameValueInfo] = ()


@dataclass
class NRAttachInfo(TcBaseObj):
    """
    NRAttachInfo structure contains information about the object type and property name for which Naming Rule
    information needs to be obtained.
    
    :var typeName: Type Name
    :var propName: Property Name
    """
    typeName: str = ''
    propName: str = ''


@dataclass
class NROutput(TcBaseObj):
    """
    This structure contains named reference information.
    
    :var namedReference: Object referenced
    :var namedReferenceName: Named Reference name
    :var ticket: Read ticket if referenced file and if requested.
    """
    namedReference: BusinessObject = None
    namedReferenceName: str = ''
    ticket: str = ''


@dataclass
class NameValueStruct(TcBaseObj):
    """
    This structure contains property name and value pairs for each property.
    
    :var name: Title of the attribute like time, act_location that needs to be set
    :var values: Values of the attribute to be set
    """
    name: str = ''
    values: List[str] = ()


@dataclass
class NamedReferenceFilter(TcBaseObj):
    """
    This structure contains information for determining which datasets to consider to return. This specifies a list of
    named references and the UID referenced by the named reference.
    
    :var namedReference: The name of the named reference.
    :var uidReferenced: The unique identifier referenced.
    """
    namedReference: str = ''
    uidReferenced: str = ''


@dataclass
class NamedReferenceList(TcBaseObj):
    """
    This structure contains information determining which named reference information to return. This specifies a named
    reference to return and a flag to specify, if the named reference is to a file, to return an FMS read ticket.
    
    :var namedReference: Named Reference to return.
    :var ticket: If this Named Reference is to a file, include an FMS read ticket if set.
    """
    namedReference: str = ''
    ticket: bool = False


@dataclass
class ParticipantInfo(TcBaseObj):
    """
    This structure contains information about new participant to be created or to find an existing one.
    
    :var assignee: The participant which can be a User, GroupMember or a ResourcePool
    :var participantType: Participant type to be assigned or added.  List of Participant types provided are:
    - ProposedResponsibleParty
    - ProposedReviewer
    - ChangeImplementationBoard
    - ChangeReviewBoard
    - ChangeSpecialist1
    - ChangeSpecialist2
    - ChangeSpecialist3
    - Analyst
    - Requestor
    
    
    
    Custom participant types are also allowed.
    :var clientId: A unique string supplied by the caller
    """
    assignee: BusinessObject = None
    participantType: str = ''
    clientId: str = ''


@dataclass
class Participants(TcBaseObj):
    """
    'Participants' structure contains the participants to be added / removed and object to which participants are to be
    added or removed.
    
    :var itemRev: Item Revision to which the Participant objects are added/removed.
    :var participant: List of Participant objects to be added/removed.
    """
    itemRev: ItemRevision = None
    participant: List[Participant] = ()


@dataclass
class PatternsWithCounters(TcBaseObj):
    """
    This structure holds patterns with counters.
    
    :var patternStrings: A list of pattern strings with counters
    """
    patternStrings: List[str] = ()


@dataclass
class PropertyNameValueInfo(TcBaseObj):
    """
    This structure contains information for specifying property name value pairs.
    
    :var propertyName: Name of the property
    :var propertyValues: A list of value(s) of the property
    """
    propertyName: str = ''
    propertyValues: List[str] = ()


@dataclass
class BOHierarchy(TcBaseObj):
    """
    This structure contains information for a bottom up hierarchy starting with a Business Object name and going up the
    hierarchy of parents up to the primary Business Object.
    
    :var BOName: Business Object Name
    :var BOParents: Ordered list of Business Object parents from bottom up
    """
    BOName: str = ''
    BOParents: List[str] = ()


@dataclass
class RelatedObjectInfo(TcBaseObj):
    """
    The data structure for specifying related object information.
    
    :var relatedObject: Object related to the new Item or IitemRevision.
    :var action: An integer representing the action that specifies the why the relatedObject as the other side object
    while applying the deep copy rules. Valid values are : CopyAsObjectType = 0, (A new copy of the object represented
    by otherSideObjectTag will be created and while propagatring the relations) CopyAsRefType = 1, (The same object
    represented by otherSideObjectTag will be used to propagate the relations) DontCopyType =2, (The relation will not
    be propagated.) RelateToLatest = 3, (If the other side object is an ItemRevision, then the latest version of the
    revision will be used while propagating the relation) ReviseAndRelateToLatest = 4 (If the other side object is an
    Item Revision, it will be revised and the newly created revision will be used while propagating the relations)
    :var isSecondary: Flag indicating whether the 'relatedObject' is participating as a secondary object in the
    relation.
    """
    relatedObject: BusinessObject = None
    action: int = 0
    isSecondary: bool = False


@dataclass
class BOWithExclusionIn(TcBaseObj):
    """
    Structure to hold the information about Business Object name and its exclusion list.
    
    :var boTypeName: Primary Business Object name for which hierarchies of displayable Business Objects are returned.
    :var exclusionBOTypeNames: List of Business Object names to be excluded from the returned list.
    """
    boTypeName: str = ''
    exclusionBOTypeNames: List[str] = ()


@dataclass
class BVROutput(TcBaseObj):
    """
    This structure contains bom view revision information.
    
    :var bvr: The BVR associated with the ItemRevision if requested.
    :var viewTypeName: The bvr view type.
    """
    bvr: PSBOMViewRevision = None
    viewTypeName: str = ''


@dataclass
class RevInfo(TcBaseObj):
    """
    This structure contains information to determine the revisions to return.
    
    :var clientId: Client Identifier generated by client to identify output.
    :var processing: Specifies what data to use to determine the revisions to return.
    The legal values are: 
    - All - All the revisions of the input Item are returned
    - None - No revisions are returned.
    - Nrev - Number of revisions based on the 'RevInfo::nRevs' input.
    - Min - The latest revision.
    - Rule - The revision as configured by the 'RevInfo::revisionRule' input.
    - Ids - The revision based on the 'RevInfo::Id' input.
    
    
    :var useIdFirst: A flag to indicate if the id is to be used before the uid.
    :var uid: Revision uid for revision to retrieve.
    :var id: Revision id for revision to retrieve.
    :var nRevs: The number of revisions to retrieve, or the number of existing revisions, whichever is smaller. The
    revisions returned will be the latest ones. The first one returned is the oldest of the group. The last the latest.
    :var revisionRule: The revision rule to be used.
    """
    clientId: str = ''
    processing: Processing = None
    useIdFirst: bool = False
    uid: str = ''
    id: str = ''
    nRevs: int = 0
    revisionRule: str = ''


@dataclass
class RevOptionDetails(TcBaseObj):
    """
    This structure contain revision option details.
    
    :var revOption: The next available revision option
    :var revFormat: Format specified for revision type.
    """
    revOption: str = ''
    revFormat: int = 0


@dataclass
class ReviseInfo(TcBaseObj):
    """
    The data structure contains the information required to create the new revision.  If 'DeepCopyInfo' is supplied it
    overrides the existing relations on the existing ItemRevision.
    
    :var clientId: Identifier to uniquely identify the input
    :var baseItemRevision: Original ItemRevision object to be used for the revise operation
    :var newRevId: ItemRevision id string for creating new ItemRevision object
    :var name: Name string for creating new Item/ItemRevision
    :var description: Description string for creating new Item/ItemRevision
    :var deepCopyInfo: List of 'DeepCopyData' objects to be used for propagating the relations of the ItemRevision. If
    this list is supplied, then only the relations listed in this list will be carried forward to the new ItemRevision.
    No other Deep Copy Rules defined in the system will get applied. Thus the 'DeepCopyData' in this list overrides
    everything defined in the system to carry forward the relations of the ItemRevision.
    :var newItemRevisionMasterProperties: The information for the new ItemRevisionMaster Form property values
    """
    clientId: str = ''
    baseItemRevision: ItemRevision = None
    newRevId: str = ''
    name: str = ''
    description: str = ''
    deepCopyInfo: List[DeepCopyData] = ()
    newItemRevisionMasterProperties: MasterFormPropertiesInfo = None


@dataclass
class ReviseOutput(TcBaseObj):
    """
    This structure contains newly created ItemRevision object and related objects.
    
    :var newItemRev: Newly created ItemRevision object.
    :var relatedObjects: A list of 'RelatedObjectInfo' which represents the new objects created or the existing the
    objects used to propagate the relations during the deep copy.
    """
    newItemRev: ItemRevision = None
    relatedObjects: List[RelatedObjectInfo] = ()


@dataclass
class ReviseResponse2(TcBaseObj):
    """
    Return structure for revise operation.
    
    :var reviseOutputMap: Map whose keys are the input clientIds and output values pairs ('string', 'ReviseOutput').
    :var serviceData: This contains the status of the operation.
    """
    reviseOutputMap: ReviseOutputMap = None
    serviceData: ServiceData = None


@dataclass
class RevisionOutput(TcBaseObj):
    """
    Output structure containing revision information
    
    :var clientId: Identifier of input data used to generate output.
    :var itemRevision: ItemRevision object.
    :var bvrs: The BVRs associated with the item revision if requested.
    :var datasetOutput: List of 'DatasetOutput'.
    """
    clientId: str = ''
    itemRevision: ItemRevision = None
    bvrs: List[BVROutput] = ()
    datasetOutput: List[DatasetOutput] = ()


@dataclass
class SaveAsNewItemInfo(TcBaseObj):
    """
    This data structure contain existing and new object info for save as new Item operation.
    
    :var clientId: Identifier to uniquely identify the input
    :var baseItemRevision: Original ItemRevision to be used for the 'ItemRevisionSaveAs' operation
    :var newItemId: Item id string for creating new Item
    :var newRevId: ItemRevision id string for creating new ItemRevision
    :var name: Name string for creating new Item/ItemRevision.
    :var description: Description string for creating new Item/ItemRevision
    :var deepCopyInfo: List of deep copy data to be used for propagating the relations of the ItemRevision. If this
    list is supplied, then only the relations listed in this list will be carried forward to the new ItemRevision. No
    other Deep Copy Rules defined in the system will get applied. Thus the 'DeepCopyData' in this list overrides
    everything defined in the system to carry forward the relations of the ItemRevision.
    :var newItemMasterProperties: The properties to be set for the newly created master form of the new Item
    :var newItemRevisionMasterProperties: The properties to be set for the newly created master form of the new
    ItemRevision
    """
    clientId: str = ''
    baseItemRevision: ItemRevision = None
    newItemId: str = ''
    newRevId: str = ''
    name: str = ''
    description: str = ''
    deepCopyInfo: List[DeepCopyData] = ()
    newItemMasterProperties: MasterFormPropertiesInfo = None
    newItemRevisionMasterProperties: MasterFormPropertiesInfo = None


@dataclass
class SaveAsNewItemOutput2(TcBaseObj):
    """
    The data strucutre contains newly created object inforamtiobn.
    
    :var newItem: Newly created Item object
    :var newItemRev: Newly created ItemRevision object
    :var relatedObjects: List of newly created related objects
    """
    newItem: Item = None
    newItemRev: ItemRevision = None
    relatedObjects: List[RelatedObjectInfo] = ()


@dataclass
class SaveAsNewItemResponse2(TcBaseObj):
    """
    The data structure contains return information for the operation.
    
    :var saveAsOutputMap: Map whose keys are the input clientIds and output values pairs('string',
    'SaveAsNewItemOutput2')
    :var serviceData: Service data
    """
    saveAsOutputMap: SaveAsNewItemOutputMap = None
    serviceData: ServiceData = None


@dataclass
class SecondaryData(TcBaseObj):
    """
    This structure contains information for secondary object data.
    
    :var clientId: identifier defined by user to track the related object.
    :var secondary: the secondary object pointed to by the relation
    :var userData: Object associated with the relation to the above secondary object
    :var properties: Additional attributes to be set on the relation. These are meant for any derived classes of
    TCRelation with additional attributes.
    """
    clientId: str = ''
    secondary: BusinessObject = None
    userData: BusinessObject = None
    properties: List[NameValueStruct] = ()


@dataclass
class TypeAndItemRevInfo(TcBaseObj):
    """
    'TypeAndItemRevInfo' structure contains information about the object type and revision for which Revision Naming
    Rule information needs to be obtained.
    
    :var typeName: Type name of Item or ItemRevision.
    :var itemRev: ItemRevision object selected.
    """
    typeName: str = ''
    itemRev: ItemRevision = None


@dataclass
class ConnectionOutput(TcBaseObj):
    """
    This structure contains information for 'createConnections' operation.
    
    :var clientId: Identifying string from the source ConnectionProperties.
    :var connection: The newly created Connection object
    :var connectionRev: The initial revision for the newly created ConnectionRevision
    """
    clientId: str = ''
    connection: PSConnection = None
    connectionRev: PSConnectionRevision = None


@dataclass
class ConnectionProperties(TcBaseObj):
    """
    Input structure for createConnections operation.  Specifies attributes for the new Connection or ConnectionRevision.
    
    :var clientId: A unique string supplied by the caller for each ConnectionProperties. This ID is used to identify
    returned ConnectionOutput elements and Partial Errors associated with the input ConnectionProperties, optional
    :var connId: The ID of the Connection to be created, optional
    :var name: The name of the Connection to be created, optional
    :var type: The type of the Connection to be created. The default type is Connection
    :var revId: The ID of the initial revision of the Connection to be created, optional
    :var description: The description text for the Connection to be created, optional
    :var extendedAttributes: Any additional attribute values to be set on the created Connection, ConnectionRevision or
    coresponding Master Forms, optional
    """
    clientId: str = ''
    connId: str = ''
    name: str = ''
    type: str = ''
    revId: str = ''
    description: str = ''
    extendedAttributes: List[ExtendedAttributes] = ()


@dataclass
class CreateConnectionsResponse(TcBaseObj):
    """
    Return structure for createConnections operation
    
    :var serviceData: Standard ServiceData member
    :var output: A list of created Connection objects and associate ConnectionRevision in the form of ConnectionsOutput
    structure.
    """
    serviceData: ServiceData = None
    output: List[ConnectionOutput] = ()


@dataclass
class CreateIn(TcBaseObj):
    """
    The data structure contains data for 'creation' operation.
    
    :var clientId: Unique client identifier. If there is an error in create, the client id in the ServiceData
    PartialError list can be used to associate to the clientId in the input to detect which object creation failed.
    :var data: Input data for create operation. This is essentially a map of property name-value pairs representing the
    input data for creation. It also is recursive referencing secondary input data (e.g For Item creation, the primary
    input data is for Item and secondary input data is for Item Master and ItemRevision).
    """
    clientId: str = ''
    data: CreateInput = None


@dataclass
class CreateInput(TcBaseObj):
    """
    This structure captures the inputs required for creation of a business object. This is a recursive structure
    containing the 'CreateInput'(s) for any secondary(compounded) objects that might be created (e.g Item also creates
    ItemRevision and ItemMaster Form, etc.)
    
    :var boName: Business object type name
    :var stringProps: Map of string property names to values ('string, string')
    :var boolArrayProps: Initial values of properties of type bool array. A map of property names to values
    (string/list of bools).
    :var dateProps: Map of DateTime property names to values ('string, 'date)
    :var dateArrayProps: Initial values of properties of type DateTime array. A map of property names to values
    (string/list of DateTimes).
    :var tagProps: Map of BusinessObject property names to values ('string, BusinessObjec't)
    :var tagArrayProps: Initial values of properties of type BusinessObject array. A map of property names to values
    (string/list of BusinessObjects)
    :var compoundCreateInput: Initial secondary CreateInput values of reference or relation properties. A map of
    reference or reation property names to values (string/list of CreateInputs).
    :var stringArrayProps: Initial values of properties of type string array. A map of property names to values
    (string/list of strings).
    :var doubleProps: Map of double property names to values ('string, double')
    :var doubleArrayProps: Initial values of properties of type double array. A map of property names to values
    (string/list of doubles).
    :var floatProps: Map of float property names to values ('string, float')
    :var floatArrayProps: Initial values of properties of type float array. A map of property names to values
    (string/list of floats).
    :var intProps: Map of int property names to values ('string, int')
    :var intArrayProps: Initial values of properties of type int array. A map of property names to values (string/list
    of ints).
    :var boolProps: Map of boolean property names to values (string, bool)
    """
    boName: str = ''
    stringProps: StringMap = None
    boolArrayProps: BoolVectorMap = None
    dateProps: DateMap = None
    dateArrayProps: DateVectorMap = None
    tagProps: TagMap = None
    tagArrayProps: TagVectorMap = None
    compoundCreateInput: CreateInputMap = None
    stringArrayProps: StringVectorMap = None
    doubleProps: DoubleMap = None
    doubleArrayProps: DoubleVectorMap = None
    floatProps: FloatMap = None
    floatArrayProps: FloatVectorMap = None
    intProps: IntMap = None
    intArrayProps: IntVectorMap = None
    boolProps: BoolMap = None


@dataclass
class CreateOrUpdateGDELinksResponse(TcBaseObj):
    """
    Create Or Update GDE Links Response
    
    :var successfullyProcessedGDELinks: A map containing the clientIds and the successfully created/updated
    GeneralDesignElementLink objects
    :var serviceData: Service data to report partial errors.
    """
    successfullyProcessedGDELinks: SuccessfullyProcessedGDELinksMap = None
    serviceData: ServiceData = None


@dataclass
class CreateOrUpdateItemElementsResponse(TcBaseObj):
    """
    Return structure for createOrUpdateItemElements operation
    
    :var serviceData: Standard ServiceData member containing created/updated objects and partial errors if any
    :var output: A list of createItemElementsOutput
    """
    serviceData: ServiceData = None
    output: List[ItemElementsOutput] = ()


@dataclass
class CreateOrUpdateRelationsInfo(TcBaseObj):
    """
    The required parameters to create the relation between the primary and secondary object.
    
    :var clientId: Identifier defined by user to track the related object.
    :var relationType: Realtion of interest, required for create or update.
    :var primaryObject: The primary object of interest, required for create or update.
    :var secondaryData: List of secondary objects per primaryObject via relation of type 'relationType'.
    :var relations: Instead of secondary business object in 'secondaryData' and 'primaryObject', this can be used, if
    such an object is available. This is only used if the 'primaryObject' is not specified. If 'relations' is
    specified, the primaries for all of them must be the same and the 'relations' must have the same 'relationType'.
    """
    clientId: str = ''
    relationType: str = ''
    primaryObject: BusinessObject = None
    secondaryData: List[SecondaryData] = ()
    relations: List[ImanRelation] = ()


@dataclass
class CreateOrUpdateRelationsOutput(TcBaseObj):
    """
    This structure contains information for 'CreateOrUpdateRelationsOutput'.
    
    :var clientId: The unmodified value from the 'CreateOrUpdateRelationsInfo.clientId'. This can be used by the caller
    to indentify this data structure with the source input data
    :var relations: The newly created relation.
    """
    clientId: str = ''
    relations: List[ImanRelation] = ()


@dataclass
class CreateOrUpdateRelationsResponse(TcBaseObj):
    """
    The relations created based on the input primary, secondary and relation type information and the errors that might
    have been encountered while creating, updating the relations.
    
    :var output: A list of 'CreateOrUpdateRelationsOutput'
    :var serviceData: Standard 'ServiceData' object to hold the partial errors that the operation encounters.
    """
    output: List[CreateOrUpdateRelationsOutput] = ()
    serviceData: ServiceData = None


@dataclass
class CreateOut(TcBaseObj):
    """
    This structure contains information or create operation including unique client identifier.
    
    :var clientId: Unique client identifier
    :var objects: A list of objects that were created
    """
    clientId: str = ''
    objects: List[BusinessObject] = ()


@dataclass
class CreateResponse(TcBaseObj):
    """
    Response object for create operation containing vector of objects that were created and partial errors.
    
    :var output: Vector of output objects representing objects that were created.
    :var serviceData: Service Data including partial errors that are mapped to the client id from the input. Created
    objects are also added to the created objects list in the Service Data.
    """
    output: List[CreateOut] = ()
    serviceData: ServiceData = None


@dataclass
class AddParticipantInfo(TcBaseObj):
    """
    'AddParticipantInfo' structure is an input for the 'addParticipants' operation.
    
    :var itemRev: An item revision to add participants to.
    :var participantInfo: Contains information to create a new participant or find an existing one.
    """
    itemRev: ItemRevision = None
    participantInfo: List[ParticipantInfo] = ()


@dataclass
class AddParticipantOutput(TcBaseObj):
    """
    'AddParticipantOutput' structure contains Item Revision and the added participants along with Service Data.
    
    :var participantOutput: List of structures containing the participants and the object to which participants are
    added.
    :var serviceData: The service data.
    """
    participantOutput: List[Participants] = ()
    serviceData: ServiceData = None


@dataclass
class DatasetFilter(TcBaseObj):
    """
    The structure contains information for determining which datasets to return.
    
    :var useNameFirst: Filter with the 'datasetName' first.
    :var processing: Specifies which version or versions of the Dataset are returned.
     Legal values are: 
    - All - All versions of the dataset are returned.
    - Min - The version 0 of the dataset is returned.
    - None - No dataset is returned.
    
    
    :var nrFilters: Filter to select datasets with a particular named reference to a specific uid. If empty then not
    used in filtering.
    :var name: The name of the Dataset objects to return. If empty then not used in filtering.
    :var relationFilters: The relation filters to use.
    """
    useNameFirst: bool = False
    processing: Processing = None
    nrFilters: List[NamedReferenceFilter] = ()
    name: str = ''
    relationFilters: List[DatasetRelationFilter] = ()


@dataclass
class DatasetInfo(TcBaseObj):
    """
    Input structure that the information for determining which datasets to return. If the 'datasetUid' is specified,
    then only that dataset will be returned. If the dataset does not exist then a null dataset is returned. If the
    'datasetUid' is not specified then the dataset filter determines the datasets to return. For each dataset to be
    returned, the 'NamedRef' will determine the named reference information to return. For each named reference
    returned that is a reference to a file, an FMS read ticket will be returned if 'ticket' is set.
    
    :var clientId: A unique string used to identify return data elements and partial errors associated with this input
    structure.
    :var uid: The uid of the only Dataset to return.
    :var filter: If a UID is not specified, determines the Dataset objects to return.
    :var namedRefs: Information about named references to return for each Dataset.
    """
    clientId: str = ''
    uid: str = ''
    filter: DatasetFilter = None
    namedRefs: List[NamedReferenceList] = ()


@dataclass
class DatasetOutput(TcBaseObj):
    """
    Output structure for Dataset information
    
    :var clientId: A unique string used to identify return data elements and partial errors associated with this input
    structure.
    :var dataset: Dataset object .
    :var relationTypeName: Relationship type to the dataset.
    :var namedReferenceOutput: The list of 'NROutput' for the dataset if requested.
    """
    clientId: str = ''
    dataset: Dataset = None
    relationTypeName: str = ''
    namedReferenceOutput: List[NROutput] = ()


@dataclass
class DatasetProperties2(TcBaseObj):
    """
    Input structure for createDatasets operation
    
    :var clientId: Identifier that helps the client to track the object(s) created, required; should be unique for the
    input set
    :var type: Type of the Dataset to be created
    :var name: Name of the Dataset to be created
    :var description: Description of the Dataset to be created, may be an empty string.
    :var toolUsed: Name of the Tool used to open the created Dataset, may be an empty string.  If it is an empty string
    no Tool will be associated to the Dataset to be created.
    :var datasetId: Unique identifier for the Dataset, may be an empty string. If the preference AE_datase_id_usage is
    ON, the id will be generated through user exit mechanism.
    :var datasetRev: The revision of this Dataset, may be an empty string.  If the preference AE_datase_id_usage is ON,
    the rev will be generated through user exit mechanism.
    :var container: Object reference of the container used to hold the created dataset, optional
    :var relationType: Name of the relation type for the Dataset to be created, may be an empty string.
    """
    clientId: str = ''
    type: str = ''
    name: str = ''
    description: str = ''
    toolUsed: str = ''
    datasetId: str = ''
    datasetRev: str = ''
    container: BusinessObject = None
    relationType: str = ''


@dataclass
class DatasetRelationFilter(TcBaseObj):
    """
    This structure contains information for determining which datasets to consider to return. The relation type and
    Dataset type will be used to produce a set of datasets.
    
    :var relationTypeName: The relation type name specifies the relation that relates the ItemRevision to the Dataset.
    If not specified then all.
    :var datasetTypeName: The type name of Dataset to return. If empty then all.
    """
    relationTypeName: str = ''
    datasetTypeName: str = ''


@dataclass
class DeepCopyData(TcBaseObj):
    """
    The data structure holds information required to apply deep copy rules.
    
    :var otherSideObjectTag: Object on which the deep copy should be performed.
    :var relationTypeName: Name of the relation that need to be deep copied.
    :var newName: New name for the new copy of the object represented by the 'otherSideObject'. The value for the
    'newName' will be null if 'action' is not 'CopyAsObject' or 'ReviseAndRelateToLatest'.
    :var action: Integer representing the action to be performed on the object represented by ''otherSideObjectTag''. 
    The values for action are: 
    - CopyAsObjectType = 0
    - CopyAsRefType = 1
    - DontCopyType =2
    - RelateToLatest = 3
    - ReviseAndRelateToLatest = 4
    
    
    :var isTargetPrimary: Indicates whether the given ItemRrevision is a primary object in the relation to be deep
    copied.
    :var isRequired: Indicates whether the deep information is from a mandatory deepcopy rule
    :var copyRelations: Indicates whether the properties on the relation should be copied
    """
    otherSideObjectTag: BusinessObject = None
    relationTypeName: str = ''
    newName: str = ''
    action: int = 0
    isTargetPrimary: bool = False
    isRequired: bool = False
    copyRelations: bool = False


@dataclass
class DisplayableBOsOut(TcBaseObj):
    """
    This structure contains a list of displayable business(BO) object under a given BO (displayable sub-BO hierarchy).
    
    :var boTypeName: Business object name for which displayable hierarchy is returned
    :var displayableBOTypeNames: Hierarchy of displayable business Objects
    """
    boTypeName: str = ''
    displayableBOTypeNames: List[BOHierarchy] = ()


@dataclass
class DisplayableSubBOsResponse(TcBaseObj):
    """
    Response for getDisplayableBusinessObjects
    
    :var output: Vector of output objects representing displayable types during create of a BO
    :var serviceData: Service data including partial errors that are mapped to the input BO type name
    """
    output: List[DisplayableBOsOut] = ()
    serviceData: ServiceData = None


class Processing(Enum):
    """
    The processing of information. Legal values are: 'None,  All,  Min, Ids, Rule and  Nrev'.
    """
    None_ = 'None'
    All = 'All'
    Min = 'Min'
    Ids = 'Ids'
    Rule = 'Rule'
    Nrev = 'Nrev'


"""
Map of reference or relation property name to secondary 'CreateInput' objects ('string, vector<CreateInput>').
"""
CreateInputMap = Dict[str, List[CreateInput]]


"""
Map of date property names to values ('string, date').
"""
DateMap = Dict[str, datetime]


"""
Map of DateTime array property names to values ('string, vector<DateTime>').
"""
DateVectorMap = Dict[str, List[datetime]]


"""
Map of double property names to values ('string, double').
"""
DoubleMap = Dict[str, float]


"""
Map of double array property names to values ('string, vector<double>').
"""
DoubleVectorMap = Dict[str, List[float]]


"""
Map of float property names to values ('string, float').
"""
FloatMap = Dict[str, float]


"""
Map of float array property names to values ('string, vector<float>').
"""
FloatVectorMap = Dict[str, List[float]]


"""
A map of attribute name to value pairs.
"""
AttributeMap = Dict[str, str]


"""
Map of int property names to values ('string, int').
"""
IntMap = Dict[str, int]


"""
Map of int array property names to values ('string, vector<int>').
"""
IntVectorMap = Dict[str, List[int]]


"""
A map of 'ReviseOutput' ('string, ReviseOutput').
"""
ReviseOutputMap = Dict[str, ReviseOutput]


"""
A map of the clientId from the input data to the output  from the service ('string, SaveAsNewItemOutput2')
"""
SaveAsNewItemOutputMap = Dict[str, SaveAsNewItemOutput2]


"""
Map of bool property names to values '(string, bool').
"""
BoolMap = Dict[str, bool]


"""
Map of string property names to values ('string, string').
"""
StringMap = Dict[str, str]


"""
Map of string array property names to values ('string, vector<string>').
"""
StringVectorMap = Dict[str, List[str]]


"""
Map of bool array property names to values ('string, vector< bool >').
"""
BoolVectorMap = Dict[str, List[bool]]


"""
A map of successfully processed GDE link to GeneralDesignElementLink.
"""
SuccessfullyProcessedGDELinksMap = Dict[str, GeneralDesignElementLink]


"""
Map of BusinessObject property names to values ('string, BusinessObject').
"""
TagMap = Dict[str, BusinessObject]


"""
Map of BusinessObject array property names to values ('string, vector<BusinessObject>').
"""
TagVectorMap = Dict[str, List[BusinessObject]]
