"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Choice = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const chain_1 = require("../chain");
const state_type_1 = require("./private/state-type");
const state_1 = require("./state");
/**
 * Define a Choice in the state machine.
 *
 * A choice state can be used to make decisions based on the execution
 * state.
 *
 * @stability stable
 */
class Choice extends state_1.State {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        /**
         * Continuable states of this Chainable.
         *
         * @stability stable
         */
        this.endStates = [];
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_ChoiceProps(props);
    }
    /**
     * If the given condition matches, continue execution with the given state.
     *
     * @stability stable
     */
    when(condition, next) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_Condition(condition);
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(next);
        super.addChoice(condition, next.startState);
        return this;
    }
    /**
     * If none of the given conditions match, continue execution with the given state.
     *
     * If no conditions match and no otherwise() has been given, an execution
     * error will be raised.
     *
     * @stability stable
     */
    otherwise(def) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(def);
        super.makeDefault(def.startState);
        return this;
    }
    /**
     * Return a Chain that contains all reachable end states from this Choice.
     *
     * Use this to combine all possible choice paths back.
     *
     * @stability stable
     */
    afterwards(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_AfterwardsOptions(options);
        const endStates = state_1.State.filterNextables(state_1.State.findReachableEndStates(this, { includeErrorHandlers: options.includeErrorHandlers }));
        if (options.includeOtherwise && this.defaultChoice) {
            throw new Error(`'includeOtherwise' set but Choice state ${this.stateId} already has an 'otherwise' transition`);
        }
        if (options.includeOtherwise) {
            endStates.push(new DefaultAsNext(this));
        }
        return chain_1.Chain.custom(this, endStates, this);
    }
    /**
     * Return the Amazon States Language object for this state.
     *
     * @stability stable
     */
    toStateJson() {
        return {
            Type: state_type_1.StateType.CHOICE,
            Comment: this.comment,
            ...this.renderInputOutput(),
            ...this.renderChoices(),
        };
    }
}
exports.Choice = Choice;
_a = JSII_RTTI_SYMBOL_1;
Choice[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Choice", version: "1.135.0" };
/**
 * Adapter to make the .otherwise() transition settable through .next()
 */
class DefaultAsNext {
    constructor(choice) {
        this.choice = choice;
    }
    next(state) {
        this.choice.otherwise(state);
        return chain_1.Chain.sequence(this.choice, state);
    }
}
//# sourceMappingURL=data:application/json;base64,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