#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.context',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20200725',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'Context managers. Initially just `stackattrs`.',
  long_description =
    ('Context managers. Initially just `stackattrs`.\n'    
 '\n'    
 '*Latest release 20200725*:\n'    
 'New stackkeys and components pushkeys and popkeys doing "stackattrs for '    
 'dicts/mappings".\n'    
 '\n'    
 '## Function `popattrs(o, attr_names, old_values)`\n'    
 '\n'    
 'The "pop" part of `stackattrs`.\n'    
 'Restore previous attributes of `o`\n'    
 'named by `attr_names` with previous state in `old_values`.\n'    
 '\n'    
 'This can be useful in hook/signal/callback,\n'    
 'where you cannot inline a context manager.\n'    
 '\n'    
 '## Function `popkeys(d, key_names, old_values)`\n'    
 '\n'    
 'The "pop" part of `stackkeys`.\n'    
 'Restore previous key values of `d`\n'    
 'named by `key_names` with previous state in `old_values`.\n'    
 '\n'    
 'This can be useful in hook/signal/callback,\n'    
 'where you cannot inline a context manager.\n'    
 '\n'    
 '## Function `pushattrs(o, **attr_values)`\n'    
 '\n'    
 'The "push" part of `stackattrs`.\n'    
 'Push `attr_values` onto `o` as attributes,\n'    
 'return the previous attribute values in a dict.\n'    
 '\n'    
 'This can be useful in hook/signal/callback,\n'    
 'where you cannot inline a context manager.\n'    
 '\n'    
 '## Function `pushkeys(d, **key_values)`\n'    
 '\n'    
 'The "push" part of `stackkeys`.\n'    
 'Push `key_values` onto `d` as key values.\n'    
 'return the previous key values in a dict.\n'    
 '\n'    
 'This can be useful in hook/signal/callback,\n'    
 'where you cannot inline a context manager.\n'    
 '\n'    
 '## Function `stackattrs(o, **attr_values)`\n'    
 '\n'    
 'Context manager to push new values for the attributes of `o`\n'    
 'and to restore them afterward.\n'    
 'Returns a `dict` containing a mapping of the previous attribute values.\n'    
 'Attributes not present are not present in the mapping.\n'    
 '\n'    
 'Restoration includes deleting attributes which were not present\n'    
 'initially.\n'    
 '\n'    
 'See `stackkeys` for a flavour of this for mappings.\n'    
 '\n'    
 'Example of fiddling a programme\'s "verbose" mode:\n'    
 '\n'    
 '    >>> class RunModes:\n'    
 '    ...     def __init__(self, verbose=False):\n'    
 '    ...         self.verbose = verbose\n'    
 '    ...\n'    
 '    >>> runmode = RunModes()\n'    
 '    >>> if runmode.verbose:\n'    
 '    ...     print("suppressed message")\n'    
 '    ...\n'    
 '    >>> with stackattrs(runmode, verbose=True):\n'    
 '    ...     if runmode.verbose:\n'    
 '    ...         print("revealed message")\n'    
 '    ...\n'    
 '    revealed message\n'    
 '    >>> if runmode.verbose:\n'    
 '    ...     print("another suppressed message")\n'    
 '    ...\n'    
 '\n'    
 'Example exhibiting restoration of absent attributes:\n'    
 '\n'    
 '    >>> class O:\n'    
 '    ...     def __init__(self):\n'    
 '    ...         self.a = 1\n'    
 '    ...\n'    
 '    >>> o = O()\n'    
 '    >>> print(o.a)\n'    
 '    1\n'    
 '    >>> print(o.b)\n'    
 '    Traceback (most recent call last):\n'    
 '      File "<stdin>", line 1, in <module>\n'    
 "    AttributeError: 'O' object has no attribute 'b'\n"    
 '    >>> with stackattrs(o, a=3, b=4):\n'    
 '    ...     print(o.a)\n'    
 '    ...     print(o.b)\n'    
 '    ...     o.b = 5\n'    
 '    ...     print(o.b)\n'    
 "    ...     delattr(o, 'a')\n"    
 '    ...\n'    
 '    3\n'    
 '    4\n'    
 '    5\n'    
 '    >>> print(o.a)\n'    
 '    1\n'    
 '    >>> print(o.b)\n'    
 '    Traceback (most recent call last):\n'    
 '      File "<stdin>", line 1, in <module>\n'    
 "    AttributeError: 'O' object has no attribute 'b'\n"    
 '\n'    
 '## Function `stackkeys(d, **key_values)`\n'    
 '\n'    
 'Context manager to push new values for the key values of `d`\n'    
 'and to restore them afterward.\n'    
 'Returns a `dict` containing a mapping of the previous key values.\n'    
 'Keys not present are not present in the mapping.\n'    
 '\n'    
 'Restoration includes deleting key values which were not present\n'    
 'initially.\n'    
 '\n'    
 'See `stackattrs` for a flavour of this for objects.\n'    
 '\n'    
 'Example of making log entries which may reference\n'    
 'some higher level context log entry:\n'    
 '\n'    
 '    >>> import time\n'    
 '    >>> global_context = {\n'    
 "    ...     'parent': None,\n"    
 '    ... }\n'    
 '    >>> def log_entry(desc, **kw):\n'    
 '    ...     print("log_entry: global_context =", repr(global_context))\n'    
 '    ...     entry = dict(global_context)\n'    
 '    ...     entry.update(desc=desc, when=time.time())\n'    
 '    ...     entry.update(kw)\n'    
 '    ...     return entry\n'    
 '    ...\n'    
 '    >>> log_entry("stand alone entry")    #doctest: +ELLIPSIS\n'    
 "    log_entry: global_context = {'parent': None}\n"    
 "    {'parent': None, 'desc': 'stand alone entry', 'when': ...}\n"    
 '    >>> context_entry = log_entry("high level entry")\n'    
 "    log_entry: global_context = {'parent': None}\n"    
 '    >>> context_entry                     #doctest: +ELLIPSIS\n'    
 "    {'parent': None, 'desc': 'high level entry', 'when': ...}\n"    
 '    >>> with stackkeys(global_context, parent=context_entry): #doctest: '    
 '+ELLIPSIS\n'    
 '    ...     print(repr(log_entry("low level event")))\n'    
 '    ...\n'    
 "    log_entry: global_context = {'parent': {'parent': None, 'desc': 'high "    
 "level entry', 'when': ...}}\n"    
 "    {'parent': {'parent': None, 'desc': 'high level entry', 'when': ...}, "    
 "'desc': 'low level event', 'when': ...}\n"    
 '    >>> log_entry("another standalone entry")    #doctest: +ELLIPSIS\n'    
 "    log_entry: global_context = {'parent': None}\n"    
 "    {'parent': None, 'desc': 'another standalone entry', 'when': ...}\n"    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20200725*:\n'    
 'New stackkeys and components pushkeys and popkeys doing "stackattrs for '    
 'dicts/mappings".\n'    
 '\n'    
 '*Release 20200517*:\n'    
 '* Add `nullcontext` like the one from recent contextlib.\n'    
 '* stackattrs: expose the push and pop parts as pushattrs() and popattrs().\n'    
 '\n'    
 '*Release 20200228.1*:\n'    
 'Initial release with stackattrs context manager.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  install_requires = [],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.context'],
)
