"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerImage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const assets = require("aws-cdk-lib/aws-ecr-assets");
const util_1 = require("./private/util");
/**
 * Constructs for types of container images
 */
class ContainerImage {
    /**
     * Reference an image in an ECR repository
     */
    static fromEcrRepository(repository, tag = 'latest') {
        return new EcrImage(repository, tag);
    }
    /**
     * Reference an image that's constructed directly from sources on disk
     * @param directory The directory where the Dockerfile is stored
     * @param options The options to further configure the selected image
     */
    static fromAsset(directory, options = {}) {
        return new AssetImage(directory, options);
    }
}
exports.ContainerImage = ContainerImage;
_a = JSII_RTTI_SYMBOL_1;
ContainerImage[_a] = { fqn: "@aws-cdk/aws-sagemaker-alpha.ContainerImage", version: "2.62.1-alpha.0" };
class EcrImage extends ContainerImage {
    constructor(repository, tag) {
        super();
        this.repository = repository;
        this.tag = tag;
    }
    bind(_scope, model) {
        this.repository.grantPull(model);
        return {
            imageName: this.repository.repositoryUriForTag(this.tag),
        };
    }
}
class AssetImage extends ContainerImage {
    constructor(directory, options = {}) {
        super();
        this.directory = directory;
        this.options = options;
    }
    bind(scope, model) {
        // Retain the first instantiation of this asset
        if (!this.asset) {
            this.asset = new assets.DockerImageAsset(scope, `ModelImage${util_1.hashcode(this.directory)}`, {
                directory: this.directory,
                ...this.options,
            });
        }
        this.asset.repository.grantPull(model);
        return {
            imageName: this.asset.imageUri,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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