/**
 * Supported Elastic Inference (EI) instance types for SageMaker instance-based production variants.
 * EI instances provide on-demand GPU computing for inference.
 */
export declare class AcceleratorType {
    /**
     * ml.eia1.large
     */
    static readonly EIA1_LARGE: AcceleratorType;
    /**
     * ml.eia1.medium
     */
    static readonly EIA1_MEDIUM: AcceleratorType;
    /**
     * ml.eia1.xlarge
     */
    static readonly EIA1_XLARGE: AcceleratorType;
    /**
     * ml.eia2.large
     */
    static readonly EIA2_LARGE: AcceleratorType;
    /**
     * ml.eia2.medium
     */
    static readonly EIA2_MEDIUM: AcceleratorType;
    /**
     * ml.eia2.xlarge
     */
    static readonly EIA2_XLARGE: AcceleratorType;
    /**
     * Builds an AcceleratorType from a given string or token (such as a CfnParameter).
     * @param acceleratorType An accelerator type as string
     * @returns A strongly typed AcceleratorType
     */
    static of(acceleratorType: string): AcceleratorType;
    private readonly acceleratorTypeIdentifier;
    constructor(acceleratorType: string);
    /**
     * Return the accelerator type as a string
     * @returns The accelerator type as a string
     */
    toString(): string;
}
