"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from gr4vy import errors, models, utils
from gr4vy._hooks import HookContext
from gr4vy.types import OptionalNullable, UNSET
from gr4vy.utils import get_security_from_env
from typing import Any, Mapping, Optional


class PaymentServiceTokens(BaseSDK):
    def list(
        self,
        *,
        payment_method_id: str,
        payment_service_id: OptionalNullable[str] = UNSET,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CollectionNoCursorPaymentServiceToken:
        r"""List payment service tokens

        List all gateway tokens stored for a payment method.

        :param payment_method_id: The ID of the payment method
        :param payment_service_id: The ID of the payment service
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListPaymentMethodPaymentServiceTokensRequest(
            payment_method_id=payment_method_id,
            payment_service_id=payment_service_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="GET",
            path="/payment-methods/{payment_method_id}/payment-service-tokens",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListPaymentMethodPaymentServiceTokensGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list_payment_method_payment_service_tokens",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, models.CollectionNoCursorPaymentServiceToken
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text,
                errors.Response403ListPaymentMethodPaymentServiceTokensUnion,
            )
            raise errors.Response403ListPaymentMethodPaymentServiceTokens(
                data=response_data
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def list_async(
        self,
        *,
        payment_method_id: str,
        payment_service_id: OptionalNullable[str] = UNSET,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CollectionNoCursorPaymentServiceToken:
        r"""List payment service tokens

        List all gateway tokens stored for a payment method.

        :param payment_method_id: The ID of the payment method
        :param payment_service_id: The ID of the payment service
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListPaymentMethodPaymentServiceTokensRequest(
            payment_method_id=payment_method_id,
            payment_service_id=payment_service_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/payment-methods/{payment_method_id}/payment-service-tokens",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListPaymentMethodPaymentServiceTokensGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="list_payment_method_payment_service_tokens",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, models.CollectionNoCursorPaymentServiceToken
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text,
                errors.Response403ListPaymentMethodPaymentServiceTokensUnion,
            )
            raise errors.Response403ListPaymentMethodPaymentServiceTokens(
                data=response_data
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def create(
        self,
        *,
        payment_method_id: str,
        payment_service_id: str,
        redirect_url: str,
        timeout_in_seconds: Optional[float] = 1,
        merchant_account_id: Optional[str] = None,
        security_code: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PaymentServiceToken:
        r"""Create payment service token

        Create a gateway tokens for a payment method.

        :param payment_method_id: The ID of the payment method
        :param payment_service_id: The ID of the payment method to use.
        :param redirect_url: The redirect URL to redirect a buyer to after they have authorized the payment method.
        :param timeout_in_seconds:
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param security_code: The 3 or 4 digit security code often found on the card. This often referred to as the CVV or CVD.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreatePaymentMethodPaymentServiceTokenRequest(
            payment_method_id=payment_method_id,
            timeout_in_seconds=timeout_in_seconds,
            merchant_account_id=merchant_account_id,
            payment_service_token_create=models.PaymentServiceTokenCreate(
                security_code=security_code,
                payment_service_id=payment_service_id,
                redirect_url=redirect_url,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/payment-methods/{payment_method_id}/payment-service-tokens",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CreatePaymentMethodPaymentServiceTokenGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.payment_service_token_create,
                False,
                False,
                "json",
                models.PaymentServiceTokenCreate,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create_payment_method_payment_service_token",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return utils.unmarshal_json(http_res.text, models.PaymentServiceToken)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text,
                errors.Response403CreatePaymentMethodPaymentServiceTokenUnion,
            )
            raise errors.Response403CreatePaymentMethodPaymentServiceToken(
                data=response_data
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def create_async(
        self,
        *,
        payment_method_id: str,
        payment_service_id: str,
        redirect_url: str,
        timeout_in_seconds: Optional[float] = 1,
        merchant_account_id: Optional[str] = None,
        security_code: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.PaymentServiceToken:
        r"""Create payment service token

        Create a gateway tokens for a payment method.

        :param payment_method_id: The ID of the payment method
        :param payment_service_id: The ID of the payment method to use.
        :param redirect_url: The redirect URL to redirect a buyer to after they have authorized the payment method.
        :param timeout_in_seconds:
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param security_code: The 3 or 4 digit security code often found on the card. This often referred to as the CVV or CVD.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreatePaymentMethodPaymentServiceTokenRequest(
            payment_method_id=payment_method_id,
            timeout_in_seconds=timeout_in_seconds,
            merchant_account_id=merchant_account_id,
            payment_service_token_create=models.PaymentServiceTokenCreate(
                security_code=security_code,
                payment_service_id=payment_service_id,
                redirect_url=redirect_url,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/payment-methods/{payment_method_id}/payment-service-tokens",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.CreatePaymentMethodPaymentServiceTokenGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.payment_service_token_create,
                False,
                False,
                "json",
                models.PaymentServiceTokenCreate,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="create_payment_method_payment_service_token",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return utils.unmarshal_json(http_res.text, models.PaymentServiceToken)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text,
                errors.Response403CreatePaymentMethodPaymentServiceTokenUnion,
            )
            raise errors.Response403CreatePaymentMethodPaymentServiceToken(
                data=response_data
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    def delete(
        self,
        *,
        payment_method_id: str,
        payment_service_token_id: str,
        timeout_in_seconds: Optional[float] = 1,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete payment service token

        Delete a gateway tokens for a payment method.

        :param payment_method_id: The ID of the payment method
        :param payment_service_token_id: The ID of the payment service token
        :param timeout_in_seconds:
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeletePaymentMethodPaymentServiceTokenRequest(
            payment_method_id=payment_method_id,
            payment_service_token_id=payment_service_token_id,
            timeout_in_seconds=timeout_in_seconds,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/payment-methods/{payment_method_id}/payment-service-tokens/{payment_service_token_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeletePaymentMethodPaymentServiceTokenGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="delete_payment_method_payment_service_token",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text,
                errors.Response403DeletePaymentMethodPaymentServiceTokenUnion,
            )
            raise errors.Response403DeletePaymentMethodPaymentServiceToken(
                data=response_data
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )

    async def delete_async(
        self,
        *,
        payment_method_id: str,
        payment_service_token_id: str,
        timeout_in_seconds: Optional[float] = 1,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete payment service token

        Delete a gateway tokens for a payment method.

        :param payment_method_id: The ID of the payment method
        :param payment_service_token_id: The ID of the payment service token
        :param timeout_in_seconds:
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeletePaymentMethodPaymentServiceTokenRequest(
            payment_method_id=payment_method_id,
            payment_service_token_id=payment_service_token_id,
            timeout_in_seconds=timeout_in_seconds,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/payment-methods/{payment_method_id}/payment-service-tokens/{payment_service_token_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeletePaymentMethodPaymentServiceTokenGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="delete_payment_method_payment_service_token",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error400Data)
            raise errors.Error400(data=response_data)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error401Data)
            raise errors.Error401(data=response_data)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text,
                errors.Response403DeletePaymentMethodPaymentServiceTokenUnion,
            )
            raise errors.Response403DeletePaymentMethodPaymentServiceToken(
                data=response_data
            )
        if utils.match_response(http_res, "404", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error404Data)
            raise errors.Error404(data=response_data)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error405Data)
            raise errors.Error405(data=response_data)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error409Data)
            raise errors.Error409(data=response_data)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = utils.unmarshal_json(
                http_res.text, errors.HTTPValidationErrorData
            )
            raise errors.HTTPValidationError(data=response_data)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error425Data)
            raise errors.Error425(data=response_data)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error429Data)
            raise errors.Error429(data=response_data)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error500Data)
            raise errors.Error500(data=response_data)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error502Data)
            raise errors.Error502(data=response_data)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = utils.unmarshal_json(http_res.text, errors.Error504Data)
            raise errors.Error504(data=response_data)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )

        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.APIError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
