"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .refundtargettype import RefundTargetType
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_open_enum
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TransactionRefundCreateTypedDict(TypedDict):
    amount: NotRequired[Nullable[int]]
    r"""The amount requested to refund. If omitted, a full refund will be requested."""
    target_type: NotRequired[RefundTargetType]
    target_id: NotRequired[Nullable[str]]
    r"""The optional ID of the instrument to refund for. This is only required when the `target_type` is set to `gift-card-redemption`."""
    reason: NotRequired[Nullable[str]]
    r"""An optional reason to attach extra context to the refund request."""
    external_identifier: NotRequired[Nullable[str]]
    r"""An external identifier that can be used to match the refund against your own records."""


class TransactionRefundCreate(BaseModel):
    amount: OptionalNullable[int] = UNSET
    r"""The amount requested to refund. If omitted, a full refund will be requested."""

    target_type: Annotated[
        Optional[RefundTargetType], PlainValidator(validate_open_enum(False))
    ] = None

    target_id: OptionalNullable[str] = UNSET
    r"""The optional ID of the instrument to refund for. This is only required when the `target_type` is set to `gift-card-redemption`."""

    reason: OptionalNullable[str] = UNSET
    r"""An optional reason to attach extra context to the refund request."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""An external identifier that can be used to match the refund against your own records."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "amount",
            "target_type",
            "target_id",
            "reason",
            "external_identifier",
        ]
        nullable_fields = ["amount", "target_id", "reason", "external_identifier"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
