"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .definitionfield import DefinitionField, DefinitionFieldTypedDict
from .method import Method
from .mode import Mode
from .paymentserviceconfiguration import (
    PaymentServiceConfiguration,
    PaymentServiceConfigurationTypedDict,
)
from .requiredcheckoutfields import (
    RequiredCheckoutFields,
    RequiredCheckoutFieldsTypedDict,
)
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Dict, List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentServiceDefinitionTypedDict(TypedDict):
    id: str
    r"""The definition ID of the payment service that can be configured. This is the underlying provider followed by a dash followed by the method."""
    display_name: str
    r"""A human friendly name for this service."""
    method: Method
    fields: List[DefinitionFieldTypedDict]
    r"""A list of credentials and related fields which can be configured for this service."""
    reporting_fields: List[DefinitionFieldTypedDict]
    r"""A list of reporting fields which can be configured for this service."""
    supported_currencies: List[str]
    r"""A list of three-letter ISO currency codes that this service supports."""
    supported_countries: List[str]
    r"""A list of two-letter ISO country codes that this service supports."""
    mode: Mode
    supported_features: Dict[str, bool]
    r"""Features supported by the payment service."""
    required_checkout_fields: List[RequiredCheckoutFieldsTypedDict]
    r"""A list of condition that define when some fields must be provided with a transaction request."""
    configuration: PaymentServiceConfigurationTypedDict
    type: Literal["payment-service-definition"]
    r"""Always `payment-service-definition`."""
    icon_url: NotRequired[Nullable[str]]
    r"""An icon to display for the payment service."""


class PaymentServiceDefinition(BaseModel):
    id: str
    r"""The definition ID of the payment service that can be configured. This is the underlying provider followed by a dash followed by the method."""

    display_name: str
    r"""A human friendly name for this service."""

    method: Annotated[Method, PlainValidator(validate_open_enum(False))]

    fields: List[DefinitionField]
    r"""A list of credentials and related fields which can be configured for this service."""

    reporting_fields: List[DefinitionField]
    r"""A list of reporting fields which can be configured for this service."""

    supported_currencies: List[str]
    r"""A list of three-letter ISO currency codes that this service supports."""

    supported_countries: List[str]
    r"""A list of two-letter ISO country codes that this service supports."""

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]

    supported_features: Dict[str, bool]
    r"""Features supported by the payment service."""

    required_checkout_fields: List[RequiredCheckoutFields]
    r"""A list of condition that define when some fields must be provided with a transaction request."""

    configuration: PaymentServiceConfiguration

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payment-service-definition"]],
            AfterValidator(validate_const("payment-service-definition")),
        ],
        pydantic.Field(alias="type"),
    ] = "payment-service-definition"
    r"""Always `payment-service-definition`."""

    icon_url: OptionalNullable[str] = UNSET
    r"""An icon to display for the payment service."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["type", "icon_url"]
        nullable_fields = ["icon_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
