"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardscheme import CardScheme
from gr4vy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Union
from typing_extensions import Annotated, NotRequired, TypedDict


CardSource = Union[Literal["apple-pay", "google-pay"], UnrecognizedStr]


class NetworkTokenPaymentMethodCreateTypedDict(TypedDict):
    token: str
    r"""The scheme token."""
    expiration_date: str
    r"""The expiration date of the token."""
    method: Literal["network-token"]
    r"""Always `network-token`."""
    cryptogram: NotRequired[Nullable[str]]
    r"""The payment cryptogram for the network token."""
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL to redirect a user back to after the complete 3DS in browser."""
    card_source: NotRequired[Nullable[CardSource]]
    r"""The optional source of the decrypted device token."""
    card_scheme: NotRequired[Nullable[CardScheme]]
    r"""The original card scheme for which the token was generated."""
    card_suffix: NotRequired[Nullable[str]]
    r"""The last 4 digits of the original card used to generate the token."""
    cardholder_name: NotRequired[Nullable[str]]
    r"""The card holder name associated to the original card for the token."""
    eci: NotRequired[Nullable[str]]
    r"""The ecommerce indicator for the token."""


class NetworkTokenPaymentMethodCreate(BaseModel):
    token: str
    r"""The scheme token."""

    expiration_date: str
    r"""The expiration date of the token."""

    METHOD: Annotated[
        Annotated[
            Literal["network-token"], AfterValidator(validate_const("network-token"))
        ],
        pydantic.Field(alias="method"),
    ] = "network-token"
    r"""Always `network-token`."""

    cryptogram: OptionalNullable[str] = UNSET
    r"""The payment cryptogram for the network token."""

    redirect_url: OptionalNullable[str] = UNSET
    r"""The URL to redirect a user back to after the complete 3DS in browser."""

    card_source: Annotated[
        OptionalNullable[CardSource], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The optional source of the decrypted device token."""

    card_scheme: Annotated[
        OptionalNullable[CardScheme], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The original card scheme for which the token was generated."""

    card_suffix: OptionalNullable[str] = UNSET
    r"""The last 4 digits of the original card used to generate the token."""

    cardholder_name: OptionalNullable[str] = UNSET
    r"""The card holder name associated to the original card for the token."""

    eci: OptionalNullable[str] = UNSET
    r"""The ecommerce indicator for the token."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cryptogram",
            "redirect_url",
            "card_source",
            "card_scheme",
            "card_suffix",
            "cardholder_name",
            "eci",
        ]
        nullable_fields = [
            "cryptogram",
            "redirect_url",
            "card_source",
            "card_scheme",
            "card_suffix",
            "cardholder_name",
            "eci",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
