"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .collection_transactionsummary_ import (
    CollectionTransactionSummary,
    CollectionTransactionSummaryTypedDict,
)
from .method import Method
from .transactionpaymentsource import TransactionPaymentSource
from .transactionstatus import TransactionStatus
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import (
    FieldMetadata,
    HeaderMetadata,
    QueryParamMetadata,
    validate_open_enum,
)
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Callable, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListTransactionsGlobalsTypedDict(TypedDict):
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ListTransactionsGlobals(BaseModel):
    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""


class ListTransactionsRequestTypedDict(TypedDict):
    cursor: NotRequired[Nullable[str]]
    r"""A pointer to the page of results to return."""
    limit: NotRequired[int]
    r"""The maximum number of items that are at returned."""
    created_at_lte: NotRequired[Nullable[datetime]]
    r"""Filters the results to only transactions created before this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`."""
    created_at_gte: NotRequired[Nullable[datetime]]
    r"""Filters the results to only transactions created after this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`."""
    updated_at_lte: NotRequired[Nullable[datetime]]
    r"""Filters the results to only transactions updated before this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`."""
    updated_at_gte: NotRequired[Nullable[datetime]]
    r"""Filters the results to only transactions updated after this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`."""
    search: NotRequired[Nullable[str]]
    buyer_external_identifier: NotRequired[Nullable[str]]
    buyer_id: NotRequired[Nullable[str]]
    buyer_email_address: NotRequired[Nullable[str]]
    status: NotRequired[Nullable[List[TransactionStatus]]]
    r"""Filters the results to only the transactions that have a `status` that matches with any of the provided status values."""
    id: NotRequired[Nullable[str]]
    payment_service_transaction_id: NotRequired[Nullable[str]]
    external_identifier: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[List[str]]]
    r"""Filters for transactions where their `metadata` values contain all of the provided `metadata` keys. The value sent for `metadata` must be formatted as a JSON string, and all keys and values must be strings. This value should also be URL encoded."""
    amount_eq: NotRequired[Nullable[int]]
    r"""Filters for transactions that have an `amount` that is equal to the provided `amount_eq` value."""
    amount_lte: NotRequired[Nullable[int]]
    r"""Filters for transactions that have an `amount` that is less than or equal to the `amount_lte` value."""
    amount_gte: NotRequired[Nullable[int]]
    r"""Filters for transactions that have an `amount` that is greater than or equal to the `amount_gte` value."""
    currency: NotRequired[Nullable[List[str]]]
    r"""Filters for transactions that have matching `currency` values. The `currency` values provided must be formatted as 3-letter ISO currency code."""
    payment_service_id: NotRequired[Nullable[List[str]]]
    r"""Filters for transactions that were processed by the provided `payment_service_id` values."""
    payment_method_id: NotRequired[Nullable[str]]
    payment_method_label: NotRequired[Nullable[str]]
    payment_method_fingerprint: NotRequired[Nullable[str]]
    method: NotRequired[Nullable[List[Method]]]
    r"""Filters for transactions that have matching `method` values."""
    error_code: NotRequired[Nullable[List[str]]]
    r"""Filters for transactions where the `error_code` matches one for the provided values."""
    has_refunds: NotRequired[Nullable[bool]]
    r"""Filters for transactions with refunds."""
    pending_review: NotRequired[Nullable[bool]]
    r"""Filters for transactions with a pending manual anti-fraud review."""
    checkout_session_id: NotRequired[Nullable[str]]
    r"""Filters for transactions where the `checkout_session_id` matches the provided value."""
    reconciliation_id: NotRequired[Nullable[str]]
    r"""Filters for transactions where the `reconciliation_id` matches the provided value."""
    has_gift_card_redemptions: NotRequired[Nullable[bool]]
    r"""Filters for transactions with gift card redemptions."""
    gift_card_id: NotRequired[Nullable[str]]
    r"""Filters for transactions where a gift card used has an `id` that matches the provided value."""
    gift_card_last4: NotRequired[Nullable[str]]
    r"""Filters for transactions that have at least one gift card redemption where the last 4 digits of its gift card number matches exactly with the provided value."""
    has_settlements: NotRequired[Nullable[bool]]
    r"""Filters for transactions that have at least one associated settlement record."""
    payment_method_bin: NotRequired[Nullable[str]]
    r"""Filter for transactions that have a card with a BIN that matches exactly with the provided value."""
    payment_source: NotRequired[Nullable[List[TransactionPaymentSource]]]
    r"""Filters the results to only the transactions that have a payment source that matches with any of the provided values."""
    is_subsequent_payment: NotRequired[Nullable[bool]]
    r"""Filters for transactions where the `is_subsequent_payment` matches the provided value."""
    merchant_initiated: NotRequired[Nullable[bool]]
    r"""Filters for transactions where the `merchant_initiated` matches the provided value."""
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ListTransactionsRequest(BaseModel):
    cursor: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""A pointer to the page of results to return."""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 20
    r"""The maximum number of items that are at returned."""

    created_at_lte: Annotated[
        OptionalNullable[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters the results to only transactions created before this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`."""

    created_at_gte: Annotated[
        OptionalNullable[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters the results to only transactions created after this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`."""

    updated_at_lte: Annotated[
        OptionalNullable[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters the results to only transactions updated before this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`."""

    updated_at_gte: Annotated[
        OptionalNullable[datetime],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters the results to only transactions updated after this ISO date-time string. The time zone must be included. Ensure that the date-time string is URL encoded, e.g. `2022-01-01T12:00:00+08:00` must be encoded as `2022-01-01T12%3A00%3A00%2B08%3A00`."""

    search: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    buyer_external_identifier: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    buyer_id: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    buyer_email_address: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    status: Annotated[
        OptionalNullable[
            List[
                Annotated[TransactionStatus, PlainValidator(validate_open_enum(False))]
            ]
        ],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters the results to only the transactions that have a `status` that matches with any of the provided status values."""

    id: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    payment_service_transaction_id: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    external_identifier: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    metadata: Annotated[
        OptionalNullable[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions where their `metadata` values contain all of the provided `metadata` keys. The value sent for `metadata` must be formatted as a JSON string, and all keys and values must be strings. This value should also be URL encoded."""

    amount_eq: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions that have an `amount` that is equal to the provided `amount_eq` value."""

    amount_lte: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions that have an `amount` that is less than or equal to the `amount_lte` value."""

    amount_gte: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions that have an `amount` that is greater than or equal to the `amount_gte` value."""

    currency: Annotated[
        OptionalNullable[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions that have matching `currency` values. The `currency` values provided must be formatted as 3-letter ISO currency code."""

    payment_service_id: Annotated[
        OptionalNullable[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions that were processed by the provided `payment_service_id` values."""

    payment_method_id: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    payment_method_label: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    payment_method_fingerprint: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET

    method: Annotated[
        OptionalNullable[
            List[Annotated[Method, PlainValidator(validate_open_enum(False))]]
        ],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions that have matching `method` values."""

    error_code: Annotated[
        OptionalNullable[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions where the `error_code` matches one for the provided values."""

    has_refunds: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions with refunds."""

    pending_review: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions with a pending manual anti-fraud review."""

    checkout_session_id: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions where the `checkout_session_id` matches the provided value."""

    reconciliation_id: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions where the `reconciliation_id` matches the provided value."""

    has_gift_card_redemptions: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions with gift card redemptions."""

    gift_card_id: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions where a gift card used has an `id` that matches the provided value."""

    gift_card_last4: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions that have at least one gift card redemption where the last 4 digits of its gift card number matches exactly with the provided value."""

    has_settlements: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions that have at least one associated settlement record."""

    payment_method_bin: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filter for transactions that have a card with a BIN that matches exactly with the provided value."""

    payment_source: Annotated[
        OptionalNullable[
            List[
                Annotated[
                    TransactionPaymentSource, PlainValidator(validate_open_enum(False))
                ]
            ]
        ],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters the results to only the transactions that have a payment source that matches with any of the provided values."""

    is_subsequent_payment: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions where the `is_subsequent_payment` matches the provided value."""

    merchant_initiated: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Filters for transactions where the `merchant_initiated` matches the provided value."""

    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cursor",
            "limit",
            "created_at_lte",
            "created_at_gte",
            "updated_at_lte",
            "updated_at_gte",
            "search",
            "buyer_external_identifier",
            "buyer_id",
            "buyer_email_address",
            "status",
            "id",
            "payment_service_transaction_id",
            "external_identifier",
            "metadata",
            "amount_eq",
            "amount_lte",
            "amount_gte",
            "currency",
            "payment_service_id",
            "payment_method_id",
            "payment_method_label",
            "payment_method_fingerprint",
            "method",
            "error_code",
            "has_refunds",
            "pending_review",
            "checkout_session_id",
            "reconciliation_id",
            "has_gift_card_redemptions",
            "gift_card_id",
            "gift_card_last4",
            "has_settlements",
            "payment_method_bin",
            "payment_source",
            "is_subsequent_payment",
            "merchant_initiated",
            "merchant_account_id",
        ]
        nullable_fields = [
            "cursor",
            "created_at_lte",
            "created_at_gte",
            "updated_at_lte",
            "updated_at_gte",
            "search",
            "buyer_external_identifier",
            "buyer_id",
            "buyer_email_address",
            "status",
            "id",
            "payment_service_transaction_id",
            "external_identifier",
            "metadata",
            "amount_eq",
            "amount_lte",
            "amount_gte",
            "currency",
            "payment_service_id",
            "payment_method_id",
            "payment_method_label",
            "payment_method_fingerprint",
            "method",
            "error_code",
            "has_refunds",
            "pending_review",
            "checkout_session_id",
            "reconciliation_id",
            "has_gift_card_redemptions",
            "gift_card_id",
            "gift_card_last4",
            "has_settlements",
            "payment_method_bin",
            "payment_source",
            "is_subsequent_payment",
            "merchant_initiated",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListTransactionsResponseTypedDict(TypedDict):
    result: CollectionTransactionSummaryTypedDict


class ListTransactionsResponse(BaseModel):
    next: Callable[[], Optional[ListTransactionsResponse]]

    result: CollectionTransactionSummary
