"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardpaymentmethodcreate import (
    CardPaymentMethodCreate,
    CardPaymentMethodCreateTypedDict,
)
from .checkoutsessionpaymentmethodcreate import (
    CheckoutSessionPaymentMethodCreate,
    CheckoutSessionPaymentMethodCreateTypedDict,
)
from .redirectpaymentmethodcreate import (
    RedirectPaymentMethodCreate,
    RedirectPaymentMethodCreateTypedDict,
)
from gr4vy.types import BaseModel
from gr4vy.utils import (
    FieldMetadata,
    HeaderMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreatePaymentMethodGlobalsTypedDict(TypedDict):
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class CreatePaymentMethodGlobals(BaseModel):
    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""


BodyTypedDict = TypeAliasType(
    "BodyTypedDict",
    Union[
        CheckoutSessionPaymentMethodCreateTypedDict,
        RedirectPaymentMethodCreateTypedDict,
        CardPaymentMethodCreateTypedDict,
    ],
)


Body = TypeAliasType(
    "Body",
    Union[
        CheckoutSessionPaymentMethodCreate,
        RedirectPaymentMethodCreate,
        CardPaymentMethodCreate,
    ],
)


class CreatePaymentMethodRequestTypedDict(TypedDict):
    request_body: BodyTypedDict
    timeout_in_seconds: NotRequired[float]
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class CreatePaymentMethodRequest(BaseModel):
    request_body: Annotated[
        Body, FieldMetadata(request=RequestMetadata(media_type="application/json"))
    ]

    timeout_in_seconds: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1

    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""
