"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .digitalwalletcreate import DigitalWalletCreate, DigitalWalletCreateTypedDict
from gr4vy.types import BaseModel
from gr4vy.utils import (
    FieldMetadata,
    HeaderMetadata,
    QueryParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ConfigureDigitalWalletGlobalsTypedDict(TypedDict):
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ConfigureDigitalWalletGlobals(BaseModel):
    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""


class ConfigureDigitalWalletRequestTypedDict(TypedDict):
    digital_wallet_create: DigitalWalletCreateTypedDict
    timeout_in_seconds: NotRequired[float]
    merchant_account_id: NotRequired[str]
    r"""The ID of the merchant account to use for this request."""


class ConfigureDigitalWalletRequest(BaseModel):
    digital_wallet_create: Annotated[
        DigitalWalletCreate,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    timeout_in_seconds: Annotated[
        Optional[float],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 1

    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="x-gr4vy-merchant-account-id"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""The ID of the merchant account to use for this request."""
