"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy import utils
from gr4vy.models import errordetail as models_errordetail
from gr4vy.types import BaseModel, Nullable
from gr4vy.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated


class Error400Data(BaseModel):
    message: Nullable[str]
    r"""A human readable message that provides more context to the error."""

    TYPE: Annotated[
        Annotated[Optional[Literal["error"]], AfterValidator(validate_const("error"))],
        pydantic.Field(alias="type"),
    ] = "error"
    r"""Always `error`."""

    code: Optional[str] = "bad_request"
    r"""Always `bad_request`"""

    status: Optional[int] = 400
    r"""Always `400`."""

    details: Optional[List[models_errordetail.ErrorDetail]] = None
    r"""A list of details that further ellaborate on the error."""


class Error400(Exception):
    data: Error400Data

    def __init__(self, data: Error400Data):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, Error400Data)
