import { CfnCreationPolicy, CfnDeletionPolicy, CfnUpdatePolicy } from './cfn-resource-policy';
import { CfnTag } from './cfn-tag';
import { IResolvable } from './resolvable';
/**
 * This class contains functions for translating from a pure CFN value
 * (like a JS object { "Ref": "Bucket" })
 * to a form CDK understands
 * (like Fn.ref('Bucket')).
 *
 * While this file not exported from the module
 * (to not make it part of the public API),
 * it is directly referenced in the generated L1 code,
 * so any renames of it need to be reflected in cfn2ts/codegen.ts as well.
 *
 * @experimental
 */
export declare class FromCloudFormation {
    static parseValue(cfnValue: any): any;
    static getAny(value: any): any;
    static getBoolean(value: any): boolean | IResolvable;
    static getDate(value: any): Date | IResolvable;
    static getString(value: any): string;
    static getNumber(value: any): number;
    static getStringArray(value: any): string[];
    static getArray<T>(value: any, mapper: (arg: any) => T): T[];
    static getMap<T>(value: any, mapper: (arg: any) => T): {
        [key: string]: T;
    };
    static parseCreationPolicy(policy: any): CfnCreationPolicy | undefined;
    static parseUpdatePolicy(policy: any): CfnUpdatePolicy | undefined;
    static parseDeletionPolicy(policy: any): CfnDeletionPolicy | undefined;
    static getCfnTag(tag: any): CfnTag;
}
