"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFileAssetPackaging = exports.assertIsObject = exports.isObjectAnd = exports.isMapOf = exports.isString = exports.expectKey = void 0;
const file_asset_1 = require("../file-asset");
/**
 * Validate that a given key is of a given type in an object
 *
 * If not optional, the key is considered required.
 *
 * Uses predicate validators that return a 'witness', so we can use the return type of
 * the validator function to infer the actual type of the value and enrich the type information
 * of the given input field.
 *
 * In effect, validators should be written like this:
 *
 *   if (!valid(input)) { throw; }
 *   return input;
 */
function expectKey(obj, key, validate, optional) {
    if (typeof obj !== 'object' || obj === null || (!(key in obj) && !optional)) {
        throw new Error(`Expected key '${key}' missing: ${JSON.stringify(obj)}`);
    }
    if (key in obj) {
        try {
            validate(obj[key]);
        }
        catch (e) {
            throw new Error(`${key}: ${e.message}`);
        }
    }
}
exports.expectKey = expectKey;
function isString(x) {
    if (typeof x !== 'string') {
        throw new Error(`Expected a string, got '${x}'`);
    }
    return x;
}
exports.isString = isString;
function isMapOf(pred) {
    return x => {
        assertIsObject(x);
        Object.values(x).forEach(pred);
        return x;
    };
}
exports.isMapOf = isMapOf;
function isObjectAnd(p) {
    return x => {
        assertIsObject(x);
        return p(x);
    };
}
exports.isObjectAnd = isObjectAnd;
function assertIsObject(x) {
    if (typeof x !== 'object' || x === null) {
        throw new Error(`Expected a map, got '${x}'`);
    }
}
exports.assertIsObject = assertIsObject;
function isFileAssetPackaging(x) {
    const str = isString(x);
    const validValues = Object.values(file_asset_1.FileAssetPackaging); // Explicit cast needed because this is a string-valued enum
    if (!validValues.includes(str)) {
        throw new Error(`Expected a FileAssetPackaging (one of ${validValues.map(v => `'${v}'`).join(', ')}), got '${str}'`);
    }
    return x;
}
exports.isFileAssetPackaging = isFileAssetPackaging;
//# sourceMappingURL=data:application/json;base64,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