"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadMyPackageJson = void 0;
const path = require("path");
// tslint:disable:no-var-requires
/**
 * Get my package JSON.
 *
 * In principle it's just '__dirname/../../package.json', but in the monocdk
 * it will live at a different location. So search upwards.
 */
function loadMyPackageJson() {
    let dir = path.resolve(__dirname, '..', '..');
    while (true) {
        try {
            // eslint-disable-next-line @typescript-eslint/no-require-imports
            return require(path.join(dir, 'package.json'));
        }
        catch (e) {
            if (e.code !== 'MODULE_NOT_FOUND') {
                throw e;
            }
            const newdir = path.dirname(dir);
            if (newdir === dir) {
                throw new Error(`No package.json found upward of ${__dirname}`);
            }
            dir = newdir;
        }
    }
}
exports.loadMyPackageJson = loadMyPackageJson;
//# sourceMappingURL=data:application/json;base64,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