import * as ec2 from "../../../aws-ec2";
import * as ecs from "../../../aws-ecs";
import { CommonEcsRunTaskProps, EcsRunTaskBase } from './run-ecs-task-base';
/**
 * Properties to run an ECS task on EC2 in StepFunctionsan ECS
 */
export interface RunEcsEc2TaskProps extends CommonEcsRunTaskProps {
    /**
     * In what subnets to place the task's ENIs
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default Private subnets
     */
    readonly subnets?: ec2.SubnetSelection;
    /**
     * Existing security group to use for the task's ENIs
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default A new security group is created
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * Placement constraints
     *
     * @default No constraints
     */
    readonly placementConstraints?: ecs.PlacementConstraint[];
    /**
     * Placement strategies
     *
     * @default No strategies
     */
    readonly placementStrategies?: ecs.PlacementStrategy[];
}
/**
 * Run an ECS/EC2 Task in a StepFunctions workflow
 */
export declare class RunEcsEc2Task extends EcsRunTaskBase {
    constructor(props: RunEcsEc2TaskProps);
}
