"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.external = void 0;
/* istanbul ignore file */
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
const tls = require("tls");
const url = require("url");
let client;
function iam() {
    if (!client) {
        client = new aws.IAM();
    }
    return client;
}
function defaultLogger(fmt, ...args) {
    // tslint:disable-next-line: no-console
    console.log(fmt, ...args);
}
/**
 * Downloads the CA thumbprint from the issuer URL
 */
async function downloadThumbprint(issuerUrl) {
    exports.external.log(`downloading certificate authority thumbprint for ${issuerUrl}`);
    return new Promise((ok, ko) => {
        const purl = url.parse(issuerUrl);
        const port = purl.port ? parseInt(purl.port, 10) : 443;
        if (!purl.host) {
            return ko(new Error(`unable to determine host from issuer url ${issuerUrl}`));
        }
        const socket = tls.connect(port, purl.host, { rejectUnauthorized: false });
        socket.once('error', ko);
        socket.once('secureConnect', () => {
            const cert = socket.getPeerCertificate();
            socket.end();
            const thumbprint = cert.fingerprint.split(':').join('');
            exports.external.log(`certificate authority thumbprint for ${issuerUrl} is ${thumbprint}`);
            ok(thumbprint);
        });
    });
}
// allows unit test to replace with mocks
// tslint:disable:max-line-length
exports.external = {
    downloadThumbprint,
    log: defaultLogger,
    createOpenIDConnectProvider: (req) => iam().createOpenIDConnectProvider(req).promise(),
    deleteOpenIDConnectProvider: (req) => iam().deleteOpenIDConnectProvider(req).promise(),
    updateOpenIDConnectProviderThumbprint: (req) => iam().updateOpenIDConnectProviderThumbprint(req).promise(),
    addClientIDToOpenIDConnectProvider: (req) => iam().addClientIDToOpenIDConnectProvider(req).promise(),
    removeClientIDFromOpenIDConnectProvider: (req) => iam().removeClientIDFromOpenIDConnectProvider(req).promise(),
};
//# sourceMappingURL=data:application/json;base64,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