"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmChart = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class HelmChart extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._kubectlProvider;
        const timeout = (_a = props.timeout) === null || _a === void 0 ? void 0 : _a.toSeconds();
        if (timeout && timeout > 900) {
            throw new Error('Helm chart timeout cannot be higher than 15 minutes.');
        }
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: HelmChart.RESOURCE_TYPE,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._kubectlCreationRole.roleArn,
                Release: (_b = props.release) !== null && _b !== void 0 ? _b : this.node.uniqueId.slice(-53).toLowerCase(),
                Chart: props.chart,
                Version: props.version,
                Wait: (_c = props.wait) !== null && _c !== void 0 ? _c : false,
                Timeout: timeout,
                Values: (props.values ? stack.toJsonString(props.values) : undefined),
                Namespace: (_d = props.namespace) !== null && _d !== void 0 ? _d : 'default',
                Repository: props.repository,
            },
        });
    }
}
exports.HelmChart = HelmChart;
/**
 * The CloudFormation resource type.
 */
HelmChart.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-HelmChart';
//# sourceMappingURL=data:application/json;base64,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