"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryVisibility = exports.GitHubRepository = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const codestar = require("./codestar.generated");
/**
 * The GitHubRepository resource
 */
class GitHubRepository extends cdk.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.toString(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: (_a = props.enableIssues) !== null && _a !== void 0 ? _a : true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
/**
 * Visibility of the GitHubRepository
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    /**
     * private repository
     */
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    /**
     * public repository
     */
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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