"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineProject = void 0;
const codepipeline_artifacts_1 = require("./codepipeline-artifacts");
const codepipeline_source_1 = require("./codepipeline-source");
const project_1 = require("./project");
/**
 * A convenience class for CodeBuild Projects that are used in CodePipeline.
 */
class PipelineProject extends project_1.Project {
    constructor(scope, id, props) {
        super(scope, id, {
            source: new codepipeline_source_1.CodePipelineSource(),
            artifacts: new codepipeline_artifacts_1.CodePipelineArtifacts(),
            ...props,
        });
    }
}
exports.PipelineProject = PipelineProject;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwZWxpbmUtcHJvamVjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBpcGVsaW5lLXByb2plY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EscUVBQWlFO0FBQ2pFLCtEQUEyRDtBQUMzRCx1Q0FBd0Q7QUFJeEQ7O0dBRUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEsaUJBQU87SUFDeEMsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUN0RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNiLE1BQU0sRUFBRSxJQUFJLHdDQUFrQixFQUFFO1lBQ2hDLFNBQVMsRUFBRSxJQUFJLDhDQUFxQixFQUFFO1lBQ3RDLEdBQUcsS0FBSztTQUNYLENBQUMsQ0FBQztJQUNQLENBQUM7Q0FDSjtBQVJELDBDQVFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgQ29kZVBpcGVsaW5lQXJ0aWZhY3RzIH0gZnJvbSAnLi9jb2RlcGlwZWxpbmUtYXJ0aWZhY3RzJztcbmltcG9ydCB7IENvZGVQaXBlbGluZVNvdXJjZSB9IGZyb20gJy4vY29kZXBpcGVsaW5lLXNvdXJjZSc7XG5pbXBvcnQgeyBDb21tb25Qcm9qZWN0UHJvcHMsIFByb2plY3QgfSBmcm9tICcuL3Byb2plY3QnO1xuLy8gdHNsaW50OmRpc2FibGUtbmV4dC1saW5lOm5vLWVtcHR5LWludGVyZmFjZVxuZXhwb3J0IGludGVyZmFjZSBQaXBlbGluZVByb2plY3RQcm9wcyBleHRlbmRzIENvbW1vblByb2plY3RQcm9wcyB7XG59XG4vKipcbiAqIEEgY29udmVuaWVuY2UgY2xhc3MgZm9yIENvZGVCdWlsZCBQcm9qZWN0cyB0aGF0IGFyZSB1c2VkIGluIENvZGVQaXBlbGluZS5cbiAqL1xuZXhwb3J0IGNsYXNzIFBpcGVsaW5lUHJvamVjdCBleHRlbmRzIFByb2plY3Qge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wcz86IFBpcGVsaW5lUHJvamVjdFByb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgICAgICAgc291cmNlOiBuZXcgQ29kZVBpcGVsaW5lU291cmNlKCksXG4gICAgICAgICAgICBhcnRpZmFjdHM6IG5ldyBDb2RlUGlwZWxpbmVBcnRpZmFjdHMoKSxcbiAgICAgICAgICAgIC4uLnByb3BzLFxuICAgICAgICB9KTtcbiAgICB9XG59XG4iXX0=