"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = exports.PeriodOverride = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cloudwatch_generated_1 = require("./cloudwatch.generated");
const layout_1 = require("./layout");
/**
 * Specify the period for graphs when the CloudWatch dashboard loads
 */
var PeriodOverride;
(function (PeriodOverride) {
    /**
     * Period of all graphs on the dashboard automatically adapt to the time range of the dashboard.
     */
    PeriodOverride["AUTO"] = "auto";
    /**
     * Period set for each graph will be used
     */
    PeriodOverride["INHERIT"] = "inherit";
})(PeriodOverride = exports.PeriodOverride || (exports.PeriodOverride = {}));
/**
 * A CloudWatch dashboard
 */
class Dashboard extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.dashboardName,
        });
        this.rows = [];
        {
            const { dashboardName } = props;
            if (dashboardName && !core_1.Token.isUnresolved(dashboardName) && !dashboardName.match(/^[\w-]+$/)) {
                throw new Error([
                    `The value ${dashboardName} for field dashboardName contains invalid characters.`,
                    'It can only contain alphanumerics, dash (-) and underscore (_).',
                ].join(' '));
            }
        }
        new cloudwatch_generated_1.CfnDashboard(this, 'Resource', {
            dashboardName: this.physicalName,
            dashboardBody: core_1.Lazy.stringValue({ produce: () => {
                    const column = new layout_1.Column(...this.rows);
                    column.position(0, 0);
                    return core_1.Stack.of(this).toJsonString({
                        start: props.start,
                        end: props.end,
                        periodOverride: props.periodOverride,
                        widgets: column.toJson(),
                    });
                } }),
        });
        (props.widgets || []).forEach(row => {
            this.addWidgets(...row);
        });
    }
    /**
     * Add a widget to the dashboard.
     *
     * Widgets given in multiple calls to add() will be laid out stacked on
     * top of each other.
     *
     * Multiple widgets added in the same call to add() will be laid out next
     * to each other.
     */
    addWidgets(...widgets) {
        if (widgets.length === 0) {
            return;
        }
        const w = widgets.length > 1 ? new layout_1.Row(...widgets) : widgets[0];
        this.rows.push(w);
    }
}
exports.Dashboard = Dashboard;
//# sourceMappingURL=data:application/json;base64,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