import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import * as sns from "../../aws-sns";
import { Construct, IResource, RemovalPolicy, Resource } from "../../core";
/**
 * A backup vault
 */
export interface IBackupVault extends IResource {
    /**
     * The name of a logical container where backups are stored.
     *
     * @attribute
     */
    readonly backupVaultName: string;
}
/**
 * Properties for a BackupVault
 */
export interface BackupVaultProps {
    /**
     * The name of a logical container where backups are stored.
     *
     * @default - A CDK generated name
     */
    readonly backupVaultName?: string;
    /**
     * A resource-based policy that is used to manage access permissions on the
     * backup vault.
     *
     * @default - access is not restricted
     */
    readonly accessPolicy?: iam.PolicyDocument;
    /**
     * The server-side encryption key to use to protect your backups.
     *
     * @default - an Amazon managed KMS key
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * A SNS topic to send vault events to.
     *
     * @see https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html
     *
     * @default - no notifications
     */
    readonly notificationTopic?: sns.ITopic;
    /**
     * The vault events to send.
     *
     * @see https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html
     *
     * @default - all vault events if `notificationTopic` is defined
     */
    readonly notificationEvents?: BackupVaultEvents[];
    /**
     * The removal policy to apply to the vault. Note that removing a vault
     * that contains recovery points will fail.
     *
     * @default RemovalPolicy.RETAIN
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * Backup vault events
 */
export declare enum BackupVaultEvents {
    /** BACKUP_JOB_STARTED */
    BACKUP_JOB_STARTED = "BACKUP_JOB_STARTED",
    /** BACKUP_JOB_COMPLETED */
    BACKUP_JOB_COMPLETED = "BACKUP_JOB_COMPLETED",
    /** BACKUP_JOB_SUCCESSFUL */
    BACKUP_JOB_SUCCESSFUL = "BACKUP_JOB_SUCCESSFUL",
    /** BACKUP_JOB_FAILED */
    BACKUP_JOB_FAILED = "BACKUP_JOB_FAILED",
    /** BACKUP_JOB_EXPIRED */
    BACKUP_JOB_EXPIRED = "BACKUP_JOB_EXPIRED",
    /** RESTORE_JOB_STARTED */
    RESTORE_JOB_STARTED = "RESTORE_JOB_STARTED",
    /** RESTORE_JOB_COMPLETED */
    RESTORE_JOB_COMPLETED = "RESTORE_JOB_COMPLETED",
    /** RESTORE_JOB_SUCCESSFUL */
    RESTORE_JOB_SUCCESSFUL = "RESTORE_JOB_SUCCESSFUL",
    /** RESTORE_JOB_FAILED */
    RESTORE_JOB_FAILED = "RESTORE_JOB_FAILED",
    /** COPY_JOB_STARTED */
    COPY_JOB_STARTED = "COPY_JOB_STARTED",
    /** COPY_JOB_SUCCESSFUL */
    COPY_JOB_SUCCESSFUL = "COPY_JOB_SUCCESSFUL",
    /** COPY_JOB_FAILED */
    COPY_JOB_FAILED = "COPY_JOB_FAILED",
    /** RECOVERY_POINT_MODIFIED */
    RECOVERY_POINT_MODIFIED = "RECOVERY_POINT_MODIFIED",
    /** BACKUP_PLAN_CREATED */
    BACKUP_PLAN_CREATED = "BACKUP_PLAN_CREATED",
    /** BACKUP_PLAN_MODIFIED */
    BACKUP_PLAN_MODIFIED = "BACKUP_PLAN_MODIFIED"
}
/**
 * A backup vault
 */
export declare class BackupVault extends Resource implements IBackupVault {
    /**
     * Import an existing backup vault
     */
    static fromBackupVaultName(scope: Construct, id: string, backupVaultName: string): IBackupVault;
    readonly backupVaultName: string;
    /**
     * The ARN of the backup vault
     *
     * @attribute
     */
    readonly backupVaultArn: string;
    constructor(scope: Construct, id: string, props?: BackupVaultProps);
    private uniqueVaultName;
}
