from typing import Sequence, Tuple, Union

from .map_to_index import map_to_index, DUPLICATE_METHOD


def match(
    x: Sequence,
    targets: Union[dict, Sequence],
    duplicate_method: DUPLICATE_METHOD = "first",
) -> list[Union[int, None]]:
    """Find a matching value of each element of ``x`` in ``target``.

    Args:
        x (Sequence): Sequence of values to match.

        targets (Union[dict, Sequence]):
            Sequence of targets to be matched against. Alternatively, a
            dictionary generated by passing a sequence of targets to
            :py:meth:`~biocutils.map_to_index.map_to_index`.

    Returns:
        list[Union[int, None]]: List of length equal to ``x``, containing the
        integer position of each entry of ``x`` inside ``target``; or None,
        if the entry of ``x`` is None or cannot be found in ``target``.
    """
    if isinstance(targets, Sequence):
        targets = map_to_index(targets, duplicate_method=duplicate_method)
    indices = []
    for i, y in enumerate(x):
        if y is None or y not in targets:
            indices.append(None)
        else:
            indices.append(targets[y])
    return indices
