# Flask-Mix

Flask-Mix extends Flask by adding a `mix()` template helper that can be used to write the path to an asset managed by Laravel Mix into a template.

For those unfamiliar with Laravel mix, the library is described as an "elegant wrapper around Webpack for the 80% use case". See https://laravel-mix.com for more information.

## Installation

`pip install Flask-Mix`

## Quick Start

### Extend a Flask App with Flask-Mix

```
from flask import Flask
from flask_mix import Mix

mix = Mix()

app = Flask(__name__, static_url_path='', static_folder='static')
mix.init_app(app)
```

### Use Mix in Templates

Use the `mix()` template helper to get a versioned path to an asset.

For example, this:

```
<link rel="stylesheet" href="{{ mix('/css/app.css') }}" />
```

Will output this:

```
<link rel="stylesheet" href="/css/app.css?id=875403388f63c4da5686" />
```

### Manage Assets with Laravel Mix

1. In the project root, along side the `static` and `templates` directories, create an `assets` directory.
2. Add a `package.json` file to the `assets` directory and install the dependencies for Laravel Mix: `npm i -D laravel-mix cross-env`.
3. Add a `webpack.mix.js` file to the `assets` directory and configure it to ingest source files from the `assets` directory and build them to the `static` directory.
4. Add the scripts below to the you `package.json` file.

```
"scripts": {
    "dev": "npm run development",
    "development": "cross-env NODE_ENV=development node_modules/webpack/bin/webpack.js --progress --hide-modules --config=node_modules/laravel-mix/setup/webpack.config.js",
    "watch": "npm run development -- --watch",
    "hot": "cross-env NODE_ENV=development node_modules/webpack-dev-server/bin/webpack-dev-server.js --inline --hot --config=node_modules/laravel-mix/setup/webpack.config.js",
    "prod": "npm run production",
    "production": "cross-env NODE_ENV=production node_modules/webpack/bin/webpack.js --no-progress --hide-modules --config=node_modules/laravel-mix/setup/webpack.config.js"
},
```

If you follow this method, you will need to add the `--prefix` flag to all npm commands. Provide the relative path to the assets directory after the `--prefix` flag. For example, `npm install --prefix assets`.

To build assets for dev, run `npm run dev --prefix assets` or `npm run watch --prefix assets`.

To build assets for production, run `npm run prod --prefix assets`.

It's recommended to ignore the static assets built by Laravel Mix in your `.gitignore` file and to build these assets from source for both development and production.

See the working [example](https://github.com/knicklabs/flask-mix/tree/master/example)  in this repository for a simple project setup.

## Settings

Flask-Mix can be configured with the following options:

- `MIX_ASSETS_BASE_URL`
    - *Default*: `''`
    - *Optional*: Provide a full domain if assets are on another domain, e.g. CDN
    - May be automatically set if running Laravel Mix in hot mode
- `MIX_MANIFEST_PATH`
    - *Default*: `os.path.join(app.static_folder, 'mix-manifest.json'))`
    - *Required*: This file is generated by Laravel Mix and needs to be read for versioning.
- `MIX_HOT_PATH`
    - *Default*: `os.path.join(app.static_folder, 'hot'))`
    - *Required*: This file is generated by Laravel Mix and needs to be read for hot mode.

## Example

This repository contains a demo that you can refer to for project setup.  You can take it for a spin to see how Flask, Flask-Mix, and Laravel Mix work together.

Follow these steps to get going:

1. Install Python dependencies: `pip install -r example/requirements.txt`
1. Install frontend dependencies: `npm install --prefix example/assets`
2. Build frontend assets and watch for changes: `npm run dev --prefix example/assets`
3. Run the web app: `python -m example.app`
4. View the web app in your browser: `open http://localhost:5000`

## Credits

This library was based off of [flask-webpack](https://github.com/nickjj/flask-webpack/tree/master/flask_webpack) and [flask-manage-webpack](https://pypi.org/project/Flask-Manage-Webpack/).

## License

[MIT License](https://github.com/knicklabs/flask-mix/blob/master/LICENSE)
