"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ASSET_PREFIX_SEPARATOR = exports.ASSET_RESOURCE_METADATA_ORIGINAL_PATH_KEY = exports.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = exports.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = exports.ASSET_RESOURCE_METADATA_PATH_KEY = exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = void 0;
/**
 * If this is set in the context, the aws:asset:xxx metadata entries will not be
 * added to the template. This is used, for example, when we run integrationt
 * tests.
 */
exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = 'aws:cdk:enable-asset-metadata';
/**
 * Metadata added to the CloudFormation template entries that map local assets
 * to resources.
 */
exports.ASSET_RESOURCE_METADATA_PATH_KEY = 'aws:asset:path';
exports.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = 'aws:asset:dockerfile-path';
exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = 'aws:asset:docker-build-args';
exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = 'aws:asset:docker-build-target';
exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = 'aws:asset:property';
exports.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = 'aws:asset:is-bundled';
exports.ASSET_RESOURCE_METADATA_ORIGINAL_PATH_KEY = 'aws:asset:original-path';
/**
 * Separator string that separates the prefix separator from the object key separator.
 *
 * Asset keys will look like:
 *
 *    /assets/MyConstruct12345678/||abcdef12345.zip
 *
 * This allows us to encode both the prefix and the full location in a single
 * CloudFormation Template Parameter.
 */
exports.ASSET_PREFIX_SEPARATOR = '||';
//# sourceMappingURL=data:application/json;base64,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