"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Intrinsic = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stack_trace_1 = require("../stack-trace");
const token_1 = require("../token");
/**
 * Token subclass that represents values intrinsic to the target document language.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @stability stable
 */
class Intrinsic {
    /**
     * @stability stable
     */
    constructor(value, options = {}) {
        var _b;
        jsiiDeprecationWarnings._aws_cdk_core_IntrinsicProps(options);
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = ((_b = options.stackTrace) !== null && _b !== void 0 ? _b : true) ? stack_trace_1.captureStackTrace() : [];
        this.value = value;
    }
    /**
     * Produce the Token's value at resolution time.
     *
     * @stability stable
     */
    resolve(_context) {
        jsiiDeprecationWarnings._aws_cdk_core_IResolveContext(_context);
        return this.value;
    }
    /**
     * Convert an instance of this Token to a string.
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     *
     * @stability stable
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON.
     *
     * Called automatically when JSON.stringify() is called on a Token.
     *
     * @stability stable
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return '<unresolved-token>';
    }
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     *
     * @param message Error message.
     * @stability stable
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join('\n    at ')}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
_a = JSII_RTTI_SYMBOL_1;
Intrinsic[_a] = { fqn: "@aws-cdk/core.Intrinsic", version: "1.134.0" };
function isFunction(x) {
    return typeof x === 'function';
}
//# sourceMappingURL=data:application/json;base64,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