import { FingerprintOptions } from './options';
/**
 * Produces fingerprint based on the contents of a single file or an entire directory tree.
 *
 * Line endings are converted from CRLF to LF.
 *
 * The fingerprint will also include:
 * 1. An extra string if defined in `options.extra`.
 * 2. The symlink follow mode value.
 *
 * @param fileOrDirectory The directory or file to fingerprint
 * @param options Fingerprinting options
 */
export declare function fingerprint(fileOrDirectory: string, options?: FingerprintOptions): string;
export declare function contentFingerprint(file: string): string;
