import { DockerImageAsset } from './docker-image-asset';
import { FileAsset } from './file-asset';
/**
 * Definitions for the asset manifest.
 *
 * @stability stable
 */
export interface AssetManifest {
    /**
     * Version of the manifest.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * The file assets in this manifest.
     *
     * @default - No files
     * @stability stable
     */
    readonly files?: {
        [id: string]: FileAsset;
    };
    /**
     * The Docker image assets in this manifest.
     *
     * @default - No Docker images
     * @stability stable
     */
    readonly dockerImages?: {
        [id: string]: DockerImageAsset;
    };
}
