
# Mailshell - msl

<div align=center>

![Logo](https://raw.githubusercontent.com/malkiAbdoo/mailshell/master/images/msl_logo.png)

send and check emails faster from the terminal using Mailshell

[![PyPI](https://img.shields.io/pypi/v/mailshell?label=pypi%20version&logo=pypi)](https://pypi.org/project/mailshell/)
[![GitHub issues](https://img.shields.io/github/issues/malkiAbdoo/mailshell)](https://github.com/malkiAbdoo/mailshell/issues)
[![GitHub](https://img.shields.io/github/license/malkiAbdoo/mailshell?label=Mailshell%20license)](https://github.com/malkiAbdoo/mailshell/blob/master/LICENSE)

</div>

## Requirements

- python 3.7+
- Linux or MacOS

## Installation

python `pip` install
```bash
$ python -m pip install mailshell
```
Support python 3.7+

## Usage

just type `msl` followed by one of the mailshell commands
```bash
$ msl login
```
- add **`--version`** option to see your current version
- type `msl login` to log in with gamil [app password][appp], and `msl new` to create a new message
- use `msl set` command to write your email using [nano][GNU-nano] editor or `msl html` to add html message, and `msl add` with a file or image to include it.
```bash
$ msl add ./file.pdf
```
- you can also add a text from a txt file with `-f` option in `set` and `html` command
```bash
$ msl set -f ./your_text.txt
```
- use `msl content` to see your message content, and add `--files` or `--images` to see a list of the message attachments. 
- run `msl send` to send your message to specified accounts.
- you can use `msl check` command to check your emails with a specified mailbox with `-b` option (default: `Inbox`) and some [selection options][sc] such as `--all` and `--from`, and use `-l` to display the output as a list.
```bash
$ msl check -b sent --date 18-Sep-2015
email(1)
email(2)
email(3)
 ...
```
- use the same selection options in `msl delete` to delete the selected emails in the mailbox
```bash
$ msl delete -t "You won.." -n
```

## Commands

Use **`--help`** in mailshell to see the available commands:

| Command          | Description                                                            |
|------------------|------------------------------------------------------------------------|
| login            | log in to your gmail using email address and the [app password][appp]  |
| cred             | print your current email address and app password                      |
| new              | create new email message                                               |
| subject          | set a new subject to the message                                       |
| from             | set a new sender name                                                  |
| html             | add [html][html] message                                               |
| content          | see the current message content with the included files                |
| set              | add a text manually or from **.txt** file to you current message       |
| add              | add a file or image to your message                                    |
| rm               | remove a file or image from your message                               |
| to               | set your contact that you will send to                                 |
| send             | send the current message                                               |
| check            | check your emails with a specified mailbox and [selection options][sc] |
| delete           | delete the selected email with the delete options in mailbox           |
| logout           | log out from your gmail account                                        |

```bash
$ msl --help
```

## Support

For support, Follow on twitter [@malkiAbdoo](https://twitter.com/malkiAbdoo).


<!-- References -->

[appp]:https://support.google.com/accounts/answer/185833?hl=en#app-passwords
[sc]:https://www.marshallsoft.com/ImapSearch.htm
[GNU-nano]:https://en.wikipedia.org/wiki/GNU_nano
[html]:https://en.wikipedia.org/wiki/HTML

